/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.datatypes;

import org.apache.fop.pdf.PDFGoTo;

public class IDNode {
    private String idValue;
    private String internalLinkGoToPageReference;
    private PDFGoTo internalLinkGoTo;
    private String pageNumber;
    private int xPosition = 0;
    private int yPosition = 0;

    protected IDNode(String idValue) {
        this.idValue = idValue;
    }

    protected void setPageNumber(String pageNumber) {
        this.pageNumber = pageNumber;
    }

    public String getPageNumber() {
        return this.pageNumber;
    }

    public String getPageReference() {
        if (null != this.internalLinkGoTo) {
            return this.internalLinkGoTo.getPageReference();
        }
        return this.internalLinkGoToPageReference;
    }

    public int getXPosition() {
        return this.xPosition;
    }

    public int getYPosition() {
        return this.yPosition;
    }

    protected void createInternalLinkGoTo(int objectNumber) {
        this.internalLinkGoTo = this.internalLinkGoToPageReference == null ? new PDFGoTo(objectNumber, null) : new PDFGoTo(objectNumber, this.internalLinkGoToPageReference);
        if (this.xPosition != 0) {
            this.internalLinkGoTo.setXPosition(this.xPosition);
            this.internalLinkGoTo.setYPosition(this.yPosition);
        }
    }

    protected void setInternalLinkGoToPageReference(String pageReference) {
        if (this.internalLinkGoTo != null) {
            this.internalLinkGoTo.setPageReference(pageReference);
        } else {
            this.internalLinkGoToPageReference = pageReference;
        }
    }

    protected String getInternalLinkGoToReference() {
        return this.internalLinkGoTo.referencePDF();
    }

    protected String getIDValue() {
        return this.idValue;
    }

    protected PDFGoTo getInternalLinkGoTo() {
        return this.internalLinkGoTo;
    }

    protected boolean isThereInternalLinkGoTo() {
        return this.internalLinkGoTo != null;
    }

    protected void setPosition(int x, int y) {
        if (this.internalLinkGoTo != null) {
            this.internalLinkGoTo.setXPosition(x);
            this.internalLinkGoTo.setYPosition(y);
        } else {
            this.xPosition = x;
            this.yPosition = y;
        }
    }
}

