/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.fo.flow.ListItem;
import org.apache.fop.layout.AccessibilityProps;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AuralProps;
import org.apache.fop.layout.BackgroundProps;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.BorderAndPadding;
import org.apache.fop.layout.MarginProps;
import org.apache.fop.layout.RelativePositionProps;

public class ListBlock
extends FObj {
    int align;
    int alignLast;
    int breakBefore;
    int breakAfter;
    int lineHeight;
    int startIndent;
    int endIndent;
    int spaceBefore;
    int spaceAfter;
    int spaceBetweenListRows = 0;

    public static FObj.Maker maker() {
        return new Maker();
    }

    public ListBlock(FObj parent, PropertyList propertyList, String systemId, int line, int column) {
        super(parent, propertyList, systemId, line, column);
    }

    public String getName() {
        return "fo:list-block";
    }

    public int layout(Area area) throws FOPException {
        if (this.marker == -1000) {
            AccessibilityProps mAccProps = this.propMgr.getAccessibilityProps();
            AuralProps mAurProps = this.propMgr.getAuralProps();
            BorderAndPadding bap = this.propMgr.getBorderAndPadding();
            BackgroundProps bProps = this.propMgr.getBackgroundProps();
            MarginProps mProps = this.propMgr.getMarginProps();
            RelativePositionProps mRelProps = this.propMgr.getRelativePositionProps();
            this.align = this.properties.get("text-align").getEnum();
            this.alignLast = this.properties.get("text-align-last").getEnum();
            this.lineHeight = this.properties.get("line-height").getLength().mvalue();
            this.startIndent = this.properties.get("start-indent").getLength().mvalue();
            this.endIndent = this.properties.get("end-indent").getLength().mvalue();
            this.spaceBefore = this.properties.get("space-before.optimum").getLength().mvalue();
            this.spaceAfter = this.properties.get("space-after.optimum").getLength().mvalue();
            this.spaceBetweenListRows = 0;
            this.marker = 0;
            if (area instanceof BlockArea) {
                area.end();
            }
            if (this.spaceBefore != 0) {
                area.addDisplaySpace(this.spaceBefore);
            }
            if (this.isInTableCell) {
                this.startIndent += this.forcedStartOffset;
                this.endIndent += area.getAllocationWidth() - this.forcedWidth - this.forcedStartOffset;
            }
            String id = this.properties.get("id").getString();
            try {
                area.getIDReferences().initializeID(id, area);
            }
            catch (FOPException e) {
                if (!e.isLocationSet()) {
                    e.setLocation(this.systemId, this.line, this.column);
                }
                throw e;
            }
        }
        BlockArea blockArea = new BlockArea(this.propMgr.getFontState(area.getFontInfo()), area.getAllocationWidth(), area.spaceLeft(), this.startIndent, this.endIndent, 0, this.align, this.alignLast, this.lineHeight);
        blockArea.setTableCellXOffset(area.getTableCellXOffset());
        blockArea.setGeneratedBy(this);
        ++this.areasGenerated;
        if (this.areasGenerated == 1) {
            blockArea.isFirst(true);
        }
        blockArea.setParent(area);
        blockArea.setPage(area.getPage());
        blockArea.setBackground(this.propMgr.getBackgroundProps());
        blockArea.start();
        blockArea.setAbsoluteHeight(area.getAbsoluteHeight());
        blockArea.setIDReferences(area.getIDReferences());
        int numChildren = this.children.size();
        int i = this.marker;
        while (i < numChildren) {
            if (!(this.children.get(i) instanceof ListItem)) {
                this.log.error("children of list-blocks must be list-items");
                return 1;
            }
            ListItem listItem = (ListItem)this.children.get(i);
            int status = listItem.layout(blockArea);
            if (Status.isIncomplete(status)) {
                if (status == 2 && i > 0) {
                    status = 3;
                }
                this.marker = i;
                blockArea.end();
                area.addChild(blockArea);
                area.increaseHeight(blockArea.getHeight());
                return status;
            }
            ++i;
        }
        blockArea.end();
        area.addChild(blockArea);
        area.increaseHeight(blockArea.getHeight());
        if (this.spaceAfter != 0) {
            area.addDisplaySpace(this.spaceAfter);
        }
        if (area instanceof BlockArea) {
            area.start();
        }
        blockArea.isLast(true);
        return 1;
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj parent, PropertyList propertyList, String systemId, int line, int column) throws FOPException {
            return new ListBlock(parent, propertyList, systemId, line, column);
        }
    }
}

