/*
 * Decompiled with CFR 0.152.
 */
package org.bardsoftware.impl.eclipsito;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.osgi.framework.Bundle;

public class BundleClassLoader
extends URLClassLoader {
    static final String PACKED_JAR = "org.bardsoftware.eclipsito.packedjar";
    private ArrayList myParentBundles = new ArrayList();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.bardsoftware.impl.eclipsito.BundleClassLoader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public BundleClassLoader() {
        super(new URL[0]);
    }

    public BundleClassLoader(URL[] defaultUrls, ClassLoader mainParent) {
        super(new URL[0], mainParent);
        int i = 0;
        while (i < defaultUrls.length) {
            URL next = defaultUrls[i];
            if (next.getProtocol().equals(PACKED_JAR) && next.getFile().endsWith(".jar")) {
                super.addURL(this.unpackJar(next));
            } else {
                super.addURL(next);
            }
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected URL unpackJar(URL packedJarUrl) {
        URL uRL;
        if (!$assertionsDisabled) {
            if (packedJarUrl == null) throw new AssertionError();
            if (!PACKED_JAR.equals(packedJarUrl.getProtocol())) {
                throw new AssertionError();
            }
        }
        String className = packedJarUrl.getHost();
        InputStream in = null;
        try {
            try {
                Class<?> clazz = Class.forName(className);
                String path = packedJarUrl.getPath();
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                if ((in = clazz.getClassLoader().getResourceAsStream(path)) == null) {
                    throw new RuntimeException("Failed to access input stream addressed by path=" + packedJarUrl.getPath() + " of URL=" + packedJarUrl);
                }
                File file = File.createTempFile("org.bardsoftware.eclipsito.WebStartBootImpl-", ".jar");
                if (file == null) {
                    throw new RuntimeException("Null file created");
                }
                this.saveStream(in, file);
                uRL = file.toURL();
                Object var7_10 = null;
                if (in == null) return uRL;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new RuntimeException("Failed to find class mentioned in packed JAR URL=" + packedJarUrl, e);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException("Failed to extract jar addressed by url=" + packedJarUrl, e);
            }
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to extract jar addressed by url=" + packedJarUrl, e);
            }
        }
        try {}
        catch (IOException e) {
            throw new RuntimeException("Failed to extract jar addressed by url=" + packedJarUrl, e);
        }
        in.close();
        return uRL;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveStream(InputStream inputStream, File outFile) throws IOException {
        FileOutputStream out = new FileOutputStream(outFile);
        try {
            int bytes_read;
            byte[] buf = new byte[4096];
            while ((bytes_read = inputStream.read(buf)) != -1) {
                out.write(buf, 0, bytes_read);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            out.close();
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        out.close();
    }

    public void addURL(URL url) {
        super.addURL(url);
    }

    public void addParent(Bundle dependencyBundle) {
        this.myParentBundles.add(dependencyBundle);
    }

    protected Bundle[] parents() {
        return (Bundle[])this.myParentBundles.toArray(new BundleClassLoader[this.myParentBundles.size()]);
    }

    public Class findClass(String name) throws ClassNotFoundException {
        Class result = null;
        int i = 0;
        while (i < this.myParentBundles.size()) {
            Bundle nextParent = (Bundle)this.myParentBundles.get(i);
            try {
                result = nextParent.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (result != null) break;
            ++i;
        }
        if (result == null) {
            result = super.findClass(name);
        }
        return result;
    }
}

