/*
 * Decompiled with CFR 0.152.
 */
package org.bardsoftware.impl.eclipsito;

import java.net.URI;
import java.util.logging.Level;
import org.bardsoftware.eclipsito.Boot;
import org.bardsoftware.impl.eclipsito.BundleImpl;
import org.bardsoftware.impl.eclipsito.DependencyResolver;
import org.bardsoftware.impl.eclipsito.ExtensionRegistryImpl;
import org.bardsoftware.impl.eclipsito.ExtensionsProcessor;
import org.bardsoftware.impl.eclipsito.JobManagerImpl;
import org.bardsoftware.impl.eclipsito.PluginDescriptor;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class PlatformImpl
extends Platform {
    private IExtensionRegistry myExtensionRegistry;
    private Bundle[] myBundles;
    private URI myHome;

    protected PlatformImpl(URI home) {
        PlatformImpl.setInstance(this);
        this.myHome = home;
    }

    protected void setup(PluginDescriptor[] descriptors) {
        PluginDescriptor[] resolved = new DependencyResolver(descriptors).resolveAll();
        this.myBundles = this.createBundles(resolved);
        IExtensionPoint[] points = ExtensionsProcessor.resolveExtensionPoints(resolved);
        this.myExtensionRegistry = new ExtensionRegistryImpl(points);
    }

    public void start() {
        int i = 0;
        while (this.myBundles != null && i < this.myBundles.length) {
            try {
                int state = this.myBundles[i].getState();
                if (state == 2 || state == 4) {
                    this.myBundles[i].start();
                }
            }
            catch (BundleException e) {
                Boot.LOG.log(Level.WARNING, e.getMessage(), e);
            }
            ++i;
        }
    }

    public void stop() {
        int i = 0;
        while (this.myBundles != null && i < this.myBundles.length) {
            try {
                if (this.myBundles[i].getState() == 32) {
                    this.myBundles[i].stop();
                }
            }
            catch (BundleException e) {
                Boot.LOG.log(Level.WARNING, e.getMessage(), e);
            }
            ++i;
        }
    }

    protected IExtensionRegistry getExtensionRegistryImpl() {
        return this.myExtensionRegistry;
    }

    protected Bundle getBundleImpl(String symbolicName) {
        Bundle result = null;
        int i = 0;
        while (this.myBundles != null && i < this.myBundles.length) {
            if (this.myBundles[i].getSymbolicName().equals(symbolicName)) {
                if (this.myBundles[i].getState() == 2) {
                    try {
                        this.myBundles[i].start();
                    }
                    catch (BundleException e) {
                        Boot.LOG.log(Level.WARNING, e.getMessage(), e);
                    }
                }
                result = this.myBundles[i];
                break;
            }
            ++i;
        }
        return result;
    }

    private Bundle[] createBundles(PluginDescriptor[] descriptors) {
        if (descriptors == null) {
            throw new IllegalArgumentException("Could not create Bundles if there are no descriptors");
        }
        Bundle[] result = new Bundle[descriptors.length];
        int i = 0;
        while (i < descriptors.length) {
            result[i] = new BundleImpl(descriptors[i]);
            ++i;
        }
        return result;
    }

    protected IJobManager getJobManagerImpl() {
        return JobManagerImpl.getInstance();
    }
}

