/*
 * Created on 22.09.2005
 */
package org.ganttproject.impex.htmlpdf;

import java.net.URL;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

abstract class StylesheetFactoryImpl {
    Stylesheet[] createStylesheets(Class stylesheetInterface) {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] configElements = extensionRegistry
                .getConfigurationElementsFor(stylesheetInterface.getName());
        Stylesheet[] result = (Stylesheet[])java.lang.reflect.Array.newInstance(
                stylesheetInterface, configElements.length);
        for (int i = 0; i < configElements.length; i++) {
            try {
                //Object nextExtension = configElements[i].createExecutableExtension("class");
                //assert nextExtension!=null && nextExtension instanceof HTMLStylesheet : "Extension="+nextExtension+" is expected to be instance of HTMLStylesheet";
                String localizedName = configElements[i].getAttribute("name");
                String pluginRelativeUrl = configElements[i].getAttribute("url");
                String namespace = configElements[i].getDeclaringExtension().getNamespace();
                URL stylesheetUrl = Platform.getBundle(namespace).getResource(pluginRelativeUrl);
                assert stylesheetUrl!=null : "Failed to resolve url="+pluginRelativeUrl;
                result[i] = newStylesheet(Platform.resolve(stylesheetUrl), localizedName);
            }
            catch(Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    protected abstract Stylesheet newStylesheet(URL url, String localizedName);
}
