package net.sourceforge.ganttproject.test.task;

import java.awt.Color;

import junit.framework.TestCase;
import net.sourceforge.ganttproject.calendar.AlwaysWorkingTimeCalendarImpl;
import net.sourceforge.ganttproject.calendar.GPCalendar;
import net.sourceforge.ganttproject.resource.HumanResourceManager;
import net.sourceforge.ganttproject.resource.ResourceManager;
import net.sourceforge.ganttproject.roles.RoleManager;
import net.sourceforge.ganttproject.roles.RoleManagerImpl;
import net.sourceforge.ganttproject.task.TaskManager;
import net.sourceforge.ganttproject.task.TaskManagerConfig;
import net.sourceforge.ganttproject.time.TimeUnitStack;
import net.sourceforge.ganttproject.time.gregorian.GregorianTimeUnitStack;

/**
 * Created by IntelliJ IDEA. User: bard
 */
public abstract class TaskTestCase extends TestCase implements
        TaskManagerConfig {
    private TaskManager myTaskManager;

    private GPCalendar myFakeCalendar = new AlwaysWorkingTimeCalendarImpl();

    private TimeUnitStack myTimeUnitStack;

    private ResourceManager myResourceManager;

    private RoleManager myRoleManager;

    protected TaskManager getTaskManager() {
        return myTaskManager;
    }

    protected void setUp() throws Exception {
        super.setUp();
        myTimeUnitStack = new GregorianTimeUnitStack();
        myTaskManager = newTaskManager();
        myRoleManager = new RoleManagerImpl();
        myResourceManager = new HumanResourceManager(myRoleManager
                .getDefaultRole());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        myTaskManager = null;
    }

    public Color getDefaultColor() {
        return null;
    }

    public GPCalendar getCalendar() {
        return myFakeCalendar;
    }

    public TimeUnitStack getTimeUnitStack() {
        return myTimeUnitStack;
    }

    public ResourceManager getResourceManager() {
        return myResourceManager;
    }

    protected TaskManager newTaskManager() {
        return TaskManager.Access.newInstance(null, this);
    }
}