package org.ganttproject.impex.msproject;

import java.awt.BorderLayout;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;

import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

import net.sourceforge.ganttproject.gui.options.GeneralOptionPanel;
import net.sourceforge.ganttproject.gui.options.TopPanel;
import net.sourceforge.ganttproject.language.GanttLanguage;

class LocaleChooserPanel extends JPanel {

    private LocalePanel localePanel = null;

    private static GanttLanguage lang = GanttLanguage.getInstance();

    /** Constructor. */
    public LocaleChooserPanel() {
        super();

        JPanel result = new JPanel(new BorderLayout());
        result.setBorder(new EmptyBorder(0, 5, 0, 5));
        TopPanel topPanel = new TopPanel(lang.getText("mpxLanguageSettings"),
                lang.getText("mpxLanguageSettingsComment"));
        topPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        result.add(topPanel, BorderLayout.NORTH);
        localePanel = new LocalePanel();
        result.add(localePanel, BorderLayout.CENTER);

        add(result);
    }

    public Locale getSelectedLocale() {
        return localePanel.getSelectedLocale();
    }

    static class LocalePanel extends GeneralOptionPanel {

        private static final String LOCALE_FR = "Franais";

        private static final String LOCALE_EN = "English";

        private static Map mapLocales = null;

        static {
            mapLocales = new HashMap();
            mapLocales.put(LOCALE_EN, Locale.US);
            mapLocales.put(LOCALE_FR, Locale.FRANCE);
        }

        private JComboBox combo = null;

        public LocalePanel() {
            super("", "");
            combo = new JComboBox(new Vector(mapLocales.keySet()));
            vb.add(combo);
            Locale currentLocale = GanttLanguage.getInstance().getLocale();
            try {
                combo.setSelectedItem(getString(currentLocale));
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        public boolean applyChanges(boolean askForApply) {
            return false;
        }

        public void initialize() {
            // nothing
        }

        Locale getSelectedLocale() {
            return (Locale) mapLocales.get(combo.getSelectedItem());
        }

        private static Locale getLocale(String locale) {
            return (Locale) mapLocales.get(locale);
        }

        private static String getString(Locale locale) {
            String res = null;
            Iterator it = mapLocales.keySet().iterator();
            while (it.hasNext()) {
                res = (String) it.next();
                if (mapLocales.get(res).equals(locale))
                    break;
            }
            return res;
        }
    }

}
