/*******************************************************************************
*---|
*---|     Garnaxbot by Freakster http://garnax.mircx.com/
*---|
*---|     Garnaxbot is distributed in the hope that it will be useful,
*---|     but WITHOUT ANY WARRANTY; without even the implied warranty of
*---|     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*---|
********************************************************************************
*---|
*---|     File:            fserve.h
*---|     Created:         Fri Dec 13 23:09:29 CST 2002
*---|     Last Edited:
*---|     Description:     This file contains the declarations of the
*---|                      basic structures of the fserve.
*---|
*******************************************************************************/
#ifndef FSERVE_H
#define FSERVE_H

#include "general.h"
#include "structs.h"

char *filesize(unsigned int size, unsigned int overflow);
char *bracket(char *msg, ...);
char *fserve_ad(channelstruct *chan);
int resume_file(char *host, int socket, int offset);
int fserve(channelstruct *chan, char *nick, char* host);
int in_use(char *nick, char *host, dccptr *dcclist, char *type);

dccstruct *create_dcc();
int bind_listen(dccstruct *dcc);
int dcc_accpet(dccstruct *dcc);

int fserve_entry(dccstruct *fserve);
int readmessage(dccstruct *fserve);
int chat_read(dccstruct *fserve);
int chat_parse(dccstruct *fserve, char *buff);
int change_directory(dccstruct *fserve, char *newpath);
int senddirlist(dccstruct *fserve);
filestruct * addfile(char *filename, int filesize, filestruct *start);
int filecompare (char *f1, char *f2);
char *getpath(pathstruct *path);
int pwd (dccstruct *fserve);

dccstruct *make_queue(dccstruct *fserve, char *path, int fileptr, int size);
int send_handler(dccstruct *fserve, char *path, int fileptr, int size);
int queue_handler(dccstruct *fserve, char *path, int fileptr, int size, int sndcnt);
int dcc_send(dccstruct *dcc);
int send_next();
unsigned int total_send_speed();
void adjust_speedcap();
void update_stats();
int display_fserve(channelstruct *chan);

#ifdef debug
void print_queues(dccptr *list, char *type);
#endif

int show_dccs(int sock, char *action, char *target, int num, char *type);
int clear_queues(char *nick, int sock, char *action, char *target);
int del_queue(int sock, int num, char *nick, char *host);
int send_queue(char *action, char *target, int ctr);
int purge_dcc(char *action, char *target, int ctr, char *type);
void change_queue_nick(char *nick, char *newnick, char *host);

THREADFUNC fserve_thread(THREADARG arg);
THREADFUNC sends_thread(THREADARG arg);
int send_bytes(dccstruct *dcc);
int retr_ack(dccstruct *dcc);
#endif

