/*******************************************************************************
*---|
*---|   Garnaxbot by Freakster http://garnax.mircx.com/
*---|
*---|   Garnaxbot is distributed in the hope that it will be useful,
*---|   but WITHOUT ANY WARRANTY; without even the implied warranty of
*---|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*---|
********************************************************************************
*---|
*---|   File:          GENERAL.C
*---|   Created:       Fri Dec 13 22:14:39 CST 2002
*---|   Last Edited:   Wed Nov 26 01:00:16 CST 2003
*---|   Description:   General functions that are useful to
*---|                  all aspects of the program.
*---|
*******************************************************************************/

#include "general.h"

/*******************************************************************************
*---|   Function:      LOGPRINTF
*---|   Created:       Wed Aug 27 23:01:51 CDT 2003
*---|   Last Edited:   Wed Nov 26 00:47:22 CST 2003
*---|   Description:   Prints out a timestamp as well as a message.
*******************************************************************************/

void logprintf(char *msg, ...)
{

    long t = 0;
    struct tm *curtime = NULL;
    char buff[BUFFSIZE] = { '\0' };
    va_list ap;

    va_start(ap, msg);
    vsnprintf(buff, BUFFSIZE, msg, ap);
    va_end(ap);

    time(&t);
    curtime = localtime(&t);
    fprintf(stdout, "%02d:%02d:%02d ", curtime->tm_hour, curtime->tm_min, curtime->tm_sec);
    fprintf(stdout, "%s", buff);

    return ;
}

void errorlog(char *msg, ...)
{

    long t = 0;
    struct tm *curtime = NULL;
    char buff[BUFFSIZE] = { '\0' };
    va_list ap;
    FILE *fp = fopen("error.log", "a");

    va_start(ap, msg);
    vsnprintf(buff, BUFFSIZE, msg, ap);
    va_end(ap);

    time(&t);
    curtime = localtime(&t);

#ifdef debug

    fprintf(stdout, "%02d:%02d:%02d ", curtime->tm_hour, curtime->tm_min, curtime->tm_sec);
    fprintf(stdout, "%s", buff);
#endif

    if (!fp)
        return ;

    fprintf(fp, "%02d:%02d:%02d ", curtime->tm_hour, curtime->tm_min, curtime->tm_sec);
    fprintf(fp, "%s", buff);

    fclose(fp);



    return ;
}

/*******************************************************************************
*---|     Function:        MYMALLOC
*---|     Created:         Fri Dec 13 22:14:39 CST 2002
*---|     Last Edited:     Wed Nov 26 02:14:30 CST 2003
*---|     Description:     Duplicates a string.
*---|                      Critical if it fails.
*******************************************************************************/

char *mymalloc(char *text)
{

    char *ptr = NULL;

    if (text)
    {

        ptr = strdup(text);
        if (ptr == NULL)
        {
            errorlog("ERROR: malloc failed trying to add [%s] - %s\n", text, strerror(errno));
            alive = 0;
        }
    }

    return ptr;
}

/*******************************************************************************
*---|     Function:        GETTIME
*---|     Created:         Fri Dec 13 22:14:39 CST 2002
*---|     Last Edited:     Wed Nov 26 01:55:11 CST 2003
*---|     Description:     Takes a value of seconds and calculates 
*---|                      the ascii amount of time it equals to.
*******************************************************************************/

char *gettime(time_t time)
{
    int dys = 86400, hrs = 3600, min = 60;
    int t = time, mins = 0, hours = 0, days = 0;
    char *buff = NULL, tmp[BUFFSIZE] = { '\0' }, junk[BUFFSIZE] = { '\0' };

    memset(junk, 0, BUFFSIZE);

    if (t > dys)
    {
        days = t / dys;
        t = t % dys;
        if (days == 1)
            sprintf(tmp, "%d day ", days);
        else
            sprintf(tmp, "%d days ", days);
        strcat(junk, tmp);
    }
    if (t > hrs)
    {
        hours = t / hrs;
        t = t % hrs;
        if (hours == 1)
            sprintf(tmp, "%d hour ", hours);
        else
            sprintf(tmp, "%d hours ", hours);
        strcat(junk, tmp);
    }
    if (t > min)
    {
        mins = t / min;
        t = t % min;
        if (mins == 1)
            sprintf(tmp, "%d min ", mins);
        else
            sprintf(tmp, "%d mins ", mins);
        strcat(junk, tmp);
    }

    if (t == 1)
        sprintf(tmp, "%d second", t);
    else
        sprintf(tmp, "%d secs", t);
    strcat(junk, tmp);

    buff = mymalloc(junk);

    return buff;

}

/*******************************************************************************
*---|     Function:        QUOTE
*---|     Created:         Fri Dec 13 22:14:39 CST 2002
*---|     Last Edited:     Tue Aug  5 12:59:00 CDT 2003
*---|     Description:     Puts together a dynamic message to send
*---|                      to a server.
*******************************************************************************/

int quote(int sock, char *msg, ...)
{
    va_list ap;
    char buff[BUFFSIZE] = { '\0' };

    va_start(ap, msg);
    vsnprintf(buff, BUFFSIZE, msg, ap);
    va_end(ap);

    return send_data(sock, buff);
}

/*******************************************************************************
*---|     Function:        SEND_DATA
*---|     Created:         Fri Dec 13 22:14:39 CST 2002
*---|     Last Edited:     Wed Nov 26 02:04:38 CST 2003
*---|     Description:     Sends data out a socket.
*******************************************************************************/

int send_data(int sock, char *buff)
{
    int status = SUCCESS, len = 0, tmp = 0;
    struct timeval tv;
    fd_set fd;

    if (sock == 0)
    {
        return FAILURE;
    }

#ifdef debug
    logprintf("Sending: %s", buff);
#endif

    len = strlen(buff);
    while (tmp < len)
    {
        FD_ZERO(&fd);
        FD_SET(sock, &fd);
        tv.tv_sec = 10;
        tv.tv_usec = 0;
        status = select(sock + 1, (fd_set*)0, &fd, (fd_set*)0, &tv);

        if (status > 0)
        {
            status = send(sock, &buff[tmp], len - tmp, 0);
            if (status <= 0)
            {
#ifdef debug
                logprintf("Failed to send: %s %s", buff, strerror(errno));
#endif

                close(sock);
                sock = 0;
                return FAILURE;
            }
            tmp += status;
        }
        else
        {
            return FAILURE;
        }
    }
    return SUCCESS;
}

/*******************************************************************************
*---|     Function:        LOWERCASE
*---|     Created:         Fri Dec 13 22:14:39 CST 2002
*---|     Last Edited:     Fri Dec 13 22:27:12 CST 2002
*---|     Description:     Turns a string to all lower case.
*******************************************************************************/

void lowercase(char *buff)
{
    int i = 0;
    char *c = &buff[i];
    while (*c)
    {
        if (*c <= 'Z' && *c >= 'A')
            *c += 'a' - 'A';
        c = &buff[++i];
    }
    return ;
}

/*******************************************************************************
*---|     Function:        LOWERCASECMP
*---|     Created:         Fri Dec 13 22:14:39 CST 2002
*---|     Last Edited:     Tue Aug  5 13:01:54 CDT 2003
*---|     Description:     Checks equality of two strings
*---|                      regardless of case.
*******************************************************************************/

int lowercasecmp(char *s1, char *s2)
{
    int status = 1;
    char *string1 = NULL, *string2 = NULL;

    if (s1 && s2)
    {

        string1 = mymalloc(s1);
        lowercase(string1);

        string2 = mymalloc(s2);
        lowercase(string2);

        status = strcmp(string1, string2);

        if (string1)
            free(string1);
        string1 = NULL;

        if (string2)
            free(string2);
        string2 = NULL;
    }
    return status;
}

/*******************************************************************************
*---|   Function:      SETIP
*---|   Created:       Mon Dec 16 01:08:38 CST 2002
*---|   Last Edited:   Wed Nov 26 13:48:36 CST 2003
*---|   Description:   Tries to resolve a hostname.
*******************************************************************************/

unsigned long setip(char *host)
{
    struct hostent *he;
    struct sockaddr_in addr;

    if ((he = gethostbyname(host)) != NULL)
    {
        addr.sin_addr = *((struct in_addr *)he->h_addr);
#ifdef debug

        logprintf("DCC Hostname:[%s] IP Address:[%s]\n", he->h_name, inet_ntoa(*((struct in_addr *)he->h_addr)));
#endif

        return (unsigned long)addr.sin_addr.s_addr;

    }
    return 0;
}

/*******************************************************************************
*---|   Function:      JOIN_CHANS
*---|   Created:       Mon Dec 16 01:08:38 CST 2002
*---|   Last Edited:   Wed Nov 26 14:03:14 CST 2003
*---|   Description:   Join all of the bot's channels.
*******************************************************************************/

int join_chans()
{
    channelstruct *chan = bot->channels;
    int status = SUCCESS;

    while (chan != NULL)
    {
        /* Bot is in the channel */
        if (chan->settings & BOTONCHAN)
        {
            /*
            if (((chan->settings & BOTISOP) == 0) && (bot->nickpass)) {
             status = quote(bot->sock, "CHANSERV :op %s\r\n", chan->name);
            }
            */
        }

        /* Bot is not in the channel */
        else
        {
            /* Invite myself in if it's set as invite only */
            if ((chan->settings & INVITEIN) && (bot->nickpass))
            {
                status = quote(bot->sock, "CHANSERV :invite %s\r\n", chan->name);
            }

            /* Use the key if a key is specified */
            if (chan->key)
            {
                status = quote(bot->sock, "JOIN %s %s\r\n", chan->name, chan->key);
            }

            /* just try to join the channel */
            else
            {
                status = quote(bot->sock, "JOIN %s\r\n", chan->name);
            }
        }
        chan = chan->next;
    }

    return status;
}

/*******************************************************************************
*---|   Function:      GETTIMEOFDAY
*---|   Created:       Thu Dec 11 19:40:11 CST 2003
*---|   Last Edited:   
*---|   Description:   There is no gettimeofday function for windows.
*---|                  so I made one that can be used in the fserve and
*---|                  sends thread. I only use it for timing measurements
*---|                  such as < a second, not for determining the time.
*******************************************************************************/

#ifdef WIN32
void gettimeofday(struct timeval *tv, struct timeval *notused) {

    __int64 t1, t2;
	float t = 0;

    QueryPerformanceCounter(&t1);
    QueryPerformanceFrequency(&t2);

	t = (float)t1/t2;

	tv->tv_sec = (long)t;
	tv->tv_usec = (long)((t - tv->tv_sec) * 1000000);

	return;
}
#endif
