/*******************************************************************************
*---|
*---|     Garnaxbot by Freakster http://garnax.mircx.com/
*---|
*---|     Garnaxbot is distributed in the hope that it will be useful,
*---|     but WITHOUT ANY WARRANTY; without even the implied warranty of
*---|     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*---|
********************************************************************************
*---|
*---|     File:            headers.h
*---|     Created:         Sun Dec 15 22:25:35 CST 2002
*---|     Last Edited:     Thu Jul 31 15:34:59 CDT 2003
*---|     Description:     This file contains all of the header
*---|                      files and structures useful to the program.
*---|
*******************************************************************************/

#ifndef HEADERS_H
#define HEADERS_H

/*******************************************************************************
**----| 
**----| When defined, the bot will not fork into the background
**----| and it will print out everything it sees as well as other
**----| general information
#define debug
*******************************************************************************/

/*******************************************************************************
**----| 
**----| When defined, the bot will partake in the eggdrop uptime contest.
**----| http://uptime.eggheads.org/
**----| 
*******************************************************************************/
#define UPTIMECONTEST

#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <stdarg.h> 
/*#include <dmalloc.h>
*/

#ifdef WIN32

#include <winsock2.h>
#include <windows.h>
#include <time.h>
#include <process.h>

#define usleep(x) Sleep(x/1000)
#define sleep(x) Sleep(x*1000)
#define close(x) closesocket(x)
#define EADDRINUSE WSAEADDRINUSE
#define errno WSAGetLastError()
#define getpid() _getpid()

#define pthread_t HANDLE
#define pthread_mutex_t HANDLE
#define THREADFUNC DWORD WINAPI
#define THREADARG PVOID

#define pthread_mutex_lock(x) WaitForSingleObject(*x, INFINITE)
#define pthread_mutex_unlock(x) ReleaseMutex(*x)
#define pthread_exit(x) return (x)
#define vsnprintf(a,b,c,d) _vsnprintf(a,b,c,d)

char *botdir;
long botlen;

#define MODEL           "WinGarnax"

/******************************************************************************/

#else

#include <netdb.h>
#include <pthread.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/time.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>
#include <stdarg.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include <fcntl.h>

#define MODEL   "Garnaxbot"
#define THREADFUNC void *
#define THREADARG void *

#endif

/******************************************************************************/

#define VERSION   "f1.1.0"

#define BITSET(x,y) x = x | y
#define BITCLR(x,y) x = x & ~y

#define MAX_UINT ~((unsigned int)0)
#define LCASE(x) ((x<='Z' && x>='A')?(x-'A'+'a'):(x))
#define WEBSITE   "http://garnax.mircx.com/"
#define BUFFSIZE  512
#define BLOCKSIZE  1024

#define FAILURE   0
#define SUCCESS   1

#define REHASH         0
#define READCFG         1
#define CONNECT         2
#define READDATA        3
#define RECONNECT       4
#define RESTART         5
#define DIE             6

/* used in stat() */
#ifndef S_IFDIR
#define S_IFDIR  0040000
#endif

#ifndef S_IFREG
#define S_IFREG  0100000
#endif

/******************************************************************************/

typedef struct pathstruct
{
    char *name;
    struct pathstruct *next;
    struct pathstruct *prev;
}
pathstruct;

typedef struct dirstruct
{
    char *name;
    char *dir;
    struct dirstruct *next;
}
dirstruct;

typedef struct filestruct
{
    char *name;
    int size;
    struct filestruct *next;
    struct filestruct *prev;
}
filestruct;

#define DCCACCEPT  1
#define DCCCHAT    2
#define DCCSEND    3
#define DCCDONE    4

typedef struct dccstruct
{
    /* All */
    char *chan;
    char *nick;
    char *host;

    long lastdata;
    int warned;

    /* Fserve */
    time_t starttime;
    pathstruct *head, *tail;
    char *dir_name;
    char *dir_path;

    int die, state, sock, type;

    char *path;
    char *filename;
    unsigned int speed, ctr, offset, size;
    unsigned short port;
    unsigned long ackval;
    FILE *file;

    struct dccstruct *next, *prev;
}
dccstruct;

typedef struct dccptr
{
    int total, each, count;
    dccstruct *start, *end;
}
dccptr;

/******************************************************************************/

#define USERVOICE 0x01
#define USERHOP   0x02
#define USEROP    0x04
typedef struct userstruct
{
    char *nick;
    char *host;
    unsigned char modes;
    struct userstruct *next;
}
userstruct;

/******************************************************************************/

#define BOTONCHAN 0x01
#define BOTISOP   0x02
#define REHASHED  0x04
#define DISPLAYAD 0x08
#define DCCWATCH  0x10
#define INVITEIN  0x20
typedef struct channelstruct
{
    struct channelstruct *next;
    unsigned char settings;

    char *name;
    char *key;

    char *desc;
    char *welcomemsg;
    char *trigger;

    int delay;
    time_t delaytime;

    dirstruct *directories;

    userstruct *masters;
    userstruct *banned;
    userstruct *users;

}
channelstruct;

/******************************************************************************/

typedef struct serverstruct
{
    char *name;
    unsigned short port;
    struct serverstruct *next;
}
serverstruct;

/******************************************************************************/

#define EXPAND   0x01
#define CTCPTRIG 0x02
#define DCCIP    0x04
#define FSERVEON 0x08

typedef struct networkstruct
{
    char *filename;
    char *pidfile;
    char *statfile;
    char *transferlog;

    char *nickkeep;
    char *nickpass;
    char *nick;

    char *ob;
    char *cb;

    char color1[3];
    char color2[3];

    char *servername;
    char *vhost;
    unsigned char settings;

    int sock;
    int state;
    int restart;

    time_t chktime;
    time_t contime;
    int connectdelay;

    struct serverstruct *server;
    struct serverstruct *servers;
    struct channelstruct *channels;

    int minport;
    int maxport;

    unsigned int totalcap;
    unsigned int tmpcap;
    unsigned int sendcap;
    unsigned int forcesize;
    unsigned int minspeed;

    unsigned int failcount;
    unsigned int filecount;
    unsigned int accesscount;
    unsigned int maxspeed;
    unsigned int avespeed;
    unsigned int bytecount;
    unsigned int overflowcount;

    unsigned long ip;

    dccptr *fserves;
    dccptr *sends;
    dccptr *queues;

}
networkstruct;

time_t runtime;
networkstruct *bot;
int alive;
pthread_mutex_t mutex;
pthread_mutex_t dccmutex;


#endif
