/*******************************************************************************
*---|
*---|   Garnaxbot by Freakster http://garnax.mircx.com/
*---|
*---|   Garnaxbot is distributed in the hope that it will be useful,
*---|   but WITHOUT ANY WARRANTY; without even the implied warranty of
*---|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*---|
********************************************************************************
*---|
*---|   File:          MAIN.C
*---|   Created:       Sun July 21 2002
*---|   Last Edited:   Wed Nov 26 00:14:22 CST 2003
*---|   Description:   Sets up signal routines and goes into the
*---|                  bot routine.
*---|
*---|   There is one main for nix and two for windows.  The nix one
*---|   handles both debug and nondebug while there is a seperate main
*---|   for each in windows
*---|
*******************************************************************************/

#include "headers.h"
#include "general.h"
#include "routine.h"

/*******************************************************************************
*---|     Function:        SIGKILLBOT
*---|     Created:         Sat Dec 14 01:47:04 CST 2002
*---|     Last Edited:
*---|     Description:     Shuts down the bot.
*******************************************************************************/

void sigkillbot(int signum)
{
    char *t = gettime(time(NULL) - runtime);

	#ifdef debug
	logprintf("\nCaught signal %d\n", signum);
	#endif

    quote(bot->sock, "QUIT :Killed - Runtime: %s\n", t);
    free(t);

    alive = 0;

    return ;
}

#ifndef WIN32 
/*******************************************************************************
*---|     Function:        SIGHUP
*---|     Created:         Sat Dec 14 01:47:04 CST 2002
*---|     Last Edited:     Wed Nov 26 01:27:13 CST 2003
*---|     Description:     Resets the bot, which causes it to
*---|                      reread the config.
*******************************************************************************/

void sighup(int signum)
{
	#ifdef debug
	logprintf("\nCaught a SIGHUP.  Setting up for a rehash.\n");
	#endif

    bot->restart = 2;

    return ;
}

/*******************************************************************************
*---|   Function:       MAIN (nix)
*---|   Created:        Sun Dec 15 18:56:01 CST 2002
*---|   Last Edited:    Wed Nov 26 00:17:24 CST 2003
*---|   Description:    Examine command line args and setup signaling.
*******************************************************************************/

int main (int argc, char **argv)
{

#ifdef debug
    int i = 0;
    if (argc == 2)
    {
        for (i = 0; i < argc; i++)
        {
            printf("Argv[%d] = %s\n", i, argv[i]);
        }
    }
#endif
    if (argc != 2)
    {
        printf("Syntax: %s config.file\n", argv[0]);
        exit(1);
    }

    /* Global variable to tell us to keep running */
    alive = 1;

    /* Keep track of how long the process has been running. */
    runtime = time(NULL);

    signal(1, sighup);      /* SIGHUP */
    signal(2, sigkillbot);  /* SIGINT */
    signal(13, SIG_IGN);    /* SIGPIPE */
    signal(15, sigkillbot); /* SIGTERM */
    signal(16, SIG_IGN);    /* SIGURG */

    bot_routine(argv[1]);

    return 0;

}
#else

/*******************************************************************************
*---|   Function:       MAIN (Win32 Console App)
*---|   Created:        Sun Dec 15 18:56:01 CST 2002
*---|   Last Edited:    Sat Jul 26 11:44:37 CDT 2003
*******************************************************************************/

#ifdef debug
int main(int argc, char **argv)
{

    WSADATA wsaData;
    char *lpCmdLine = NULL;
    if ((argc != 2) || (WSAStartup(0x202, &wsaData) != 0))
    {
        printf("Syntax: %s config.file\n", argv[0]);
        WSACleanup();
        exit(1);
    }
    else
    {
        printf("Command line arguments: %s %s\n", argv[0], argv[1]);
    }
    lpCmdLine = argv[1];

#else

/*******************************************************************************
*---|   Function:       WINMAIN (Win32 App)
*---|   Created:        Sun Dec 15 18:56:01 CST 2002
*---|   Last Edited:    Sat Jul 26 11:44:37 CDT 2003
*******************************************************************************/

WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{

    WSADATA wsaData;
    if ((WSAStartup(0x202, &wsaData) != 0) || (lpCmdLine == NULL))
    {
        WSACleanup();
        exit(1);
    }

#endif /* This part is the same for the debug or non debug version */


    /* State to tell us to keep running */
    alive = 1;
    /* Keep track of how long the process has been running */
    runtime = time(NULL);

    /* Windows doesn't have all of the same signals as nix */
    signal(SIGINT, sigkillbot);
    signal(SIGTERM, sigkillbot);

    /* Find out the working directory for the exe.  When a specific
    ** files needs accessed we will be changing the current directory to
    ** that directory until we no longer need access to that file. Then
    ** we will change back to the working directory of the bot so not to
    ** get lost in the filesystem.  There is probably a better way to
    ** handle this.  */

    botlen = GetCurrentDirectory(0, NULL);
    botdir = (char*)malloc(sizeof(char) * botlen + 1);
    GetCurrentDirectory(botlen, botdir);

    bot_routine(lpCmdLine);

    free(botdir);
    botdir = NULL;
    botlen = 0;

    WSACleanup();

    return 0;
}
#endif


