/*******************************************************************************
*---|
*---|     Garnaxbot by Freakster http://garnax.mircx.com/
*---|
*---|     Garnaxbot is distributed in the hope that it will be useful,
*---|     but WITHOUT ANY WARRANTY; without even the implied warranty of
*---|     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*---|
********************************************************************************
*----|
*----|     File:            parse.c
*----|     Last Edited:
*----|     Created:         Sun Dec 15 22:47:27 CST 2002
*----|     Description:     This file contains the routine to
*----|                      parse the data recieved on a connection.
*----|
*******************************************************************************/

#include "parse.h"

/*******************************************************************************
*---|   Function:      PROCESS_DATA
*---|   Created:       Mon Dec 16 00:39:52 CST 2002
*---|   Last Edited:   Wed Nov 26 14:06:15 CST 2003
*---|   Description:   Examine Data and Determine course of action.
*******************************************************************************/

int process_data(int argc, char **argv)
{
    char *full = NULL, *nick = NULL, *host = NULL, *tmp = NULL, *ad = NULL;
    int status = SUCCESS, i = 0;
    int mode = 0, ctr = 0, x = 0, len = 0;
    channelstruct *chan = NULL;
    userstruct *user = NULL;

    /* SOURCE ACTION TARGET :MESSAGE
    ** SOURCE = nick!ident@host
    ** TARGET = channel or botnick
    */

    /* RAWS */
    if (atoi(argv[1]))
    {
        return process_raws(argc, argv);
    }

    /* Make a copy of the full address */
    full = mymalloc(argv[0]);
    if (!full)
        return FAILURE;

    /* Point nick to the nickname */
    nick = argv[0];

    for (i = 0; (argv[0][i] != '\0'); i++)
    {
        /* Null terminate the nickname */
        if (argv[0][i] == '!')
        {
            argv[0][i] = '\0';
        }
        /* get the host portion */
        if (argv[0][i] == '@')
        {
            host = &argv[0][i + 1];
        }
    }

    /* Server message or message from something not in the form of nick!ident@host */
    if (!host)
    {
        host = full;
        nick = full;
    }

#ifdef debug
    logprintf("Full:[%s] Nick:[%s] Host:[%s]\n", full, nick, host);
#endif

    /* If we get a :#chan instead of a #chan, make it point to #chan
    ** If we get a :newnick instead of a newnick, make it point to newnick */
    if (argv[2][0] == ':')
        argv[2] = &argv[2][1];

    chan = is_channel(argv[2]);

    /****************************
    *---|  FOR THE CHANNEL  |---*
    ****************************/
    if (chan)
    {
        /* PRIVMSG goes first because it occurs more often */
        if (lowercasecmp("PRIVMSG", argv[1]) == 0)
        {

            if ((user = is_user(chan, nick)) != NULL)
            {
                /* Updates the host of a user */
                status = add_user(chan, nick, host, 0);

                if ((status) && (is_member(chan->masters, full)))
                {
                    status = master_commands(argc, argv, argv[1], argv[2]);
                }
                /* status ok, fserve on, not banned user, !list or !list botnick only */
                if ((status) && (bot->settings & FSERVEON) && (!is_member(chan->banned, full))
                        && (lowercasecmp(argv[3], ":!list") == 0) && ((argc == 4) || ((argc == 5) && (lowercasecmp(argv[4], bot->nick) == 0))))
                {
                    ad = fserve_ad(chan);
                    status = quote(bot->sock, "NOTICE %s :%s\r\n", nick, ad);
                    free(ad);
                }
                /* not ctcp and fserve on */
                if (!(bot->settings & CTCPTRIG) && (bot->settings & FSERVEON))
                {
                    denull(argv[3], argc - 3);
                    if (lowercasecmp(chan->trigger, &argv[3][1]) == 0)
                    {
                        if (is_member(chan->banned, full))
                        {
                            status = quote(bot->sock, "NOTICE %s :Sorry, you are banned from the fserve.\r\n", nick);
                        }
                        else
                        {
                            status = fserve(chan, nick, host);
                        }
                    }
                }
            }
            /* else we got a message from someone not in the channel */

        }
        else if (lowercasecmp("JOIN", argv[1]) == 0)
        {
            /* Updates the host of a user if we don't have one from it yet */
            status = add_user(chan, nick, host, 0);

            /* We joined the channel */
            if (lowercasecmp(nick, bot->nick) == 0)
            {
                BITSET(chan->settings, BOTONCHAN);
            }
        }
        else if (lowercasecmp("PART", argv[1]) == 0)
        {
            /* I left */
            if (lowercasecmp(nick, bot->nick) == 0)
            {
                chan = remove_channel(chan);
                purge_fserves(chan->name);
                chan = delete_channel(chan);
            }

            /* someone I know left */
            else if ((user = is_user(chan, nick)))
            {
                if (chan->settings & DCCWATCH) {
					status = clear_queues(nick, bot->sock, "NOTICE", nick);
                }
                user = delete_user(remove_user(chan, nick));
            }
        }
        else if (lowercasecmp("KICK", argv[1]) == 0)
        {
            /* I was kicked out */
            if (lowercasecmp(argv[3], bot->nick) == 0)
            {
                destroy_users(chan);
                reset_channel(chan);
                if (chan->settings & INVITEIN)
                {
                    status = quote(bot->sock, "CHANSERV INVITE %s\r\n", chan->name);
                }
                if (chan->key)
                {
                    status = quote(bot->sock, "JOIN %s %s\r\n", argv[2], chan->key);
                }
                else
                {
                    status = quote(bot->sock, "JOIN :%s\r\n", argv[2]);
                }
            }

            /* Someone else was booted */
            else if (is_user(chan, argv[3]))
            {
                user = delete_user(remove_user(chan, argv[3]));
            }
        }
        /* ignore channel notices */
        else if (lowercasecmp("NOTICE", argv[1]) == 0)
        {}
        else if (lowercasecmp("MODE", argv[1]) == 0)
        {
            /* :Freakster!garnax@garnax.net MODE #bots -k+k cameltounge camelkidney */
            tmp = argv[3];
            ctr = 0;
            x = 0;
            len = strlen(tmp);
            while (ctr < len)
            {
#ifdef debug
                logprintf( "len = %d, ctr = %d, x = %d, mode = %d, modeletter = %c ", len, ctr, x, mode, tmp[ctr]);
                if (argv[4 + x])
                {
                    fprintf(stdout, "param = %s", argv[4 + x]);
                }
                fprintf(stdout, "\n");
#endif

                switch (tmp[ctr++])
                {
                case '+':
                    mode = 1;
                    break;
                case '-':
                    mode = 0;
                    break;
                case 'o':
                    if (mode) /* OP */
                    {
                        if ((user = is_user(chan, argv[4 + x])))
                        {
                            BITSET(user->modes, USEROP);
                            if (lowercasecmp(user->nick, bot->nick) == 0)
                            {
                                BITSET(chan->settings, BOTISOP);
                            }
                        }
                    }
                    else /* DEOP */
                    {
                        if ((user = is_user(chan, argv[4 + x])))
                        {
                            BITCLR(user->modes, USEROP);
                            if (lowercasecmp(user->nick, bot->nick) == 0)
                            {
                                BITCLR(chan->settings, BOTISOP);
                            }
                        }
                    }
                    x++;
                    break;
                case 'h':
                    if (mode) /* HOP */
                    {
                        if ((user = is_user(chan, argv[4 + x])))
                        {
                            BITSET(user->modes, USERHOP);
                            if (lowercasecmp(user->nick, bot->nick) == 0)
                            {
                                BITSET(chan->settings, BOTISOP);
                            }
                        }
                    }
                    else /* DEHOP */
                    {
                        if ((user = is_user(chan, argv[4 + x])))
                        {
                            BITCLR(user->modes, USERHOP);
                            if (lowercasecmp(user->nick, bot->nick) == 0)
                            {
                                BITCLR(chan->settings, BOTISOP);
                            }
                        }
                    }
                    x++;
                    break;
                case 'v':
                    if (mode) /* VOICE */
                    {
                        if ((user = is_user(chan, argv[4 + x])))
                        {
                            BITSET(user->modes, USERVOICE);
                        }
                    }
                    else /* DEVOICE */
                    {
                        if ((user = is_user(chan, argv[4 + x])))
                        {
                            BITCLR(user->modes, USERVOICE);
                        }
                    }
                    x++;
                    break;
                case 'b':     /* BAN */
                    x++;
                    break;
                case 'l':     /* LIMIT */
                    if (mode)
                    {
                        x++;
                    }
                    break;
                case 'k':     /* KEY */
                    if (chan->key)
                    {
                        free(chan->key);
                        chan->key = NULL;
                    }
                    if (mode)
                    {
                        chan->key = mymalloc(argv[4 + x]);
                        if (chan->key == NULL)
                        {
                            ctr = len;
                            status = FAILURE;
                            errorlog("Couldn't malloc new channel key\n");
                        }
                    }
                    x++;
                    break;
                case 'i':     /* INVITE ONLY */
                    break;
                default:
                    break;
                }
            }
        }
    }

    /************************
    *---|  FOR THE BOT  |---*
    ************************/

    else if (lowercasecmp(argv[2], bot->nick) == 0)
    {

        if (lowercasecmp("NOTICE", argv[1]) == 0)
        {
            /* bot notice from a master? */
            for (chan = bot->channels; chan != NULL; chan = chan->next)
            {
                if (is_member(chan->masters, full))
                {
                    status = master_commands(argc, argv, argv[1], nick);
                    break;
                }
            }

            denull(argv[3], argc - 3);

            /* message from nickserv, a server, and telling me to identify? */
            if ((status) && ((lowercasecmp(nick, "nickserv") == 0) || (lowercasecmp(nick, full) == 0))
                    && (maskcompare("*msg NickServ*IDENTIFY*", argv[3])))
            {
                /* identify for nickname if it's my specified nickname */
                if ((lowercasecmp(bot->nick, bot->nickkeep) == 0) && (bot->nickpass))
                {
                    status = quote(bot->sock, "NICKSERV identify %s\r\n", bot->nickpass);
                }
            }
        }
        if (lowercasecmp("INVITE", argv[1]) == 0)
        {
            /* :Freakster!PA@amd800.garnax.net INVITE Garnaxbot :#bots */
            /* Join on invite from master or chanserv */
            for (chan = bot->channels; (status && (chan != NULL)) ; chan = chan->next)
            {
                if ((lowercasecmp(nick, "ChanServ") == 0) || (is_member(chan->masters, full)))
                {
                    status = quote(bot->sock, "JOIN :%s\r\n", &argv[3][1]);
                }
            }
        }
        else if (lowercasecmp("PRIVMSG", argv[1]) == 0)
        {
            if ((argv[3][1] == '\001') && (argv[argc - 1][strlen(argv[argc - 1]) - 1] == '\001') )
            {
                /* this is a ctcp (or an action) */

                if ((argc >= 8) && (lowercasecmp(argv[4] , "resume") == 0))
                {
                    /* :Freakster!PA@amd800.garnax.net PRIVMSG GarnaxBot :DCC RESUME file.ext 4946 2640808 */
                    status = resume_file(host, atoi(argv[argc - 2]), atoi(argv[argc - 1]));
                }

                /* fserve on and ctcp triggers */
                if ((bot->settings & FSERVEON) && (bot->settings & CTCPTRIG))
                {
                    denull(argv[3], argc - 3);
                    argv[3] = &argv[3][2]; /* point to after the control character */
                    argv[argc - 1][strlen(argv[argc - 1]) - 1] = '\0';

#ifdef debug

                    logprintf( "CTCP: %s\n", argv[3]);
#endif

                    /* Does this ctcp match any of my triggers? */
                    for (chan = bot->channels; chan != NULL; chan = chan->next)
                    {

                        /* There is a risk that a bot could have the same
                        trigger and be serving two different things in two
                        seperate channels and if a user is in both channels,
                        when he tries to use the fserve he will always go
                        into the first fserve it finds and never into the
                        other one.  Recommendation: Use different triggers
                        if you're going to serve different stuff */

						/* A possible solution would be for each channel a
						** person shares with the bot, they get all of the
						** paths */
						

                        if (lowercasecmp(chan->trigger, argv[3]) == 0)
                        {
                            /* user is banned */
                            if (is_member(chan->banned, argv[0]))
                            {
                                status = quote(bot->sock, "NOTICE %s :Sorry, you are banned from the fserve.\r\n", nick);
                            }
                            /* user is in the channel that matches this trigger */
                            else if (is_user(chan, nick))
                            {
                                status = fserve(chan, nick, host);
                                break;
                            }

                        }
                    }
                }
            }
        }
    }

    /********************
    *---|  UNKNOWN  |---*
    ********************/
    else
    {
        if (lowercasecmp("QUIT", argv[1]) == 0)
        {
            for (chan = bot->channels; chan != NULL; chan = chan->next)
            {
                /* someone I know quit */
                if ((user = is_user(chan, nick)))
                {
                    if (chan->settings & DCCWATCH) {
                     status = clear_queues(nick, bot->sock, "NOTICE", nick);
                    }
                    user = delete_user(remove_user(chan, nick));
                }
            }

            /* It was me that quit */
            if (lowercasecmp(nick, bot->nick) == 0)
            {
                status = FAILURE;
            }

            /* it was someone with my nick, quickly take it back */
            else if (lowercasecmp(nick, bot->nickkeep) == 0)
            {
                status = quote(bot->sock, "NICK %s\r\n", bot->nickkeep);
            }
        }
        else if (lowercasecmp("NICK", argv[1]) == 0)
        {
            /* :CoreDump!~Parasite@garnax.net NICK :CoredumpBot */
            for (chan = bot->channels; chan != NULL; chan = chan->next)
            {
                /* Someone I know changed their nick */
                if ((user = is_user(chan, nick)))
                {
                    /* replace the old nick */
                    free(user->nick);
                    user->nick = mymalloc(argv[2]);
                    /* update user host */
                    if (!user->host)
                        user->host = mymalloc(host);
                    if ((user->nick == NULL) || (user->host == NULL))
                    {
                        status = FAILURE;
                        break;
                    }
                    change_queue_nick(nick, argv[2], host);
                }
            }
            /* I changed nicks */
            if ((status) && (lowercasecmp(nick, bot->nick) == 0))
            {
                status = bots_nick(&argv[2][1]);
            }
        }
        /* Server response to a PING */
        else if (lowercasecmp(argv[1], "PONG") == 0)
        {}
        /* On connection server message */
        else if (lowercasecmp(argv[2], "AUTH") == 0)
        {}
        else
        {
            denull(argv[0], argc);
            errorlog("Unknown Server Message:[%s].\n", argv[0]);
        }
    }


    if (full)
        free(full);

    full = NULL;
    host = NULL;
    nick = NULL;

    return status;
}

/*******************************************************************************
*---|     Function:        DENULL
*---|     Created:         Mon Dec 16 00:39:52 CST 2002
*---|     Last Edited:     
*---|     Description:     turns an argc/argv combo back into one long string
*******************************************************************************/

void denull(char *argv, int argc)
{
    int i;

    for (i = 1; i < argc; i++)
    {
        argv[strlen(argv)] = ' ';
    }
    return ;
}


/*******************************************************************************
*---|     Function:        IS_MEMBER
*---|     Created:         Mon Dec 16 00:39:52 CST 2002
*---|     Last Edited:
*---|     Description:     Checks to see if a usermask matches a member mask
*******************************************************************************/

userstruct * is_member(userstruct *users, char *fulladdress)
{
    userstruct *ptr = NULL;
    if (fulladdress)
    {
        for (ptr = users; ptr != NULL; ptr = ptr->next)
        {
            /*
            #ifdef debug
            logprintf( "Comparing [%s] with [%s]\n", fulladdress, ptr->host );
            #endif
            */

            if (maskcompare(ptr->host, fulladdress) == SUCCESS)
            {
#ifdef debug
                logprintf("Found a match: [%s] with [%s]\n", fulladdress, ptr->host);
#endif

                return ptr;
            }
        }
    }

    return ptr;
}

/*******************************************************************************
*---|     Function:        MASKCOMPARE
*---|     Created:         Mon Dec 16 00:39:52 CST 2002
*---|     Last Edited:
*---|     Description:     Compares a wildcard string with a text string.
*---|
*---|     NOTE: Have full address as the second argument.
*******************************************************************************/

int maskcompare(const char *s1, const char* s2)
{
    if (LCASE(s1[0]) == LCASE(s2[0]))
    {
        if (s2[0] == '\0')
            return 1;
        else
            return maskcompare(&s1[1], &s2[1]);
    }
    else if (s2[0] == '\0')
    {
        if (s1[0] == '*')
            return maskcompare(&s1[1], s2);
        else
            return 0;
    }
    else if (s1[0] == '*')
    {
        if (maskcompare(s1, &s2[1]))
            return 1;
        else
            return maskcompare(&s1[1], s2);
    }
    else if (s1[0] == '?')
    {
        return maskcompare(&s1[1], &s2[1]);
    }
    return 0;
}

/*******************************************************************************
*---|     Function:        UPTIME
*---|     Created:         Mon Dec 16 00:39:52 CST 2002
*---|     Last Edited:     
*---|     Description:     Returns the computer's uptime.
*******************************************************************************/

int uptime(char *action, char *target)
{
    char up[BUFFSIZE], *tmp = NULL, *br = NULL;
    int status = SUCCESS;

#ifdef WIN32
    __int64 f1, f2;

    QueryPerformanceCounter(&f1);
    QueryPerformanceFrequency(&f2);
#endif

    up[0] = 3;
    up[1] = bot->color1[0];
    up[2] = bot->color1[1];
    up[3] = '\0';

    strcat(up, "Hostname:");

    tmp = redirect_output("hostname");
    if (tmp == NULL)
    {
        return FAILURE;
    }
    br = bracket("%s", tmp);
    strcat(up, br);
    free(br);
    free(tmp);

    strcat(up, " OS:");

#ifdef WIN32

    tmp = redirect_output("ver");
#else

    tmp = redirect_output("uname -sr");
#endif

    if (tmp == NULL)
    {
        return FAILURE;
    }
    br = bracket("%s", tmp);
    strcat(up, br);
    free(br);
    free(tmp);

    strcat(up, " Uptime:");

#ifdef WIN32
    tmp = gettime((long)((float)f1 / (float)f2));
#else

    tmp = redirect_output("uptime");
#endif

    if (tmp == NULL)
    {
        return FAILURE;
    }
    br = bracket("%s", tmp);
    strcat(up, br);
    free(br);
    free(tmp);

    strcat(up, " ");
    br = bracket("%s %s", MODEL, VERSION);
    strcat(up, br);
    free(br);

    status = quote(bot->sock, "%s %s :%s\r\n", action, target, up);

    return status;
}

/*******************************************************************************
*---|     Function:        REDIRECT_OUTPUT
*---|     Created:         Fri Aug  1 14:02:43 CDT 2003
*---|     Last Edited:     
*---|     Description:     Forks a command into the background and
*---|                      puts the output into a buffer.
*******************************************************************************/

char *redirect_output(char *command)
{

    char *ptr = NULL, buff[BUFFSIZE] = { '\0' };
    FILE *fp;

#ifdef WIN32

    sprintf(buff, "%s > redirected.txt", command);
    system(buff);

    fp = fopen("redirected.txt", "r");
    if ((fp) && (fgets(buff, BUFFSIZE, fp)))
    {

        if (buff[0] == '\n')
        {
            fgets(buff, BUFFSIZE, fp);
        }

        buff[strlen(buff) - 1] = '\0';
        ptr = mymalloc(buff);

    }

    if (fp)
        fclose(fp);
    system("del redirected.txt");

#else

    int pid, mypipe[2];

    if (pipe(mypipe) != 0)
    {
#ifdef debug
        errorlog( "Can not create pipe for %s. %s\n", command, strerror(errno) );
#endif

        return mymalloc("Broken");
    }

    pid = fork();
    if (pid < 0)
    {
#ifdef debug
        errorlog( "Can not fork for %s. %s\n", command, strerror(errno) );
#endif

        close(mypipe[0]);
        close(mypipe[1]);
        return mymalloc("Broken");
    }
    else if (pid == 0)
    {
        /* put the write end of the pipe on top of stdout of the child
        ** any output from the system command can be read from pipe[0]
        */
        dup2(mypipe[1], 1);
        system(command);
        exit(0);
    }
    else
    {
        /* read in the text resulting from the child process */
        if ((fp = fdopen(mypipe[0], "r")) == NULL)
        {
#ifdef debug
            errorlog( "Can not fdopen mypipe[%d] for %s. %s\n", mypipe[0], command, strerror(errno) );
#endif

            ptr = mymalloc("Broken");
        }
        else if (fgets(buff, BUFFSIZE, fp) == NULL)
        {
#ifdef debug
            errorlog( "Can not read from pipe for %s. %s\n", command, strerror(errno) );
#endif

            ptr = mymalloc("Broken");
        }
        else
        {
            ptr = mymalloc(buff);
            ptr[strlen(ptr) - 1] = '\0';
        }

        wait(&pid);

        close(mypipe[0]);
        close(mypipe[1]);

    }
#endif

    return ptr;
}

/*******************************************************************************
*---|     Function:        REPORTSTATUS
*---|     Created:         Mon Dec 16 00:39:52 CST 2002
*---|     Last Edited:     Tue Aug  5 14:09:18 CDT 2003
*---|     Description:     Returns the bot's total runtime, connection
*---|                      time, and what server it's connected to.
*******************************************************************************/

int reportstatus(char *action, char *target)
{
    char *rt = gettime(time(NULL) - runtime), *ct = gettime(time(NULL) - bot->contime), *br = NULL, buff[BUFFSIZE] = { '\0' };
    int status = SUCCESS;

    if (rt && ct)
    {
        buff[0] = 3;
        buff[1] = bot->color1[0];
        buff[2] = bot->color1[1];
        buff[3] = '\0';

        strcat(buff, "Runtime:");
        br = bracket("%s", rt);
        strcat(buff, br);
        free(br);

        strcat(buff, " Connected:");
        br = bracket("%s", ct);
        strcat(buff, br);
        free(br);

        strcat(buff, " Server:");
        br = bracket("%s", bot->servername);
        strcat(buff, br);
        free(br);

        strcat(buff, " ");
        br = bracket("%s %s", MODEL, VERSION);
        strcat(buff, br);
        free(br);

        status = quote(bot->sock, "%s %s :%s\r\n", action, target, buff);
    }

    if (rt)
        free(rt);
    rt = NULL;

    if (ct)
        free(ct);
    ct = NULL;

    return status;
}

/*******************************************************************************
*---|   Function:      MASTER_COMMANDS
*---|   Created:       Mon Dec 23 12:03:31 CST 2002
*---|   Last Edited:   Wed Nov 26 16:08:12 CST 2003
*---|   Description:   Parse and carry out master commands.
*******************************************************************************/

int master_commands(int argc, char **argv, char *type, char *target)
{

    int ctr = 0, status = SUCCESS, arg = 4;
    char *tmp = (char*)malloc(sizeof(char) * (strlen(bot->nick) + 3) ), *ct = NULL;

    if (tmp == NULL)
    {
        return FAILURE;
    }

    sprintf(tmp, "*%s*", bot->nick);

    if (argc < 4)
    {
        free(tmp);
        tmp = NULL;
        return SUCCESS;
    }

    /* channel commands */
    if (lowercasecmp(argv[3], ":.up") == 0)
    {
        status = uptime(type, argv[2]);
    }
    else if (lowercasecmp(argv[3], ":.status") == 0)
    {
        status = reportstatus(type, argv[2]);
    }
    /*
    else if (lowercasecmp(argv[3], ":.do") == 0)
    {
     if (argc > 4)
     {
      denull(argv[4], argc - 4);
      status = quote(bot->sock, "%s\r\n", argv[4]);
     }
    }
    */

    /* A notice has one less argument than a channel message addressed to the bot
    ** nick!ident@host NOTICE bot :some command
    ** nick!ident@host PRIVMSG #channel :bot some command
    */
    if (lowercasecmp(type, "NOTICE") == 0)
    {
        arg--;
        /* Get rid of the : */
        argv[3] = &argv[3][1];
    }
    if ((lowercasecmp(type, "NOTICE") == 0) || (maskcompare(tmp, argv[3])))
    {
        if (argc > arg)
        {
            if (argc > arg + 2)
            {
                ctr = atoi(argv[arg + 2]);
                if (ctr < 0)
                    ctr = 0;
                if (lowercasecmp(argv[arg], "send") == 0)
                {
                    if (lowercasecmp(argv[arg + 1], "queue") == 0)
                    {
                        if (ctr > 0)
                        {
                            status = send_queue(type, target, ctr);
                        }
                    }
                }
                else if (lowercasecmp(argv[arg], "del") == 0)
                {
                    if ((lowercasecmp(argv[arg + 1], "queue") == 0) || (lowercasecmp(argv[arg + 1], "queues") == 0))
                    {
                        if (ctr > 0)
                        {
                            status = purge_dcc(type, target, ctr, "Queue");
                        }
                        else if (lowercasecmp(argv[arg + 2], "all") == 0)
                        {
                            killall_dccs(bot->queues, 0);
                            status = quote(bot->sock, "%s %s :Clearing all queues.\r\n", type, target);
                        }
                        else
                        {
                            status = clear_queues(argv[arg + 2], bot->sock, type, target);
                        }
                    }
                    else if ((lowercasecmp(argv[arg + 1], "send") == 0) || (lowercasecmp(argv[arg + 1], "sends") == 0))
                    {
                        if (ctr > 0)
                        {
                            status = purge_dcc(type, target, ctr, "Send");
                        }
                    }
                    else if ((lowercasecmp(argv[arg + 1], "fserve") == 0) || (lowercasecmp(argv[arg + 1], "fserve") == 0))
                    {
                        if (ctr > 0)
                        {
                            status = purge_dcc(type, target, ctr, "Fserve");
                        }
                    }
                }
                else if (lowercasecmp(argv[arg], "do") == 0)
                {
                    denull(argv[arg + 1], argc - arg + 1);
                    status = quote(bot->sock, "%s\r\n", argv[arg + 1]);
                }
            }
            if (argc > arg + 1)
            {
                ctr = atoi(argv[arg + 1]);
                if (ctr < 0)
                    ctr = 0;
            }
            if (lowercasecmp(argv[arg], "sends") == 0)
            {
                status = show_dccs(bot->sock, type, target, ctr, "Send");
            }
            else if (lowercasecmp(argv[arg], "queues") == 0)
            {
                status = show_dccs(bot->sock, type, target, ctr, "Queue");
            }
            else if (lowercasecmp(argv[arg], "fserves") == 0)
            {
                status = show_dccs(bot->sock, type, target, ctr, "Fserve");
            }
            else if ((lowercasecmp(argv[arg], "off") == 0) && (bot->settings & FSERVEON))
            {
                BITCLR(bot->settings, FSERVEON);
                status = quote(bot->sock, "%s %s :Shutting down fserve.\r\n", type, target);
            }
            else if ((lowercasecmp(argv[arg], "on") == 0) && ((bot->settings & FSERVEON) == 0))
            {
                BITSET(bot->settings, FSERVEON);
                status = quote(bot->sock, "%s %s :Turning on fserve.\r\n", type, target);
            }
            else if (lowercasecmp(argv[arg], "uptime") == 0)
            {
                status = uptime(type, target);
            }
            else if (lowercasecmp(argv[arg], "status") == 0)
            {
                status = reportstatus(type, target);
            }
            else if (lowercasecmp(argv[arg], "reconnect") == 0)
            {
                ct = gettime(time(NULL) - bot->contime);
                status = quote(bot->sock, "QUIT :Reconnecting in %ds - Connected: %s\r\n", bot->connectdelay, ct);
                free(ct);
            }
            else if (lowercasecmp(argv[arg], "restart") == 0)
            {
                bot->restart = 1;
                ct = gettime(time(NULL) - bot->contime);
                status = quote(bot->sock, "QUIT :Restarting - Connected: %s\r\n", ct);
                free(ct);
            }
            else if (lowercasecmp(argv[arg], "die") == 0)
            {
                alive = 0;
                ct = gettime(time(NULL) - runtime);
                status = quote(bot->sock, "QUIT :Runtime: %s\r\n", ct);
                free(ct);
            }
            else if (lowercasecmp(argv[arg], "spam") == 0)
            {
                status = quote(bot->sock, "%s %s :%c%s%s %s %c%s%s\r\n", type, target, 3, bot->color1, MODEL, VERSION, 3, bot->color2, WEBSITE);
            }
            else if (lowercasecmp(argv[arg], "ad") == 0)
            {
                status = display_fserve(is_channel(target));
            }
            else if (lowercasecmp(argv[arg], "identify") == 0)
            {
                if (bot->nickpass)
                    status = quote(bot->sock, "NICKSERV IDENTIFY %s\r\n", bot->nickpass);
            }
            else if (lowercasecmp(argv[arg], "rehash") == 0)
            {
                bot->restart = 2;
                status = quote(bot->sock, "%s %s :%c%sRehashing config file.\r\n", type, target, 3, bot->color1);
            }
        }
    }

    if (tmp)
        free(tmp);
    tmp = NULL;
    ct = NULL;
    return status;
}
