/*******************************************************************************
*---|
*---|     Garnaxbot by Freakster http://garnax.mircx.com/
*---|
*---|     Garnaxbot is distributed in the hope that it will be useful,
*---|     but WITHOUT ANY WARRANTY; without even the implied warranty of
*---|     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*---|
********************************************************************************
*---|
*---|     File:            raws.c
*---|     Created:         Sun Dec 15 22:47:27 CST 2002
*---|     Last Edited:
*---|     Description:     Handle the server raws.
*---|
*******************************************************************************/

#include "raws.h"

/*******************************************************************************
*---|     Function:        PROCESS_RAWS
*---|     Created:         Tue Dec 24 19:48:15 CST 2002
*---|     Last Edited:     
*---|     Description:     Processes the server raw messages.
*******************************************************************************/
int process_raws(int argc, char **argv)
{

    int status = SUCCESS;

    switch (atoi(argv[1]))
    {
    case 001:
        status = raw001(argv[0], argv[2]);
        break;

    case 302:
        if (argc > 3)
            status = raw302(argv[3]);
        break;

    case 353:
        status = raw353(argc, argv);
        break;

    case 364:
        if ((argc > 3) && (status) && (bot->settings & EXPAND))
        {
            status = add_server(argv[3]);
        }
        break;

    case 366:
        if (argc > 3)
            status = raw366(argv[3]);
        break;

    case 433:
        status = raw433();
        break;

    default:
        break;
    }

    return status;
}

/*******************************************************************************
*---|     Function:        RAW001
*---|     Created:         Mon Dec 16 00:39:52 CST 2002
*---|     Last Edited:     
*---|     Description:     Connection established.
*---|                      Get servername, nickname, and join channels.
*******************************************************************************/

int raw001(char *servername, char *nick)
{
    int status = SUCCESS;

    /* The name of the server we are connected to */
    bot->servername = mymalloc(servername);
    if (bot->servername == NULL)
    {
        return FAILURE;
    }

    /* The nickname the server sees us as */
    if (bots_nick(nick) == FAILURE)
    {
        return FAILURE;
    }

    /* Try to join our channels */
    if (join_chans() == FAILURE)
    {
        return FAILURE;
    }

    /* If server expand is set, find the rest of the servers */
    if (bot->settings & EXPAND)
    {
        status = quote(bot->sock, "LINKS\r\n");
    }

    /* Use the userhost command to find out what ip the server
    ** thinks we connected with */
    if (bot->settings & DCCIP)
    {
        status = quote(bot->sock, "USERHOST %s\r\n", bot->nick);
    }

    return status;
}

/*******************************************************************************
*---|     Function:        RAW302
*---|     Created:         Mon Dec 16 00:39:52 CST 2002
*---|     Last Edited:     
*---|     Description:     Get IP from userhost.
*******************************************************************************/

int raw302(char *userhost)
{
    int i = 0;

    /* find @ or end of string */
    while ((userhost[i] != '\0') && (userhost[i] != '@'))
        i++;

    if (userhost[i] == '@')
    {
        bot->ip = setip(&userhost[i + 1]);
    }

    return SUCCESS;
}

/*******************************************************************************
*---|     Function:        raw353
*---|     Last Edited:     
*---|     Created:         Sat Dec 21 18:49:20 CST 2002
*---|     Description:     Add users for people already in the channel.
*******************************************************************************/

int raw353(int argc, char **argv)
{
    int i = 0;
    unsigned char mode = 0;
    channelstruct *chan = NULL;

    /* :freak.p3ngu1n.org 353 Despair = #bots :Despair @Freakster pizzimp fishy */
    if ((chan = is_channel(argv[4])))
    {
        /* Point to after the : */
        argv[5] = &argv[5][1];

        for (i = 5; i < argc; i++)
        {

            switch (argv[i][0])
            {
            case '@':     /* OP */
                mode = 4;
                break;
            case '%':     /* HOP */
                mode = 2;
                break;
            case '+':     /* VOICE */
                mode = 1;
                break;
            default:      /* NORMAL */
                mode = 0;
                break;
            }

            if (mode)
            {
                add_user(chan, &argv[i][1], NULL, mode);
            }
            else
            {
                add_user(chan, argv[i], NULL, mode);
            }
        }
    }
    return SUCCESS;
}

/*******************************************************************************
*---|     Function:        RAW366
*---|     Created:         Wed Aug  6 22:55:56 CDT 2003
*---|     Last Edited:     
*---|     Description:     Signifies the bot joined a channel.
*---|                      (End of /names)
*******************************************************************************/
int raw366(char *channame)
{

    int status = SUCCESS;
    channelstruct *chan = is_channel(channame);

    if ((chan) && (chan->settings & DISPLAYAD))
    {
        status = display_fserve(chan);
    }

    return status;

}
/*******************************************************************************
*---|     Function:        RAW433
*---|     Created:         Mon Dec 16 00:39:52 CST 2002
*---|     Last Edited:     Tue Aug  5 12:44:45 CDT 2003
*---|     Description:     Add a random number to the end of nickname
*---|                      only on connection.
*******************************************************************************/

int raw433()
{
    int status = SUCCESS;

    /* :freak.p3ngu1n.org 433 * GarnaxBot :Nickname is already in use.  */

    if (bot->nick == NULL)
    {

        srand(time(NULL));
        status = quote(bot->sock, "NICK %s-%d\r\n", bot->nickkeep, (rand() % 10000) );

    }

    return status;

}

/*******************************************************************************
*---|     Function:        BOTS_NICK
*---|     Created:         Mon Dec 16 00:39:52 CST 2002
*---|     Last Edited:     Fri Jul 25 14:10:40 CDT 2003
*---|     Description:     Sets the bot's nickname.
*******************************************************************************/

int bots_nick(char *newnick)
{

#ifdef debug
    logprintf("The bots new nickname is [%s]\n", newnick);
#endif

    if (bot->nick)
    {
        free(bot->nick);
    }

    bot->nick = mymalloc(newnick);

    if (bot->nick == NULL)
    {
        return FAILURE;
    }

    if ((lowercasecmp(newnick, bot->nickkeep) == 0) && (bot->nickpass))
    {
        return quote(bot->sock, "NICKSERV :identify %s\r\n", bot->nickpass);
    }

    return SUCCESS;
}

