/*******************************************************************************
*---|
*---|     Garnaxbot by Freakster http://garnax.mircx.com/
*---|
*---|     Garnaxbot is distributed in the hope that it will be useful,
*---|     but WITHOUT ANY WARRANTY; without even the implied warranty of
*---|     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*---|
********************************************************************************
*---|
*---|     File:            structs.h
*---|     Created:         Fri Dec 13 23:09:29 CST 2002
*---|     Last Edited:
*---|     Description:     This file contains the declarations of the
*---|                      basic structures of the bot.
*---|
*******************************************************************************/

#ifndef STRUCTS_H
#define STRUCTS_H

#include "headers.h"
#include "general.h"


/* bot functions */
int create_bot(char *filename);
void destroy_bot();
void rehash_bot();

/* dcc ptrs */
int create_dccptrs();
void destroy_dccptrs();

/* server functions */
void destroy_servers();
void delete_server(serverstruct *ptr);
serverstruct *create_server(char *text);
int add_server(char *text);

/* channel functions */
void destroy_channels();
channelstruct *remove_channel(channelstruct *chan);
channelstruct *delete_channel(channelstruct *chan);
channelstruct *create_channel();
channelstruct *is_channel(char *text);
void add_channel(channelstruct *temp);
void rehash_channel(channelstruct *chan);
void reset_channel(channelstruct *chan);

/* user functions */
void destroy_users(channelstruct *chan);
userstruct *delete_user(userstruct *deluser);
userstruct *remove_user(channelstruct *chan, char *nick);
userstruct *create_user(char *nick, char *host, unsigned char modes);
int add_user(channelstruct *chan, char *nick, char *host, unsigned char modes);
userstruct *is_user(channelstruct *chan, char *nick);

/* Member functions */
userstruct *add_member(userstruct *head, char *host);
void destroy_members(channelstruct *chan);

void reset_bot();


/* DCC Structure Functions */
void remove_dcc(dccstruct *remdcc, dccptr *list);
dccstruct *destroy_dcc(dccstruct *deldcc);
void removepath(dccstruct *fserve);
void killall_dccs(dccptr *list, int type);
void add_dcc(dccstruct *adddcc, dccptr *list);

/*
void free_elements(ptrstruct *ptr, int type);
ptrstruct *free_ptrs(ptrstruct *ptr);
*/

/* dir structs used for multiple paths with one trigger */
dirstruct *create_dir(char *dname, char *ddir);
int add_dir(char *text);
void destroy_dirs(channelstruct *chan);
void purge_fserves(char *name);

/* stats */
void save_stats();
void load_stats();
void remove_pid();


#endif
