#include "uptime.h"

/* Garnaxbot type is 11 */
#define uptime_type    11
#define uptime_version VERSION

PackUp upPack; /* The packet */
static const int uptime_port = 9969; /* the port to connect to */
static const char *uptime_host = "uptime.eggheads.org"; /* uptime server to give information to */
static int uptimesock; /* socket connected to the server */
static int uptimecount; /* how many times we've sent uptime status */
static unsigned long uptimeip; /* the IP of the server to connect to */
typedef unsigned int IP;


/* initialize all of the uptime structures */
int init_uptime()
{
    struct sockaddr_in sai;

    upPack.regnr = 0; /* not used */
    upPack.pid = 0;
    upPack.type = htonl(uptime_type);
    upPack.uptime = 0;
    upPack.cookie = 0; /* not used */

    uptimecount = 0;
    uptimeip = uptime_getip();

    if (uptimeip == -1)
    {
        return -1;
    }

    /* create the socket */
    if ((uptimesock = socket(AF_INET, SOCK_DGRAM, 0)) < 0)
    {
#ifdef debug
        logprintf( "init_uptime socket returned < 0 %d\n", uptimesock);
#endif

        return ((uptimesock = -1));
    }

    memset(&sai, 0, sizeof(sai));
    sai.sin_addr.s_addr = INADDR_ANY;
    sai.sin_family = AF_INET;

    if (bind(uptimesock, (struct sockaddr *) &sai, sizeof(sai)) < 0)
    {
#ifdef debug
        logprintf( "init_uptime bind returned < 0 %d\n", uptimesock);
#endif

        close(uptimesock);
        return ((uptimesock = -1));
    }

    /* make the socket nonblocking */
#ifdef WIN32
    ioctlsocket(uptimesock, FIONBIO, 1);
#else

    fcntl(uptimesock, F_SETFL, O_NONBLOCK | fcntl(uptimesock, F_GETFL));
#endif

#ifdef debug

    logprintf( "Initialized Uptime Reporting for [%s] to [%s]\n", uptime_version, uptime_host);
#endif

    return 0;
}

/* This function returns the ip address of the uptime server we are connecting to */
unsigned long uptime_getip()
{
    IP ip;
    struct hostent *hp;
    struct in_addr *in;

    /* Numerical IP */
    if (uptime_host[0])
    {
        if ((uptime_host[strlen(uptime_host) - 1] >= '0') && (uptime_host[strlen(uptime_host) - 1] <= '9'))
        {
            return (IP) inet_addr(uptime_host);
        }
    }

    /* Hostname */
    hp = gethostbyname(uptime_host);

    if (hp == NULL)
    {
#ifdef debug
        logprintf( "Can not resolve Uptime Server IP [%s]\n", uptime_host);
#endif

        return -1;
    }

    in = (struct in_addr *) (hp->h_addr_list[0]);
    ip = (IP) (in->s_addr);

    return ip;
}

int send_uptime()
{
    int len;
    PackUp *mem;
    struct sockaddr_in sai;
#ifdef WIN32

    __int64 f1, f2;

    QueryPerformanceCounter(&f1);
    QueryPerformanceFrequency(&f2);
#else

    struct stat st;
#endif

    if ((uptimeip == -1) || (uptimesock == -1) || (bot->servername == NULL))
    {
        return -2;
    }

    uptimecount++;

#ifdef debug

    logprintf( "Sending Uptime Packet:[%d]\n", uptimecount);
#endif

    /* the current time */
    upPack.now = htonl((unsigned long)time(NULL));

    /* how long the system has been up */
#ifdef WIN32

    upPack.sysup = (unsigned long)time(NULL) - (unsigned long)((float)f1 / (float)f2);
#else

    if (stat("/proc", &st) < 0)
    {
        upPack.sysup = 0;
    }
    else
    {
        upPack.sysup = htonl(st.st_ctime);
    }
#endif

    /* the current process id */
    if (!upPack.pid)
    {
        upPack.pid = htonl(getpid());
    }

    /* how long the bot has been connected */
    upPack.ontime = htonl(bot->contime);

    /* how long the bot has been running */
    upPack.uptime = htonl(runtime);

    len = sizeof(upPack) + strlen(bot->nickkeep) + strlen(bot->servername) + strlen(uptime_version);
    mem = (PackUp *)malloc(len);
    memcpy(mem, &upPack, sizeof(upPack));
    sprintf(mem->string, "%s %s %s", bot->nickkeep, bot->servername, uptime_version);
    memset(&sai, 0, sizeof(sai));
    sai.sin_family = AF_INET;
    sai.sin_addr.s_addr = uptimeip;
    sai.sin_port = htons(uptime_port);

#ifdef debug

    logprintf("Sending uptime packet to %s\n", uptime_host);
#endif

    len = sendto(uptimesock, (void *) mem, len, 0, (struct sockaddr *) & sai, sizeof(sai));

    free((void*)mem);

    return len;
}

