#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include <stdio.h>
#include <ctype.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"

static char fgspec[] = "#ffffff";
static char bgspec[] = "#000000";
static gboolean settingfg = TRUE;

static void drawtext (GtkWidget *widget, gboolean both);

gboolean
on_window1_delete_event                (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
    exit(0);
}


void
on_colorselection1_color_changed       (GtkColorSelection *colorselection,
                                        gpointer         user_data)
{
    char * buf;
    GtkWidget * entry;
    gdouble rgba[4];

    gtk_color_selection_get_color(colorselection, rgba);
    entry = lookup_widget(GTK_WIDGET (colorselection), "entry1");
    if (settingfg)
        buf = fgspec;
    else
        buf = bgspec;
    sprintf(buf, "#%02x%02x%02x",
            (int)(rgba[0]*255), (int)(rgba[1]*255), (int)(rgba[2]*255));
    gtk_entry_set_text(GTK_ENTRY (entry), buf);
    drawtext(lookup_widget(GTK_WIDGET (colorselection), "drawingarea1"), FALSE);
}


static void
setcolor(GtkColorSelection *colorselection, char * spec)
{
    int irgb[3];
    double rgba[4];
    int i;

    sscanf(spec, "#%02x%02x%02x", &irgb[0], &irgb[1], &irgb[2]);
    for (i = 0; i < 3; i++)
        rgba[i] = irgb[i]/255.0;
    rgba[3] = 1;
    gtk_color_selection_set_color(colorselection, rgba);

    on_colorselection1_color_changed(colorselection, NULL);
}

void
on_list_select_row                     (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
    GtkWidget * cs;
    char * data;

    data = (char *)gtk_clist_get_row_data(clist, row);
    cs = lookup_widget(GTK_WIDGET (clist), "colorselection1");
    setcolor(GTK_COLOR_SELECTION (cs), data);
}


void
on_entry1_activate                      (GtkEditable     *editable,
                                        gpointer         user_data)
{
    char * text;
    GtkWidget * cs;
    int i;
    
    text = gtk_entry_get_text(GTK_ENTRY (editable));
    if (strlen(text) != 7 || text[0] != '#')
        return;
    for (i = 1; i < 7; i++)
        if (!isxdigit(text[i]))
            return;
    cs = lookup_widget(GTK_WIDGET (editable), "colorselection1");
    setcolor(GTK_COLOR_SELECTION (cs), text);
}

void
on_fgbutton_toggled                    (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
    settingfg = gtk_toggle_button_get_active(togglebutton);
    setcolor(GTK_COLOR_SELECTION (lookup_widget(GTK_WIDGET (togglebutton), "colorselection1")),
             settingfg ? fgspec : bgspec);
}


void
on_bgbutton_toggled                    (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{

}

static void
drawtext (GtkWidget *widget, gboolean both)
{
    char text1[] = "The quick brown fox";
    char text2[] = "jumped over the lazy dog";
    GdkColor fgcolor, bgcolor;
    static GdkGC * gc = NULL;

    if (gc == NULL) {
        gc = gdk_gc_new(widget->window);
    }

    if (settingfg || both) {
        gdk_color_parse(fgspec, &fgcolor);
        gdk_colormap_alloc_color (gdk_window_get_colormap(widget->window),
                                  &fgcolor, FALSE, TRUE);
        gdk_gc_set_foreground(gc, &fgcolor);
    }
    if (!settingfg || both) {
        gdk_color_parse(bgspec, &bgcolor);
        gdk_colormap_alloc_color (gdk_window_get_colormap(widget->window),
                                  &bgcolor, FALSE, TRUE);
  
        gdk_gc_set_background(gc, &bgcolor);
        gdk_window_set_background(widget->window, &bgcolor);
        gdk_window_clear_area (widget->window, 0, 0, 200, 200);
    }
    
    gdk_draw_text (widget->window, widget->style->font, gc,
                   10, 15, text1, sizeof(text1) - 1);
    gdk_draw_text (widget->window, widget->style->font, gc,
                   10, 30, text2, sizeof(text2) - 1);
}


gboolean
on_drawingarea1_expose_event           (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data)
{
    gdk_gc_set_clip_rectangle (widget->style->fg_gc[widget->state],
                               &event->area);

    drawtext(widget, TRUE);

    gdk_gc_set_clip_rectangle (widget->style->fg_gc[widget->state],
                               NULL);
    return TRUE;
}


void
on_savebutton_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkWidget *dialog;

    dialog = create_dialog1 ();
    gtk_widget_show (dialog);
}


void
on_save_ok_button_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkWidget * dialog, * entry;
    char * spec;
    char * name;
    FILE * fp;
    int r, g, b;
    if (settingfg)
        spec = fgspec;
    else
        spec = bgspec;

    entry = lookup_widget(GTK_WIDGET (button), "color_save_name_entry");
    name = gtk_entry_get_text(GTK_ENTRY (entry));
    add_list_color(spec, name);

    sscanf(spec, "#%02x%02x%02x", &r, &g, &b);
    fp = fopen("./.rgb.txt", "a");
    fprintf(fp, "%3d %3d %3d\t\t%s\n", r, g, b, name);
    fclose(fp);
    dialog = lookup_widget(GTK_WIDGET (button), "dialog1");
    gtk_widget_destroy(dialog);
}

void
on_save_cancel_button_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkWidget * dialog;

    dialog = lookup_widget(GTK_WIDGET (button), "dialog1");
    gtk_widget_destroy(dialog);
}

