/*
 * Initial main.c file generated by Glade. Edit as required.
 * Glade will not overwrite this file.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "interface.h"
#include "support.h"

static GtkWidget * listwidget;
static GdkWindow * gdkwin;

void
add_list_color(char * spec, char * name)
{
  gchar * text[2];
  GdkPixmap * pixmap;
  GdkBitmap * mask;
  int row;
  char * swatchxpm[] = {
      "16 14 1 1",
      ".      c #ffffff",
      "................",
      "................",
      "................",
      "................",
      "................",
      "................",
      "................",
      "................",
      "................",
      "................",
      "................",
      "................",
      "................",
      "................"};
  char colorline[] = ".      c #ffffff";

  text[0] = spec;
  text[1] = name;

  row = gtk_clist_append(GTK_CLIST (listwidget), text);
  sprintf(colorline, ".      c %s", spec);
  swatchxpm[1] = colorline;
  pixmap = gdk_pixmap_create_from_xpm_d(gdkwin, &mask, NULL, swatchxpm);
  gtk_clist_set_pixmap (GTK_CLIST (listwidget), row, 0, pixmap, mask);
  gtk_clist_set_pixtext (GTK_CLIST (listwidget), row, 0, spec, 5, pixmap, mask);
  gtk_clist_set_row_data(GTK_CLIST (listwidget), row, strdup(spec));
}

static void
add_rgb_file (GtkWidget *window, char *filename)
{
  char buffer[512];
  char * p;
  gchar spec[8];
  int r, g, b, lr, lg, lb;
  FILE * fp;

  fp = fopen(filename, "r");
  if (fp == NULL)
      return;
  
  lr = lg = lb = -1;

  while ((p = fgets(buffer, sizeof buffer, fp)) != NULL) {
    if (buffer[0] == '!')
      continue;
    r = strtoul(p, &p, 10);
    g = strtoul(p, &p, 10);
    b = strtoul(p, &p, 10);
    if (lr == r && lg == g && lb == b)
        continue;
    lr = r; lg = g; lb = b;
    p += strspn(p, " \t");
    sprintf(spec, "#%02x%02x%02x", r, g, b);
    add_list_color(spec, p);
  }
  fclose(fp);
}

static void
fill_color_list (GtkWidget *window)
{
  GtkWidget * list;
  
  list = lookup_widget (window, "list");

  gtk_clist_freeze(GTK_CLIST (list));

  listwidget = list;

  add_rgb_file(window, "/usr/X11R6/lib/X11/rgb.txt");
  add_rgb_file(window, "./.rgb.txt");

  gtk_clist_thaw(GTK_CLIST (list));
}

int
main (int argc, char *argv[])
{
  GtkWidget *window1;

#ifdef ENABLE_NLS
  bindtextdomain (PACKAGE, PACKAGE_LOCALE_DIR);
  textdomain (PACKAGE);
#endif

  gtk_set_locale ();
  gtk_init (&argc, &argv);

  add_pixmap_directory (PACKAGE_DATA_DIR "/pixmaps");
  add_pixmap_directory (PACKAGE_SOURCE_DIR "/pixmaps");

  /*
   * The following code was added by Glade to create one of each component
   * (except popup menus), just so that you see something after building
   * the project. Delete any components that you don't want shown initially.
   */
  window1 = create_window1 ();
  gtk_widget_show (window1);
  gdkwin = GTK_WIDGET (window1)->window;
  fill_color_list (window1);

  gtk_main ();
  return 0;
}

