/*
 * Decompiled with CFR 0.152.
 */
package com.hartmath.initial;

import com.hartmath.expression.HComplex;
import com.hartmath.expression.HDouble;
import com.hartmath.expression.HDoubleComplex;
import com.hartmath.expression.HFraction;
import com.hartmath.expression.HFunction;
import com.hartmath.expression.HInteger;
import com.hartmath.expression.HObject;
import com.hartmath.lib.C;
import com.hartmath.lib.SessionData;
import com.hartmath.mapping.EMultiArg;
import com.hartmath.mapping.FunctionOpEvaluator;

class EMultiply
extends EMultiArg
implements FunctionOpEvaluator {
    EMultiply() {
    }

    public HObject e2ComArg(HComplex hComplex, HComplex hComplex2) {
        return hComplex.multiply(hComplex2);
    }

    public HObject e2DblArg(HDouble hDouble, HDouble hDouble2) {
        return hDouble.multiply(hDouble2);
    }

    public HObject e2DblComArg(HDoubleComplex hDoubleComplex, HDoubleComplex hDoubleComplex2) {
        return hDoubleComplex.multiply(hDoubleComplex2);
    }

    public HObject e2FraArg(HFraction hFraction, HFraction hFraction2) {
        return hFraction.multiply(hFraction2);
    }

    public HObject e2IntArg(HInteger hInteger, HInteger hInteger2) {
        return hInteger.multiply(hInteger2);
    }

    public HObject e2ObjArg(HObject hObject, HObject hObject2) {
        HFunction hFunction;
        if (SessionData.getCurrentNumericFlag()) {
            if (hObject.equals(C.CD0)) {
                return C.CD0;
            }
            if (hObject2.equals(C.CD0)) {
                return C.CD0;
            }
            if (hObject.equals(C.CD1)) {
                return hObject2;
            }
            if (hObject2.equals(C.CD1)) {
                return hObject;
            }
        }
        if (hObject.equals(C.C0)) {
            return C.C0;
        }
        if (hObject2.equals(C.C0)) {
            return C.C0;
        }
        if (hObject.equals(C.C1)) {
            return hObject2;
        }
        if (hObject2.equals(C.C1)) {
            return hObject;
        }
        if (hObject.equals(hObject2)) {
            return C.Pow.f(hObject, C.C2);
        }
        if (hObject.head().equals(C.Pow) && ((HFunction)hObject).size() == 2 && (hFunction = (HFunction)hObject).get(1).isNumber()) {
            HFunction hFunction2;
            if (hFunction.get(0).equals(hObject2)) {
                return C.Pow.f(hObject2, C.Add.f(C.C1, hFunction.get(1)));
            }
            if (hObject2.head().equals(C.Pow) && ((HFunction)hObject2).size() == 2 && (hFunction2 = (HFunction)hObject2).get(1).isNumber() && hFunction.get(0).equals(hFunction2.get(0))) {
                return C.Pow.f(hFunction.get(0), C.Add.f(hFunction.get(1), hFunction2.get(1)));
            }
        }
        if (hObject2.head().equals(C.Pow) && ((HFunction)hObject2).size() == 2 && ((HFunction)hObject2).get(1).isNumber() && (hFunction = (HFunction)hObject2).get(0).equals(hObject)) {
            return C.Pow.f(hObject, C.Add.f(C.C1, hFunction.get(1)));
        }
        return null;
    }

    public HObject eComIntArg(HComplex hComplex, HInteger hInteger) {
        return hComplex.multiply(new HComplex(hInteger, C.C0));
    }

    public int precedence() {
        return 300;
    }

    public String toOpString(HFunction hFunction) {
        StringBuffer stringBuffer = new StringBuffer();
        if (hFunction.size() <= 1) {
            stringBuffer.append("Multiply(");
            if (hFunction.size() == 1) {
                stringBuffer.append(hFunction.get(0).toString());
            }
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
        for (int i = 0; i < hFunction.size(); ++i) {
            HObject hObject = hFunction.get(i);
            if (hObject.equals(C.CN1)) {
                stringBuffer.append('-');
                continue;
            }
            if (hObject.precedence() < 300) {
                stringBuffer.append('(');
            }
            stringBuffer.append(hObject.toString());
            if (hObject.precedence() < 300) {
                stringBuffer.append(')');
            }
            if (i == hFunction.size() - 1) continue;
            stringBuffer.append('*');
        }
        if (stringBuffer.toString().startsWith("-")) {
            return "(" + stringBuffer.toString() + ")";
        }
        return stringBuffer.toString();
    }
}

