/*
 * Decompiled with CFR 0.152.
 */
package com.hartmath.lib;

import com.hartmath.expression.HArrayList;
import com.hartmath.expression.HObject;
import com.hartmath.expression.HSymbol;
import com.hartmath.expression.HSymbolData;
import com.hartmath.lib.C;
import com.hartmath.lib.OutputStringBuffer;
import com.hartmath.lib.ResultOutput;
import com.hartmath.patternmatching.HRuleSet;
import geonext.Element;
import geonext.ElementSet;
import java.util.Vector;
import org.kaffe.java.util.HashMap;

public class SessionData {
    private static SessionData defaultSession = new SessionData("Default");
    private static HashMap sessionTable = null;
    private String sessionID;
    private HashMap SymbolRuleSets;
    private HashMap SymbolDataSet;
    private int count;
    private HArrayList InArray = new HArrayList();
    private HArrayList OutArray = new HArrayList();
    private int recursionLimit = -1;
    private int iterationLimit = -1;
    private int recursionCounter;
    private int iterationCounter;
    private boolean numericFlag = false;
    private ResultOutput resultOut;
    private ResultOutput errorOut;
    private int IOCounter;
    private HashMap IOOut = new HashMap();
    private HashMap IOIn = new HashMap();
    ElementSet elementSet;
    public Element currentElement = null;
    boolean symbolicFlag = false;
    boolean geoFunctionIncluded = false;
    boolean geoNumericDefinition = false;
    Vector loadedSymbols = new Vector();
    Vector geometricFunctions = new Vector();
    Vector geometricFunctionsVariablesTypes = new Vector();
    boolean traceGEONExTElements = false;

    private SessionData() {
    }

    public SessionData(String string) {
        this.count = 0;
        this.InArray = new HArrayList();
        this.OutArray = new HArrayList();
        this.recursionLimit = -1;
        this.iterationLimit = -1;
        this.recursionCounter = 0;
        this.iterationCounter = 0;
        this.numericFlag = false;
        this.resultOut = new OutputStringBuffer();
        this.errorOut = new OutputStringBuffer();
        this.IOCounter = 0;
        this.IOOut = new HashMap();
        this.IOIn = new HashMap();
        this.sessionID = string;
        this.SymbolRuleSets = new HashMap();
        this.SymbolDataSet = new HashMap();
    }

    public SessionData(String string, ElementSet elementSet) {
        this.elementSet = elementSet;
        this.count = 0;
        this.InArray = new HArrayList();
        this.OutArray = new HArrayList();
        this.recursionLimit = -1;
        this.iterationLimit = -1;
        this.recursionCounter = 0;
        this.iterationCounter = 0;
        this.numericFlag = false;
        this.resultOut = new OutputStringBuffer();
        this.errorOut = new OutputStringBuffer();
        this.IOCounter = 0;
        this.IOOut = new HashMap();
        this.IOIn = new HashMap();
        this.sessionID = string;
        this.SymbolRuleSets = new HashMap();
        this.SymbolDataSet = new HashMap();
    }

    public final void addHistory() {
        ++this.count;
        this.InArray.add(C.Null);
        this.OutArray.add(C.Null);
    }

    public static final void appendCurrentErrorOut(String string) {
        SessionData sessionData = SessionData.currentSessionData();
        sessionData.errorOut.append(string);
    }

    public static final void appendCurrentResultOut(String string) {
        SessionData sessionData = SessionData.currentSessionData();
        sessionData.resultOut.append(string);
    }

    public final void appendErrorOut(String string) {
        this.resultOut.append(string);
    }

    public final void appendLineErrorOut(String string) {
        this.errorOut.appendLine(string);
    }

    public final void appendLineResultOut(String string) {
        this.resultOut.appendLine(string);
    }

    public final void appendResultOut(String string) {
        this.resultOut.append(string);
    }

    public final void changeCurrentInHistory(HObject hObject) {
        this.InArray.set(this.count - 1, hObject);
    }

    public final void changeCurrentOutHistory(HObject hObject) {
        this.OutArray.set(this.count - 1, hObject);
    }

    public void clear(HSymbol hSymbol) {
        HRuleSet hRuleSet = (HRuleSet)this.SymbolRuleSets.get(hSymbol);
        if (hRuleSet != null) {
            hRuleSet.clear();
        }
    }

    public final void clearIOIn() {
        this.IOIn.clear();
    }

    public final void clearIOOut() {
        this.IOOut.clear();
    }

    public void clearSymbolRule(HSymbol hSymbol, HSymbol hSymbol2) {
        HRuleSet hRuleSet = (HRuleSet)this.SymbolRuleSets.get(hSymbol);
        if (hRuleSet != null) {
            hRuleSet.clearSymbolRule(hSymbol2);
        }
    }

    public static final void createLocalPattern(HSymbol hSymbol, HObject hObject) {
        SessionData sessionData = SessionData.currentSessionData();
        HSymbolData hSymbolData = (HSymbolData)sessionData.SymbolDataSet.get(hSymbol);
        if (hSymbolData == null) {
            hSymbolData = new HSymbolData();
            sessionData.SymbolDataSet.put(hSymbol, hSymbolData);
        }
        hSymbolData.createLocalPattern(hObject);
    }

    public static final void createLocalVar(HSymbol hSymbol, HObject hObject) {
        SessionData sessionData = SessionData.currentSessionData();
        HSymbolData hSymbolData = (HSymbolData)sessionData.SymbolDataSet.get(hSymbol);
        if (hSymbolData == null) {
            hSymbolData = new HSymbolData();
            sessionData.SymbolDataSet.put(hSymbol, hSymbolData);
        }
        hSymbolData.createLocalVar(hObject);
    }

    public final HSymbolData createSymbolData(HSymbol hSymbol) {
        HSymbolData hSymbolData = (HSymbolData)this.SymbolDataSet.get(hSymbol);
        if (hSymbolData == null) {
            hSymbolData = new HSymbolData();
            this.SymbolDataSet.put(hSymbol, hSymbolData);
        }
        return hSymbolData;
    }

    public static final synchronized SessionData currentSessionData() {
        return sessionTable == null ? defaultSession : (SessionData)sessionTable.get(C.boardName);
    }

    public static final synchronized SessionData currentThreadSession() {
        return sessionTable == null ? defaultSession : (SessionData)sessionTable.get(C.boardName);
    }

    public final void decIterationCounter() {
        --this.iterationCounter;
    }

    public final void decRecursionCounter() {
        --this.recursionCounter;
    }

    public static final HObject deleteLocalPattern(HSymbol hSymbol) {
        SessionData sessionData = SessionData.currentSessionData();
        HSymbolData hSymbolData = (HSymbolData)sessionData.SymbolDataSet.get(hSymbol);
        if (hSymbolData != null) {
            return hSymbolData.deleteLocalPattern();
        }
        return null;
    }

    public static final HObject deleteLocalVar(HSymbol hSymbol) {
        SessionData sessionData = SessionData.currentSessionData();
        HSymbolData hSymbolData = (HSymbolData)sessionData.SymbolDataSet.get(hSymbol);
        if (hSymbolData != null) {
            return hSymbolData.deleteLocalVar();
        }
        return null;
    }

    public final int getCounter() {
        return this.count;
    }

    public static final boolean getCurrentNumericFlag() {
        SessionData sessionData = SessionData.currentSessionData();
        return sessionData.numericFlag;
    }

    public HObject getDownRule(HSymbol hSymbol, HObject hObject) {
        HRuleSet hRuleSet = (HRuleSet)this.SymbolRuleSets.get(hSymbol);
        return hRuleSet == null ? null : hRuleSet.getDownRule(hObject);
    }

    public ElementSet getElementSet() {
        return this.elementSet;
    }

    public final String getID() {
        return this.sessionID;
    }

    public final HObject getInHistory(int n) {
        return this.InArray.get(n);
    }

    public final int getIOCounter() {
        return this.IOCounter;
    }

    public final HSymbol getIOIn(Integer n) {
        return (HSymbol)this.IOIn.get(n);
    }

    public final Short getIOOut(String string) {
        return (Short)this.IOIn.get(string);
    }

    public final int getIterationLimit() {
        return this.iterationLimit;
    }

    public Vector getLoadedSymbols() {
        return this.loadedSymbols;
    }

    public static final HObject getLocalPatternValue(HSymbol hSymbol) {
        SessionData sessionData = SessionData.currentSessionData();
        HSymbolData hSymbolData = (HSymbolData)sessionData.SymbolDataSet.get(hSymbol);
        if (hSymbolData != null) {
            return hSymbolData.getLocalPatternValue();
        }
        return null;
    }

    public static final HObject getLocalVarValue(HSymbol hSymbol) {
        SessionData sessionData = SessionData.currentSessionData();
        HSymbolData hSymbolData = (HSymbolData)sessionData.SymbolDataSet.get(hSymbol);
        if (hSymbolData != null) {
            return hSymbolData.getLocalVarValue();
        }
        return null;
    }

    public final boolean getNumericFlag() {
        return this.numericFlag;
    }

    public final HObject getOutHistory(int n) {
        return this.OutArray.get(n);
    }

    public final int getRecursionLimit() {
        return this.recursionLimit;
    }

    public HRuleSet getRuleSet(HSymbol hSymbol) {
        return (HRuleSet)this.SymbolRuleSets.get(hSymbol);
    }

    public final HSymbolData getSymbolData(HSymbol hSymbol) {
        return (HSymbolData)this.SymbolDataSet.get(hSymbol);
    }

    public boolean getSymbolicEvaluation() {
        return this.symbolicFlag;
    }

    public HObject getUpRule(HSymbol hSymbol, HObject hObject) {
        HRuleSet hRuleSet = (HRuleSet)this.SymbolRuleSets.get(hSymbol);
        return hRuleSet == null ? null : hRuleSet.getUpRule(hObject);
    }

    public static final boolean hasNoLocalPattern(HSymbol hSymbol) {
        SessionData sessionData = SessionData.currentSessionData();
        HSymbolData hSymbolData = (HSymbolData)sessionData.SymbolDataSet.get(hSymbol);
        if (hSymbolData != null) {
            return hSymbolData.hasNoLocalPattern();
        }
        return true;
    }

    public static final boolean hasNoLocalVar(HSymbol hSymbol) {
        SessionData sessionData = SessionData.currentSessionData();
        HSymbolData hSymbolData = (HSymbolData)sessionData.SymbolDataSet.get(hSymbol);
        if (hSymbolData != null) {
            return hSymbolData.hasNoLocalVar();
        }
        return true;
    }

    public final void incIOCounter() {
        ++this.IOCounter;
    }

    public final void incIterationCounter() {
        ++this.iterationCounter;
    }

    public final void incRecursionCounter() {
        ++this.recursionCounter;
    }

    public boolean isEmptyUpRule(HSymbol hSymbol) {
        HRuleSet hRuleSet = (HRuleSet)this.SymbolRuleSets.get(hSymbol);
        return hRuleSet == null ? true : hRuleSet.isEmptyUpRule();
    }

    public boolean isGeoFunctionIncluded() {
        return this.geoFunctionIncluded;
    }

    public boolean isGeoNumericDefinition() {
        return this.geoNumericDefinition;
    }

    public boolean isSymbolicFlag() {
        return this.symbolicFlag;
    }

    public final boolean iterationExceeded() {
        return this.iterationLimit > 0 && ++this.iterationCounter > this.iterationLimit;
    }

    public final synchronized void put() {
        if (sessionTable == null) {
            sessionTable = new HashMap();
        }
        sessionTable.put(Thread.currentThread(), this);
    }

    public final synchronized void put(String string) {
        if (sessionTable == null) {
            sessionTable = new HashMap();
        }
        sessionTable.put(string, this);
    }

    public void putDownRule(HSymbol hSymbol, int n, HObject hObject, HObject hObject2) {
        HRuleSet hRuleSet = (HRuleSet)this.SymbolRuleSets.get(hSymbol);
        if (hRuleSet == null) {
            hRuleSet = new HRuleSet(hSymbol);
            this.SymbolRuleSets.put(hSymbol, hRuleSet);
        }
        hRuleSet.putDownRule(n, hObject, hObject2);
    }

    public final void putIOIn(Integer n, HSymbol hSymbol) {
        this.IOIn.put(n, hSymbol);
    }

    public final void putIOOut(String string, Short s) {
        this.IOIn.put(string, s);
    }

    public void putUpRule(HSymbol hSymbol, int n, HObject hObject, HObject hObject2) {
        HRuleSet hRuleSet = (HRuleSet)this.SymbolRuleSets.get(hSymbol);
        if (hRuleSet == null) {
            hRuleSet = new HRuleSet(hSymbol);
            this.SymbolRuleSets.put(hSymbol, hRuleSet);
        }
        hRuleSet.putUpRule(n, hObject, hObject2);
    }

    public final boolean recursionExceeded() {
        return this.recursionLimit > 0 && ++this.recursionCounter > this.recursionLimit;
    }

    public static final synchronized void remove() {
        if (sessionTable != null) {
            sessionTable.remove(C.boardName);
        }
    }

    public static final synchronized void remove(String string) {
        if (sessionTable != null) {
            sessionTable.remove(string);
        }
    }

    public static final void setCurrentNumericFlag(boolean bl) {
        SessionData sessionData = SessionData.currentSessionData();
        sessionData.numericFlag = bl;
    }

    public void setElementSet(ElementSet elementSet) {
        this.elementSet = elementSet;
    }

    public final void setErrorOut(ResultOutput resultOutput) {
        this.errorOut = resultOutput;
    }

    public void setGeoFunctionIncluded(boolean bl) {
        this.geoFunctionIncluded = bl;
    }

    public void setGeoNumericDefinition(boolean bl) {
        this.geoNumericDefinition = bl;
    }

    public final void setIOCounter(int n) {
        this.IOCounter = n;
    }

    public final void setIterationCounter(int n) {
        this.iterationCounter = n;
    }

    public final void setIterationLimit(int n) {
        this.iterationLimit = n;
    }

    public void setLoadedSymbols(Vector vector) {
        this.loadedSymbols = vector;
    }

    public final void setNumericFlag(boolean bl) {
        this.numericFlag = bl;
    }

    public final void setRecursionCounter(int n) {
        this.recursionCounter = n;
    }

    public final void setRecursionLimit(int n) {
        this.recursionLimit = n;
    }

    public final void setResultOut(ResultOutput resultOutput) {
        this.resultOut = resultOutput;
    }

    public void setSymbolicFlag(boolean bl) {
        this.symbolicFlag = bl;
    }

    public boolean isTraceGEONExTElements() {
        return this.traceGEONExTElements;
    }

    public void setTraceGEONExTElements(boolean bl) {
        this.traceGEONExTElements = bl;
    }
}

