/*
 * Decompiled with CFR 0.152.
 */
package com.hartmath.util;

import com.hartmath.expression.HDoubleComplex;
import com.hartmath.mapping.HUnaryNumerical;
import com.hartmath.util.ComplexDiagonalMatrix;
import com.hartmath.util.ComplexMatrix;
import com.hartmath.util.DimensionException;
import com.hartmath.util.DoubleMatrix;
import com.hartmath.util.DoubleSquareMatrix;
import com.hartmath.util.DoubleTridiagonalMatrix;
import com.hartmath.util.DoubleVector;
import com.hartmath.util.MathNumber;
import com.hartmath.util.Matrix;
import com.hartmath.util.MatrixDimensionException;

public final class DoubleDiagonalMatrix
extends DoubleTridiagonalMatrix {
    protected DoubleDiagonalMatrix() {
    }

    public DoubleDiagonalMatrix(double[][] dArray) {
        this(dArray.length);
        if (dArray.length == dArray[0].length) {
            for (int i = 0; i < this.matrix[0].length; ++i) {
                this.matrix[0][i] = dArray[i][i];
            }
        } else {
            this.matrix = null;
            throw new MatrixDimensionException("Array must be square.");
        }
    }

    public DoubleDiagonalMatrix(double[] dArray) {
        this();
        this.matrix = new double[1][];
        this.matrix[0] = dArray;
    }

    public DoubleDiagonalMatrix(int n) {
        this();
        this.matrix = new double[1][n];
    }

    public DoubleDiagonalMatrix add(DoubleDiagonalMatrix doubleDiagonalMatrix) {
        if (this.matrix[0].length == doubleDiagonalMatrix.rows()) {
            double[] dArray = new double[this.matrix[0].length];
            dArray[0] = this.matrix[0][0] + doubleDiagonalMatrix.getElement(0, 0);
            for (int i = 1; i < dArray.length; ++i) {
                dArray[i] = this.matrix[0][i] + doubleDiagonalMatrix.getElement(i, i);
            }
            return new DoubleDiagonalMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleMatrix add(DoubleMatrix doubleMatrix) {
        if (doubleMatrix instanceof DoubleDiagonalMatrix) {
            return this.add((DoubleDiagonalMatrix)doubleMatrix);
        }
        if (doubleMatrix instanceof DoubleTridiagonalMatrix) {
            return this.rawAdd((DoubleTridiagonalMatrix)doubleMatrix);
        }
        if (doubleMatrix instanceof DoubleSquareMatrix) {
            return this.rawAdd((DoubleSquareMatrix)doubleMatrix);
        }
        return this.rawAdd(doubleMatrix);
    }

    public DoubleSquareMatrix add(DoubleSquareMatrix doubleSquareMatrix) {
        if (doubleSquareMatrix instanceof DoubleDiagonalMatrix) {
            return this.add((DoubleDiagonalMatrix)doubleSquareMatrix);
        }
        if (doubleSquareMatrix instanceof DoubleTridiagonalMatrix) {
            return this.rawAdd((DoubleTridiagonalMatrix)doubleSquareMatrix);
        }
        return this.rawAdd(doubleSquareMatrix);
    }

    public DoubleTridiagonalMatrix add(DoubleTridiagonalMatrix doubleTridiagonalMatrix) {
        if (doubleTridiagonalMatrix instanceof DoubleDiagonalMatrix) {
            return this.add((DoubleDiagonalMatrix)doubleTridiagonalMatrix);
        }
        return this.rawAdd(doubleTridiagonalMatrix);
    }

    public Matrix add(Matrix matrix) {
        if (matrix instanceof DoubleDiagonalMatrix) {
            return this.add((DoubleDiagonalMatrix)matrix);
        }
        if (matrix instanceof DoubleTridiagonalMatrix) {
            return this.rawAdd((DoubleTridiagonalMatrix)matrix);
        }
        if (matrix instanceof DoubleSquareMatrix) {
            return this.rawAdd((DoubleSquareMatrix)matrix);
        }
        if (matrix instanceof DoubleMatrix) {
            return this.rawAdd((DoubleMatrix)matrix);
        }
        throw new IllegalArgumentException("Matrix class not recognised by this method.");
    }

    public DoubleSquareMatrix[] choleskyDecompose() {
        DoubleSquareMatrix[] doubleSquareMatrixArray = new DoubleDiagonalMatrix[2];
        double[] dArray = new double[this.matrix[0].length];
        dArray[0] = Math.sqrt(this.matrix[0][0]);
        for (int i = 1; i < dArray.length; ++i) {
            dArray[i] = Math.sqrt(this.matrix[0][i]);
        }
        doubleSquareMatrixArray[0] = new DoubleDiagonalMatrix(dArray);
        doubleSquareMatrixArray[1] = doubleSquareMatrixArray[0];
        return doubleSquareMatrixArray;
    }

    public int columns() {
        return this.matrix[0].length;
    }

    public double det() {
        double d = this.matrix[0][0];
        for (int i = 1; i < this.matrix[0].length; ++i) {
            d *= this.matrix[0][i];
        }
        return d;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof DoubleDiagonalMatrix && this.matrix[0].length == ((DoubleDiagonalMatrix)object).rows()) {
            DoubleDiagonalMatrix doubleDiagonalMatrix = (DoubleDiagonalMatrix)object;
            for (int i = 0; i < this.matrix[0].length; ++i) {
                if (!(Math.abs(this.matrix[0][i] - doubleDiagonalMatrix.getElement(i, i)) > MathNumber.ZERO_TOL)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public double frobeniusNorm() {
        double d = this.matrix[0][0] * this.matrix[0][0];
        for (int i = 1; i < this.matrix[0].length; ++i) {
            d += this.matrix[0][i] * this.matrix[0][i];
        }
        return Math.sqrt(d);
    }

    public double getElement(int n, int n2) {
        if (n >= 0 && n < this.matrix[0].length && n2 >= 0 && n2 < this.matrix[0].length) {
            if (n == n2) {
                return this.matrix[0][n];
            }
            return 0.0;
        }
        throw new MatrixDimensionException("Invalid element.");
    }

    public static DoubleDiagonalMatrix identity(int n) {
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = 1.0;
        }
        return new DoubleDiagonalMatrix(dArray);
    }

    public double infNorm() {
        double d = Math.abs(this.matrix[0][0]);
        for (int i = 1; i < this.matrix[0].length; ++i) {
            double d2 = Math.abs(this.matrix[0][i]);
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public DoubleSquareMatrix inverse() {
        double[] dArray = new double[this.matrix[0].length];
        dArray[0] = 1.0 / this.matrix[0][0];
        for (int i = 1; i < dArray.length; ++i) {
            dArray[i] = 1.0 / this.matrix[0][i];
        }
        return new DoubleDiagonalMatrix(dArray);
    }

    public boolean isSymmetric() {
        return true;
    }

    public boolean isUnitary() {
        return this.multiply(this).equals(DoubleDiagonalMatrix.identity(this.matrix[0].length));
    }

    public DoubleSquareMatrix[] luDecompose() {
        DoubleSquareMatrix[] doubleSquareMatrixArray = new DoubleDiagonalMatrix[]{DoubleDiagonalMatrix.identity(this.matrix[0].length), this};
        return doubleSquareMatrixArray;
    }

    public DoubleMatrix mapElements(HUnaryNumerical hUnaryNumerical) {
        double[] dArray = new double[this.matrix[0].length];
        dArray[0] = hUnaryNumerical.map(this.matrix[0][0]);
        for (int i = 1; i < dArray.length; ++i) {
            dArray[i] = hUnaryNumerical.map(this.matrix[0][i]);
        }
        return new DoubleDiagonalMatrix(dArray);
    }

    public DoubleDiagonalMatrix multiply(DoubleDiagonalMatrix doubleDiagonalMatrix) {
        if (this.matrix[0].length == doubleDiagonalMatrix.rows()) {
            double[] dArray = new double[this.matrix[0].length];
            dArray[0] = this.matrix[0][0] * doubleDiagonalMatrix.getElement(0, 0);
            for (int i = 1; i < dArray.length; ++i) {
                dArray[i] = this.matrix[0][i] * doubleDiagonalMatrix.getElement(i, i);
            }
            return new DoubleDiagonalMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleMatrix multiply(DoubleMatrix doubleMatrix) {
        if (doubleMatrix instanceof DoubleDiagonalMatrix) {
            return this.multiply((DoubleDiagonalMatrix)doubleMatrix);
        }
        if (doubleMatrix instanceof DoubleTridiagonalMatrix) {
            return this.rawMultiply((DoubleTridiagonalMatrix)doubleMatrix);
        }
        if (doubleMatrix instanceof DoubleSquareMatrix) {
            return this.rawMultiply((DoubleSquareMatrix)doubleMatrix);
        }
        return this.rawMultiply(doubleMatrix);
    }

    public DoubleSquareMatrix multiply(DoubleSquareMatrix doubleSquareMatrix) {
        if (doubleSquareMatrix instanceof DoubleDiagonalMatrix) {
            return this.multiply((DoubleDiagonalMatrix)doubleSquareMatrix);
        }
        if (doubleSquareMatrix instanceof DoubleTridiagonalMatrix) {
            return this.rawMultiply((DoubleTridiagonalMatrix)doubleSquareMatrix);
        }
        return this.rawMultiply(doubleSquareMatrix);
    }

    public DoubleSquareMatrix multiply(DoubleTridiagonalMatrix doubleTridiagonalMatrix) {
        if (doubleTridiagonalMatrix instanceof DoubleDiagonalMatrix) {
            return this.multiply((DoubleDiagonalMatrix)doubleTridiagonalMatrix);
        }
        return this.rawMultiply(doubleTridiagonalMatrix);
    }

    public DoubleVector multiply(DoubleVector doubleVector) {
        if (this.matrix[0].length == doubleVector.dimension()) {
            double[] dArray = new double[this.matrix[0].length];
            dArray[0] = this.matrix[0][0] * doubleVector.getComponent(0);
            for (int i = 1; i < dArray.length; ++i) {
                dArray[i] = this.matrix[0][i] * doubleVector.getComponent(i);
            }
            return new DoubleVector(dArray);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    public Matrix multiply(Matrix matrix) {
        if (matrix instanceof DoubleDiagonalMatrix) {
            return this.multiply((DoubleDiagonalMatrix)matrix);
        }
        if (matrix instanceof DoubleTridiagonalMatrix) {
            return this.rawMultiply((DoubleTridiagonalMatrix)matrix);
        }
        if (matrix instanceof DoubleSquareMatrix) {
            return this.rawMultiply((DoubleSquareMatrix)matrix);
        }
        if (matrix instanceof DoubleMatrix) {
            return this.rawMultiply((DoubleMatrix)matrix);
        }
        throw new IllegalArgumentException("Matrix class not recognised by this method.");
    }

    private DoubleMatrix rawAdd(DoubleMatrix doubleMatrix) {
        if (this.matrix[0].length == doubleMatrix.rows() && this.matrix[0].length == doubleMatrix.columns()) {
            int n;
            double[][] dArray = new double[this.matrix[0].length][this.matrix[0].length];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i][0] = doubleMatrix.getElement(i, 0);
                for (n = 1; n < dArray.length; ++n) {
                    dArray[i][n] = doubleMatrix.getElement(i, n);
                }
            }
            for (n = 0; n < dArray.length; ++n) {
                double[] dArray2 = dArray[n];
                int n2 = n;
                dArray2[n2] = dArray2[n2] + this.matrix[0][n];
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private DoubleSquareMatrix rawAdd(DoubleSquareMatrix doubleSquareMatrix) {
        if (this.matrix[0].length == doubleSquareMatrix.rows()) {
            int n;
            double[][] dArray = new double[this.matrix[0].length][this.matrix[0].length];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i][0] = doubleSquareMatrix.getElement(i, 0);
                for (n = 1; n < dArray.length; ++n) {
                    dArray[i][n] = doubleSquareMatrix.getElement(i, n);
                }
            }
            for (n = 0; n < dArray.length; ++n) {
                double[] dArray2 = dArray[n];
                int n2 = n;
                dArray2[n2] = dArray2[n2] + this.matrix[0][n];
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private DoubleTridiagonalMatrix rawAdd(DoubleTridiagonalMatrix doubleTridiagonalMatrix) {
        if (this.matrix[0].length == doubleTridiagonalMatrix.rows()) {
            int n = this.matrix[0].length;
            DoubleTridiagonalMatrix doubleTridiagonalMatrix2 = new DoubleTridiagonalMatrix(n);
            doubleTridiagonalMatrix2.setElement(0, 0, this.matrix[0][0] + doubleTridiagonalMatrix.getElement(0, 0));
            doubleTridiagonalMatrix2.setElement(1, 0, doubleTridiagonalMatrix.getElement(1, 0));
            --n;
            for (int i = 1; i < n; ++i) {
                doubleTridiagonalMatrix2.setElement(i - 1, i, doubleTridiagonalMatrix.getElement(i - 1, i));
                doubleTridiagonalMatrix2.setElement(i, i, this.matrix[0][i] + doubleTridiagonalMatrix.getElement(i, i));
                doubleTridiagonalMatrix2.setElement(i + 1, i, doubleTridiagonalMatrix.getElement(i + 1, i));
            }
            doubleTridiagonalMatrix2.setElement(n - 1, n, doubleTridiagonalMatrix.getElement(n - 1, n));
            doubleTridiagonalMatrix2.setElement(n, n, this.matrix[0][n] + doubleTridiagonalMatrix.getElement(n, n));
            return doubleTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private DoubleMatrix rawMultiply(DoubleMatrix doubleMatrix) {
        if (this.matrix[0].length == doubleMatrix.rows()) {
            double[][] dArray = new double[this.matrix[0].length][doubleMatrix.columns()];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i][0] = this.matrix[0][i] * doubleMatrix.getElement(i, 0);
                for (int j = 1; j < dArray[0].length; ++j) {
                    dArray[i][j] = this.matrix[0][i] * doubleMatrix.getElement(i, j);
                }
            }
            return new DoubleMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private DoubleSquareMatrix rawMultiply(DoubleSquareMatrix doubleSquareMatrix) {
        if (this.matrix[0].length == doubleSquareMatrix.rows()) {
            double[][] dArray = new double[this.matrix[0].length][this.matrix[0].length];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i][0] = this.matrix[0][i] * doubleSquareMatrix.getElement(i, 0);
                for (int j = 1; j < dArray.length; ++j) {
                    dArray[i][j] = this.matrix[0][i] * doubleSquareMatrix.getElement(i, j);
                }
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private DoubleSquareMatrix rawMultiply(DoubleTridiagonalMatrix doubleTridiagonalMatrix) {
        int n = this.matrix[0].length;
        if (n == doubleTridiagonalMatrix.rows()) {
            DoubleTridiagonalMatrix doubleTridiagonalMatrix2 = new DoubleTridiagonalMatrix(n);
            doubleTridiagonalMatrix2.setElement(0, 0, this.matrix[0][0] * doubleTridiagonalMatrix.getElement(0, 0));
            doubleTridiagonalMatrix2.setElement(0, 1, this.matrix[0][0] * doubleTridiagonalMatrix.getElement(0, 1));
            --n;
            for (int i = 1; i < n; ++i) {
                doubleTridiagonalMatrix2.setElement(i, i - 1, this.matrix[0][i] * doubleTridiagonalMatrix.getElement(i, i - 1));
                doubleTridiagonalMatrix2.setElement(i, i, this.matrix[0][i] * doubleTridiagonalMatrix.getElement(i, i));
                doubleTridiagonalMatrix2.setElement(i, i + 1, this.matrix[0][i] * doubleTridiagonalMatrix.getElement(i, i + 1));
            }
            doubleTridiagonalMatrix2.setElement(n, n - 1, this.matrix[0][n] * doubleTridiagonalMatrix.getElement(n, n - 1));
            doubleTridiagonalMatrix2.setElement(n, n, this.matrix[0][n] * doubleTridiagonalMatrix.getElement(n, n));
            return doubleTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private DoubleMatrix rawSubtract(DoubleMatrix doubleMatrix) {
        if (this.matrix[0].length == doubleMatrix.rows() && this.matrix[0].length == doubleMatrix.columns()) {
            int n;
            double[][] dArray = new double[this.matrix[0].length][this.matrix[0].length];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i][0] = -doubleMatrix.getElement(i, 0);
                for (n = 1; n < dArray.length; ++n) {
                    dArray[i][n] = -doubleMatrix.getElement(i, n);
                }
            }
            for (n = 0; n < dArray.length; ++n) {
                double[] dArray2 = dArray[n];
                int n2 = n;
                dArray2[n2] = dArray2[n2] + this.matrix[0][n];
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private DoubleSquareMatrix rawSubtract(DoubleSquareMatrix doubleSquareMatrix) {
        if (this.matrix[0].length == doubleSquareMatrix.rows()) {
            int n;
            double[][] dArray = new double[this.matrix[0].length][this.matrix[0].length];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i][0] = -doubleSquareMatrix.getElement(i, 0);
                for (n = 1; n < dArray.length; ++n) {
                    dArray[i][n] = -doubleSquareMatrix.getElement(i, n);
                }
            }
            for (n = 0; n < dArray.length; ++n) {
                double[] dArray2 = dArray[n];
                int n2 = n;
                dArray2[n2] = dArray2[n2] + this.matrix[0][n];
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private DoubleTridiagonalMatrix rawSubtract(DoubleTridiagonalMatrix doubleTridiagonalMatrix) {
        if (this.matrix[0].length == doubleTridiagonalMatrix.rows()) {
            int n = this.matrix[0].length;
            DoubleTridiagonalMatrix doubleTridiagonalMatrix2 = new DoubleTridiagonalMatrix(n);
            doubleTridiagonalMatrix2.setElement(0, 0, this.matrix[0][0] - doubleTridiagonalMatrix.getElement(0, 0));
            doubleTridiagonalMatrix2.setElement(1, 0, -doubleTridiagonalMatrix.getElement(1, 0));
            --n;
            for (int i = 1; i < n; ++i) {
                doubleTridiagonalMatrix2.setElement(i - 1, i, -doubleTridiagonalMatrix.getElement(i - 1, i));
                doubleTridiagonalMatrix2.setElement(i, i, this.matrix[0][i] - doubleTridiagonalMatrix.getElement(i, i));
                doubleTridiagonalMatrix2.setElement(i + 1, i, -doubleTridiagonalMatrix.getElement(i + 1, i));
            }
            doubleTridiagonalMatrix2.setElement(n - 1, n, -doubleTridiagonalMatrix.getElement(n - 1, n));
            doubleTridiagonalMatrix2.setElement(n, n, this.matrix[0][n] - doubleTridiagonalMatrix.getElement(n, n));
            return doubleTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public int rows() {
        return this.matrix[0].length;
    }

    public DoubleMatrix scalarMultiply(double d) {
        double[] dArray = new double[this.matrix[0].length];
        dArray[0] = d * this.matrix[0][0];
        for (int i = 1; i < dArray.length; ++i) {
            dArray[i] = d * this.matrix[0][i];
        }
        return new DoubleDiagonalMatrix(dArray);
    }

    public void setElement(int n, int n2, double d) {
        if (n < 0 || n >= this.matrix[0].length || n2 < 0 || n2 >= this.matrix[0].length || n != n2) {
            throw new MatrixDimensionException("Invalid element.");
        }
        this.matrix[0][n] = d;
    }

    public DoubleDiagonalMatrix subtract(DoubleDiagonalMatrix doubleDiagonalMatrix) {
        if (this.matrix[0].length == doubleDiagonalMatrix.rows()) {
            double[] dArray = new double[this.matrix[0].length];
            dArray[0] = this.matrix[0][0] - doubleDiagonalMatrix.getElement(0, 0);
            for (int i = 1; i < dArray.length; ++i) {
                dArray[i] = this.matrix[0][i] - doubleDiagonalMatrix.getElement(i, i);
            }
            return new DoubleDiagonalMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleMatrix subtract(DoubleMatrix doubleMatrix) {
        if (doubleMatrix instanceof DoubleDiagonalMatrix) {
            return this.subtract((DoubleDiagonalMatrix)doubleMatrix);
        }
        if (doubleMatrix instanceof DoubleTridiagonalMatrix) {
            return this.rawSubtract((DoubleTridiagonalMatrix)doubleMatrix);
        }
        if (doubleMatrix instanceof DoubleSquareMatrix) {
            return this.rawSubtract((DoubleSquareMatrix)doubleMatrix);
        }
        return this.rawSubtract(doubleMatrix);
    }

    public DoubleSquareMatrix subtract(DoubleSquareMatrix doubleSquareMatrix) {
        if (doubleSquareMatrix instanceof DoubleDiagonalMatrix) {
            return this.subtract((DoubleDiagonalMatrix)doubleSquareMatrix);
        }
        if (doubleSquareMatrix instanceof DoubleTridiagonalMatrix) {
            return this.rawSubtract((DoubleTridiagonalMatrix)doubleSquareMatrix);
        }
        return this.rawSubtract(doubleSquareMatrix);
    }

    public DoubleTridiagonalMatrix subtract(DoubleTridiagonalMatrix doubleTridiagonalMatrix) {
        if (doubleTridiagonalMatrix instanceof DoubleDiagonalMatrix) {
            return this.subtract((DoubleDiagonalMatrix)doubleTridiagonalMatrix);
        }
        return this.rawSubtract(doubleTridiagonalMatrix);
    }

    public Matrix subtract(Matrix matrix) {
        if (matrix instanceof DoubleDiagonalMatrix) {
            return this.subtract((DoubleDiagonalMatrix)matrix);
        }
        if (matrix instanceof DoubleTridiagonalMatrix) {
            return this.rawSubtract((DoubleTridiagonalMatrix)matrix);
        }
        if (matrix instanceof DoubleSquareMatrix) {
            return this.rawSubtract((DoubleSquareMatrix)matrix);
        }
        if (matrix instanceof DoubleMatrix) {
            return this.rawSubtract((DoubleMatrix)matrix);
        }
        throw new IllegalArgumentException("Matrix class not recognised by this method.");
    }

    public ComplexMatrix toComplexMatrix() {
        HDoubleComplex[] hDoubleComplexArray = new HDoubleComplex[this.matrix[0].length];
        for (int i = 0; i < this.matrix[0].length; ++i) {
            hDoubleComplexArray[i] = new HDoubleComplex(this.matrix[0][i], 0.0);
        }
        return new ComplexDiagonalMatrix(hDoubleComplexArray);
    }

    public double trace() {
        double d = this.matrix[0][0];
        for (int i = 1; i < this.matrix[0].length; ++i) {
            d += this.matrix[0][i];
        }
        return d;
    }

    public Matrix transpose() {
        return this;
    }
}

