/*
 * Decompiled with CFR 0.152.
 */
package com.hartmath.util;

import com.hartmath.expression.HDoubleComplex;
import com.hartmath.expression.HFunction;
import com.hartmath.expression.HString;
import com.hartmath.lib.C;
import com.hartmath.lib.HThrowException;
import com.hartmath.mapping.HUnaryNumerical;
import com.hartmath.util.ComplexMatrix;
import com.hartmath.util.DoubleVector;
import com.hartmath.util.MathNumber;
import com.hartmath.util.Matrix;

public class DoubleMatrix
extends Matrix {
    protected double[][] matrix;

    protected DoubleMatrix() {
    }

    public DoubleMatrix(double[][] dArray) {
        this();
        this.matrix = dArray;
    }

    public DoubleMatrix(DoubleVector[] doubleVectorArray) {
        this(doubleVectorArray.length, doubleVectorArray[0].dimension());
        for (int i = 0; i < this.matrix[0].length; ++i) {
            for (int j = 0; j < this.matrix.length; ++j) {
                this.matrix[i][j] = doubleVectorArray[j].getComponent(i);
            }
        }
    }

    public DoubleMatrix(int n, int n2) {
        this();
        this.matrix = new double[n][n2];
    }

    public DoubleMatrix add(DoubleMatrix doubleMatrix) {
        if (this.matrix.length == doubleMatrix.rows() && this.matrix[0].length == doubleMatrix.columns()) {
            double[][] dArray = new double[this.matrix.length][this.matrix[0].length];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i][0] = this.matrix[i][0] + doubleMatrix.getElement(i, 0);
                for (int j = 1; j < dArray[0].length; ++j) {
                    dArray[i][j] = this.matrix[i][j] + doubleMatrix.getElement(i, j);
                }
            }
            return new DoubleMatrix(dArray);
        }
        throw new HThrowException(C.OutOfRangeError, C.Add, new HString("Matrices have different sizes."));
    }

    public Matrix add(Matrix matrix) {
        if (matrix instanceof DoubleMatrix) {
            return this.add((DoubleMatrix)matrix);
        }
        throw new IllegalArgumentException("Matrix class not recognised by this method.");
    }

    public int columns() {
        return this.matrix[0].length;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof DoubleMatrix && this.matrix.length == ((DoubleMatrix)object).rows() && this.matrix[0].length == ((DoubleMatrix)object).columns()) {
            DoubleMatrix doubleMatrix = (DoubleMatrix)object;
            for (int i = 0; i < this.matrix.length; ++i) {
                for (int j = 0; j < this.matrix[0].length; ++j) {
                    if (!(Math.abs(this.matrix[i][j] - doubleMatrix.getElement(i, j)) > MathNumber.ZERO_TOL)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    protected void finalize() throws Throwable {
        this.matrix = null;
        super.finalize();
    }

    public double frobeniusNorm() {
        double d = 0.0;
        for (int i = 0; i < this.matrix.length; ++i) {
            for (int j = 0; j < this.matrix[0].length; ++j) {
                d += this.matrix[i][j] * this.matrix[i][j];
            }
        }
        return Math.sqrt(d);
    }

    public double getElement(int n, int n2) {
        if (n >= 0 && n < this.matrix.length && n2 >= 0 && n2 < this.matrix[0].length) {
            return this.matrix[n][n2];
        }
        throw new HThrowException(C.OutOfRangeError, C.List, new HString("Invalid element."));
    }

    public int hashCode() {
        return (int)Math.exp(this.infNorm());
    }

    public double infNorm() {
        double d = 0.0;
        for (int i = 0; i < this.matrix.length; ++i) {
            double d2 = 0.0;
            for (int j = 0; j < this.matrix[0].length; ++j) {
                d2 += Math.abs(this.matrix[i][j]);
            }
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public DoubleMatrix mapElements(HUnaryNumerical hUnaryNumerical) {
        double[][] dArray = new double[this.matrix.length][this.matrix[0].length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i][0] = hUnaryNumerical.map(this.matrix[i][0]);
            for (int j = 1; j < dArray[0].length; ++j) {
                dArray[i][j] = hUnaryNumerical.map(this.matrix[i][j]);
            }
        }
        return new DoubleMatrix(dArray);
    }

    public DoubleMatrix multiply(DoubleMatrix doubleMatrix) {
        if (this.matrix[0].length == doubleMatrix.rows()) {
            double[][] dArray = new double[this.matrix.length][doubleMatrix.columns()];
            for (int i = 0; i < dArray.length; ++i) {
                for (int j = 0; j < dArray[0].length; ++j) {
                    dArray[i][j] = this.matrix[i][0] * doubleMatrix.getElement(0, j);
                    for (int k = 1; k < this.matrix[0].length; ++k) {
                        double[] dArray2 = dArray[i];
                        int n = j;
                        dArray2[n] = dArray2[n] + this.matrix[i][k] * doubleMatrix.getElement(k, j);
                    }
                }
            }
            return new DoubleMatrix(dArray);
        }
        throw new HThrowException(C.OutOfRangeError, C.Multiply, new HString("Incompatible matrices."));
    }

    public DoubleVector multiply(DoubleVector doubleVector) {
        if (this.matrix[0].length == doubleVector.dimension()) {
            double[] dArray = new double[this.matrix.length];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = this.matrix[i][0] * doubleVector.getComponent(0);
                for (int j = 1; j < this.matrix[0].length; ++j) {
                    int n = i;
                    dArray[n] = dArray[n] + this.matrix[i][j] * doubleVector.getComponent(j);
                }
            }
            return new DoubleVector(dArray);
        }
        throw new HThrowException(C.OutOfRangeError, C.Multiply, new HString("Matrix and vector are incompatible."));
    }

    public Matrix multiply(Matrix matrix) {
        if (matrix instanceof DoubleMatrix) {
            return this.multiply((DoubleMatrix)matrix);
        }
        throw new IllegalArgumentException("Matrix class not recognised by this method.");
    }

    public int rows() {
        return this.matrix.length;
    }

    public DoubleMatrix scalarMultiply(double d) {
        double[][] dArray = new double[this.matrix.length][this.matrix[0].length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i][0] = d * this.matrix[i][0];
            for (int j = 1; j < dArray[0].length; ++j) {
                dArray[i][j] = d * this.matrix[i][j];
            }
        }
        return new DoubleMatrix(dArray);
    }

    public void setElement(int n, int n2, double d) {
        if (n < 0 || n >= this.matrix.length || n2 < 0 || n2 >= this.matrix[0].length) {
            throw new HThrowException(C.OutOfRangeError, C.List, new HString("Invalid element."));
        }
        this.matrix[n][n2] = d;
    }

    public DoubleMatrix subtract(DoubleMatrix doubleMatrix) {
        if (this.matrix.length == doubleMatrix.rows() && this.matrix[0].length == doubleMatrix.columns()) {
            double[][] dArray = new double[this.matrix.length][this.matrix[0].length];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i][0] = this.matrix[i][0] - doubleMatrix.getElement(i, 0);
                for (int j = 1; j < dArray[0].length; ++j) {
                    dArray[i][j] = this.matrix[i][j] - doubleMatrix.getElement(i, j);
                }
            }
            return new DoubleMatrix(dArray);
        }
        throw new HThrowException(C.OutOfRangeError, C.Subtract, new HString("Matrices have different sizes."));
    }

    public Matrix subtract(Matrix matrix) {
        if (matrix instanceof DoubleMatrix) {
            return this.subtract((DoubleMatrix)matrix);
        }
        throw new IllegalArgumentException("Matrix class not recognised by this method.");
    }

    public ComplexMatrix toComplexMatrix() {
        HDoubleComplex[][] hDoubleComplexArray = new HDoubleComplex[this.matrix.length][this.matrix[0].length];
        for (int i = 0; i < this.matrix.length; ++i) {
            for (int j = 0; j < this.matrix[0].length; ++j) {
                hDoubleComplexArray[i][j] = new HDoubleComplex(this.matrix[i][j], 0.0);
            }
        }
        return new ComplexMatrix(hDoubleComplexArray);
    }

    public HFunction toFunction() {
        HFunction hFunction = new HFunction(C.List);
        hFunction.setProperties(256);
        for (int i = 0; i < this.matrix.length; ++i) {
            hFunction.add(new HFunction(C.List, this.matrix[i]));
        }
        return hFunction;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.matrix.length * this.matrix[0].length);
        for (int i = 0; i < this.matrix.length; ++i) {
            for (int j = 0; j < this.matrix[0].length; ++j) {
                stringBuffer.append(this.matrix[i][j]);
                stringBuffer.append(' ');
            }
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public Matrix transpose() {
        double[][] dArray = new double[this.matrix[0].length][this.matrix.length];
        for (int i = 0; i < dArray[0].length; ++i) {
            dArray[0][i] = this.matrix[i][0];
            for (int j = 1; j < dArray.length; ++j) {
                dArray[j][i] = this.matrix[i][j];
            }
        }
        return new DoubleMatrix(dArray);
    }
}

