/*
 * Decompiled with CFR 0.152.
 */
package com.hartmath.util;

import com.hartmath.expression.HDouble;
import com.hartmath.expression.HDoubleComplex;
import com.hartmath.expression.HFunction;
import com.hartmath.expression.HString;
import com.hartmath.lib.C;
import com.hartmath.lib.HThrowException;
import com.hartmath.mapping.HUnaryNumerical;
import com.hartmath.util.ComplexVector;
import com.hartmath.util.MathNumber;
import com.hartmath.util.MathVector;

public class DoubleVector
extends MathVector {
    protected double[] vector;

    public DoubleVector(double[] dArray) {
        this.vector = dArray;
    }

    public DoubleVector(int n) {
        this.vector = new double[n];
    }

    public DoubleVector add(DoubleVector doubleVector) {
        if (this.vector.length == doubleVector.dimension()) {
            double[] dArray = new double[this.vector.length];
            dArray[0] = this.vector[0] + doubleVector.getComponent(0);
            for (int i = 1; i < dArray.length; ++i) {
                dArray[i] = this.vector[i] + doubleVector.getComponent(i);
            }
            return new DoubleVector(dArray);
        }
        throw new HThrowException(C.OutOfRangeError, C.Add, new HString("Vectors are different sizes."));
    }

    public MathVector add(MathVector mathVector) {
        if (mathVector instanceof DoubleVector) {
            return this.add((DoubleVector)mathVector);
        }
        throw new IllegalArgumentException("Vector class not recognised by this method.");
    }

    public int dimension() {
        return this.vector.length;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof DoubleVector && this.vector.length == ((DoubleVector)object).dimension()) {
            DoubleVector doubleVector = (DoubleVector)object;
            for (int i = 0; i < this.vector.length; ++i) {
                if (!(Math.abs(this.vector[i] - doubleVector.getComponent(i)) > MathNumber.ZERO_TOL)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public double getComponent(int n) {
        if (n >= 0 && n < this.vector.length) {
            return this.vector[n];
        }
        throw new HThrowException(C.OutOfRangeError, C.List, new HString("Invalid component."));
    }

    public int hashCode() {
        return (int)Math.exp(this.norm());
    }

    public double infNorm() {
        double d = this.vector[0];
        for (int i = 1; i < this.vector.length; ++i) {
            if (!(this.vector[i] > d)) continue;
            d = this.vector[i];
        }
        return d;
    }

    public DoubleVector mapComponents(HUnaryNumerical hUnaryNumerical) {
        double[] dArray = new double[this.vector.length];
        dArray[0] = hUnaryNumerical.map(this.vector[0]);
        for (int i = 1; i < this.vector.length; ++i) {
            dArray[i] = hUnaryNumerical.map(this.vector[i]);
        }
        return new DoubleVector(dArray);
    }

    public double norm() {
        double d = this.vector[0] * this.vector[0];
        for (int i = 1; i < this.vector.length; ++i) {
            d += this.vector[i] * this.vector[i];
        }
        return Math.sqrt(d);
    }

    public double norm(int n) {
        double d = Math.pow(this.vector[0], n);
        for (int i = 1; i < this.vector.length; ++i) {
            d += Math.pow(this.vector[i], n);
        }
        return Math.pow(d, 1.0 / (double)n);
    }

    public DoubleVector scalarDivide(double d) {
        double[] dArray = new double[this.vector.length];
        dArray[0] = this.vector[0] / d;
        for (int i = 1; i < dArray.length; ++i) {
            dArray[i] = this.vector[i] / d;
        }
        return new DoubleVector(dArray);
    }

    public DoubleVector scalarMultiply(double d) {
        double[] dArray = new double[this.vector.length];
        dArray[0] = d * this.vector[0];
        for (int i = 1; i < dArray.length; ++i) {
            dArray[i] = d * this.vector[i];
        }
        return new DoubleVector(dArray);
    }

    public MathVector scalarMultiply(MathNumber mathNumber) {
        if (mathNumber instanceof HDouble) {
            return this.scalarMultiply(((HDouble)mathNumber).value());
        }
        throw new IllegalArgumentException("Number class not recognised by this method.");
    }

    public double scalarProduct(DoubleVector doubleVector) {
        if (this.vector.length == doubleVector.dimension()) {
            double d = this.vector[0] * doubleVector.getComponent(0);
            for (int i = 1; i < this.vector.length; ++i) {
                d += this.vector[i] * doubleVector.getComponent(i);
            }
            return d;
        }
        throw new HThrowException(C.OutOfRangeError, C.Multiply, new HString("Vectors are different sizes."));
    }

    public void setComponent(int n, double d) {
        if (n < 0 || n >= this.vector.length) {
            throw new HThrowException(C.OutOfRangeError, C.List, new HString("Invalid component."));
        }
        this.vector[n] = d;
    }

    public DoubleVector subtract(DoubleVector doubleVector) {
        if (this.vector.length == doubleVector.dimension()) {
            double[] dArray = new double[this.vector.length];
            dArray[0] = this.vector[0] - doubleVector.getComponent(0);
            for (int i = 1; i < dArray.length; ++i) {
                dArray[i] = this.vector[i] - doubleVector.getComponent(i);
            }
            return new DoubleVector(dArray);
        }
        throw new HThrowException(C.OutOfRangeError, C.Subtract, new HString("Vectors are different sizes."));
    }

    public MathVector subtract(MathVector mathVector) {
        if (mathVector instanceof DoubleVector) {
            return this.subtract((DoubleVector)mathVector);
        }
        throw new IllegalArgumentException("Vector class not recognised by this method.");
    }

    public ComplexVector toComplexVector() {
        HDoubleComplex[] hDoubleComplexArray = new HDoubleComplex[this.vector.length];
        for (int i = 0; i < this.vector.length; ++i) {
            hDoubleComplexArray[i] = new HDoubleComplex(this.vector[i], 0.0);
        }
        return new ComplexVector(hDoubleComplexArray);
    }

    public HFunction toFunction() {
        return new HFunction(C.List, this.vector);
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer(this.vector.length);
        for (n = 0; n < this.vector.length - 1; ++n) {
            stringBuffer.append(this.vector[n]);
            stringBuffer.append(',');
        }
        stringBuffer.append(this.vector[n]);
        return stringBuffer.toString();
    }
}

