/*
 * Decompiled with CFR 0.152.
 */
package geonext;

import geonext.Angle;
import geonext.Arrow;
import geonext.CASPoint;
import geonext.Circle;
import geonext.Composition;
import geonext.Element;
import geonext.Graph;
import geonext.Group;
import geonext.Intersection;
import geonext.JBoardPane;
import geonext.Line;
import geonext.ParameterCurve;
import geonext.Point;
import geonext.Polygon;
import geonext.Slider;
import geonext.Text;
import geonext.TraceCurve;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public class ElementSet
implements UndoableEdit {
    public Vector group;
    public Vector point = new Vector();
    public Vector intersection;
    public Vector circle;
    public Vector line = new Vector();
    public Vector polygon;
    public Vector graph;
    public Vector parameterCurve;
    public Vector composition;
    public Vector slider;
    public Vector elements;
    public Vector elements2;
    public Vector text;
    public Vector traceCurve;
    public Vector arc;
    public Vector angle;
    public int groupCounter = 0;
    public int pointCounter = 0;
    public int intersectionCounter = 0;
    public int circleCounter = 0;
    public int arrowCounter = 0;
    public int polygonCounter = 0;
    public int lineCounter = 0;
    public int graphCounter = 0;
    public int parameterCurveCounter = 0;
    public int compositionCounter = 0;
    public int sliderCounter = 0;
    public int traceCurveCounter = 0;
    public int counter = 0;
    public int textCounter = 0;
    public int angleCounter = 0;
    public int arcCounter = 0;
    public Vector arrow;
    public int nameCounterPoint = 0;
    public int nameCounterPolygon = 0;
    public int nameCounterCircle = 0;
    public int nameCounterLine = 0;
    public int nameCounterAngle = 0;
    public int nameCounterAngleText = 0;
    public int nameCounterArc = 0;
    public int nameCounterGraph = 0;
    public int nameCounterGroup = 0;
    public int nameCounterParameterCurve = 0;
    public int nameCounterTrace = 0;
    public int nameCounterText = 0;
    public Hashtable nameHashtable;

    public ElementSet() {
        this.circle = new Vector();
        this.arrow = new Vector();
        this.intersection = new Vector();
        this.polygon = new Vector();
        this.group = new Vector();
        this.graph = new Vector();
        this.parameterCurve = new Vector();
        this.composition = new Vector();
        this.slider = new Vector();
        this.text = new Vector();
        this.arc = new Vector();
        this.angle = new Vector();
        this.traceCurve = new Vector();
        this.elements = new Vector();
        this.elements2 = new Vector();
    }

    public void add(Element element) {
        boolean bl = true;
        if (element instanceof Point || element instanceof CASPoint || element instanceof Slider) {
            if (((Point)element).isIntersection()) {
                bl = false;
            }
            this.addPoint(element);
        }
        if (element instanceof Line) {
            this.addLine(element);
        }
        if (element instanceof Circle) {
            this.addCircle(element);
        }
        if (element instanceof Arrow) {
            this.addArrow(element);
        }
        if (element instanceof Intersection) {
            this.addIntersection(element);
        }
        if (element instanceof Polygon) {
            this.addPolygon(element);
        }
        if (element instanceof Graph) {
            this.addGraph(element);
        }
        if (element instanceof ParameterCurve) {
            this.addParameterCurve(element);
        }
        if (element instanceof Composition) {
            this.addComposition(element);
        }
        if (element instanceof Slider) {
            this.addSlider(element);
        }
        if (element instanceof Text) {
            this.addText(element);
        }
        if (element instanceof TraceCurve) {
            this.addTrace(element);
        }
        if (element instanceof Angle) {
            this.addAngle(element);
        }
        if ((!element.isComposition() || !(element.getParent() instanceof Polygon) && !(element.getParent() instanceof Composition)) && bl) {
            this.elements.addElement(element);
            this.elements2.addElement(element);
        }
        ++this.counter;
    }

    public void addAngle(Element element) {
        this.angle.addElement(element);
        ++this.angleCounter;
    }

    public void addArrow(Element element) {
        this.arrow.addElement(element);
        ++this.arrowCounter;
    }

    public void addCircle(Element element) {
        this.circle.addElement(element);
        ++this.circleCounter;
    }

    public void addComposition(Element element) {
        this.composition.addElement(element);
        ++this.compositionCounter;
    }

    public boolean addEdit(UndoableEdit undoableEdit) {
        return false;
    }

    public void addGraph(Element element) {
        this.graph.addElement(element);
        ++this.graphCounter;
    }

    public void addIntersection(Element element) {
        this.intersection.addElement(element);
        ++this.intersectionCounter;
    }

    public void addLine(Element element) {
        this.line.addElement(element);
        ++this.lineCounter;
    }

    public void addParameterCurve(Element element) {
        this.parameterCurve.addElement(element);
        ++this.parameterCurveCounter;
    }

    public void addPoint(Element element) {
        this.point.addElement(element);
        ++this.pointCounter;
    }

    public void addPolygon(Element element) {
        this.polygon.addElement(element);
        ++this.polygonCounter;
    }

    public void addSlider(Element element) {
        this.slider.addElement(element);
        ++this.sliderCounter;
    }

    public void addText(Element element) {
        this.text.addElement(element);
        ++this.textCounter;
    }

    public void addTrace(Element element) {
        this.traceCurve.addElement(element);
        ++this.traceCurveCounter;
    }

    public boolean canRedo() {
        return true;
    }

    public boolean canUndo() {
        return true;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void die() {
    }

    public void generateName(Element element) {
        element.generateName(this);
    }

    public Vector getArrow() {
        return this.arrow;
    }

    public int getCounter() {
        return this.counter;
    }

    public Vector getDerivedElements(Element element) {
        Vector vector = new Vector();
        for (int i = 0; i < this.elements.size(); ++i) {
            if (!((Element)this.elements.get(i)).data().contains(element)) continue;
            vector.addElement(this.elements.get(i));
        }
        return vector;
    }

    public int getNameCounterPoint() {
        return this.nameCounterPoint;
    }

    public Hashtable getNameHashtable() {
        return this.nameHashtable;
    }

    public String getPresentationName() {
        return null;
    }

    public String getRedoPresentationName() {
        return null;
    }

    public Vector getSubElements(Element element) {
        Vector<Element> vector = new Vector<Element>();
        int n = 0;
        vector.addElement(element);
        while (n < vector.size()) {
            Element element2;
            if ((element2 = (Element)vector.get(n++)).getParent() instanceof Intersection) {
                if (!vector.contains(((Intersection)element2.getParent()).getA())) {
                    vector.addElement(((Intersection)element2.getParent()).getA());
                }
                if (!vector.contains(((Intersection)element2.getParent()).getB())) {
                    vector.addElement(((Intersection)element2.getParent()).getB());
                }
            } else if (element2.getParent() instanceof Composition) {
                for (int i = 0; i < ((Composition)element2.getParent()).elements.size(); ++i) {
                    if (vector.contains(((Composition)element2.getParent()).elements.get(i))) continue;
                    vector.addElement((Element)((Composition)element2.getParent()).elements.get(i));
                }
            } else if (element2.getParent() instanceof Polygon) {
                for (int i = 0; i < ((Polygon)element2.getParent()).border.length; ++i) {
                    if (vector.contains(((Polygon)element2.getParent()).border[i])) continue;
                    vector.addElement(((Polygon)element2.getParent()).border[i]);
                }
            }
            Vector vector2 = this.getDerivedElements(element2);
            for (int i = 0; i < vector2.size(); ++i) {
                int n2;
                Element element3 = (Element)vector2.get(i);
                if (element3 instanceof Intersection) {
                    if (!vector.contains(((Intersection)element3).getA())) {
                        vector.addElement(((Intersection)element3).getA());
                    }
                    if (vector.contains(((Intersection)element3).getB())) continue;
                    vector.addElement(((Intersection)element3).getB());
                    continue;
                }
                if (element3 instanceof Composition) {
                    for (n2 = 0; n2 < ((Composition)element3).elements.size(); ++n2) {
                        if (vector.contains(((Composition)element3).elements.get(n2))) continue;
                        vector.addElement((Element)((Composition)element3).elements.get(n2));
                    }
                    continue;
                }
                if (element3 instanceof Polygon) {
                    for (n2 = 0; n2 < ((Polygon)element3).border.length; ++n2) {
                        if (vector.contains(((Polygon)element3).border[n2])) continue;
                        vector.addElement(((Polygon)element3).border[n2]);
                    }
                    continue;
                }
                if (vector.contains(vector2.get(i))) continue;
                vector.addElement((Element)vector2.get(i));
            }
        }
        vector.remove(element);
        return vector;
    }

    public String getUndoPresentationName() {
        return null;
    }

    public boolean isSignificant() {
        return true;
    }

    public void redo() throws CannotRedoException {
    }

    public void rename(Element element, String string, JBoardPane jBoardPane) {
        if (!string.equals("") && element != null) {
            if (this.searchName(string) == null) {
                element.setName(string);
            } else {
                Element element2 = this.searchName(string);
                element.setName(string);
                if (element2 != element) {
                    int n = 1;
                    while (this.searchName(string + "[" + n + "]") != null) {
                        ++n;
                    }
                    element2.setName(string + "[" + n + "]");
                }
            }
        }
        try {
            element.initNameText(jBoardPane);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void remove(Element element) {
        block4: {
            block6: {
                block5: {
                    block3: {
                        this.point.remove(element);
                        this.line.remove(element);
                        this.circle.remove(element);
                        this.arrow.remove(element);
                        this.intersection.remove(element);
                        this.composition.remove(element);
                        this.slider.remove(element);
                        this.polygon.remove(element);
                        this.group.remove(element);
                        this.graph.remove(element);
                        this.parameterCurve.remove(element);
                        this.angle.remove(element);
                        this.elements.remove(element);
                        this.elements2.remove(element);
                        this.text.remove(element);
                        if (!(element instanceof Intersection)) break block3;
                        this.remove(((Intersection)element).getA());
                        this.remove(((Intersection)element).getB());
                        break block4;
                    }
                    if (!(element instanceof Composition)) break block5;
                    for (int i = 0; i < ((Composition)element).elements.size(); ++i) {
                        this.remove((Element)((Composition)element).elements.get(i));
                    }
                    break block4;
                }
                if (!(element instanceof Polygon)) break block6;
                for (int i = 0; i < ((Polygon)element).border.length; ++i) {
                    this.remove(((Polygon)element).border[i]);
                }
                break block4;
            }
            if (!(element instanceof Group)) break block4;
            for (int i = 0; i < ((Group)element).group.size(); ++i) {
                ((Point)((Group)element).group.get((int)i)).groups.remove(element);
            }
        }
    }

    public boolean replaceEdit(UndoableEdit undoableEdit) {
        return false;
    }

    public Element searchAngleText(String string) {
        Angle angle = null;
        int n = -1;
        while (angle == null && ++n < this.angle.size()) {
            if (!((Angle)this.angle.get(n)).getText().getText().equals(string)) continue;
            angle = (Angle)this.angle.get(n);
            return angle;
        }
        return angle;
    }

    public Element searchLoadID(String string) {
        Element element = null;
        int n = 0;
        while (element == null && n < this.elements.size()) {
            element = ((Element)this.elements.get(n++)).searchLoadID(string);
        }
        return element;
    }

    public Element searchName(String string) {
        Element element = null;
        int n = 0;
        while (element == null && n < this.elements.size()) {
            element = ((Element)this.elements.get(n++)).searchName(string);
        }
        return element;
    }

    public Element searchName(String string, int n) {
        Element element = null;
        int n2 = 0;
        while (element == null && n2 < this.elements.size() - n) {
            element = ((Element)this.elements.get(n2++)).searchName(string);
        }
        return null;
    }

    public void setArrow(Vector vector) {
        this.arrow = vector;
    }

    public void setCounter(int n) {
        this.counter = n;
    }

    public void setName(Element element, String string) {
        if (string != "" && string != null && this.searchName(string) == null) {
            element.setName(string);
        } else {
            this.generateName(element);
        }
    }

    public void setNameCounterPoint(int n) {
        this.nameCounterPoint = n;
    }

    public void setNameHashtable(Hashtable hashtable) {
        this.nameHashtable = hashtable;
    }

    public void undo() throws CannotUndoException {
    }

    public Vector vectorName() {
        Vector vector = new Vector();
        for (int i = 0; i < this.elements.size(); ++i) {
            for (int j = 0; j < ((Element)this.elements.get(i)).vectorName().size(); ++j) {
                vector.addElement(((Element)this.elements.get(i)).vectorName().get(j));
            }
        }
        return vector;
    }

    public void setElementsChanged(boolean bl) {
        for (int i = 0; i < this.elements.size(); ++i) {
            ((Element)this.elements.get(i)).setChanged(bl);
        }
    }

    public boolean hasAnimatedElements() {
        for (int i = 0; i < this.slider.size(); ++i) {
            if (!((Slider)this.slider.get(i)).isAnimated()) continue;
            return true;
        }
        return false;
    }
}

