/*
 * Decompiled with CFR 0.152.
 */
package geonext;

import geonext.Coordinates;
import geonext.Element;
import geonext.ElementSet;
import geonext.Geonext;
import geonext.JBoardPane;
import geonext.Point;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Vector;

class Group
extends Element {
    public Vector group;
    public int height;
    public Point center;
    public int width;
    public int x;
    public int y;

    public Group() {
        this.initGroup();
        this.group = new Vector();
    }

    public Group(String string, int n, int n2) {
        super(string, n, n2);
        this.initGroup();
        this.center = new Point();
        this.center.setParent(this);
    }

    public Group(Vector vector, int n, int n2) {
        super("G" + n, n, n2);
        this.initGroup();
        this.name = "G_" + n;
        this.group = new Vector();
        for (int i = 0; i < vector.size(); ++i) {
            if (this.group.contains(vector.get(i))) continue;
            this.group.addElement(vector.get(i));
        }
        this.center = new Point();
        this.center.setParent(this);
        this.center.setScreenX(this.getX() + this.getWidth() / 2);
        this.center.setScreenY(this.getY() + this.getHeight() / 2);
    }

    public Vector data() {
        return this.group;
    }

    public String description() {
        String string = Geonext.language.getString("group_description");
        for (int i = 0; i < this.group.size() - 1; ++i) {
            string = string + "<b>{Member#" + i + "}</b>, ";
        }
        string = string + Geonext.language.getString("group_description_and") + " <b>{Member#" + (this.group.size() - 1) + "}</b>";
        return this.generateDesc(string);
    }

    public void draw(Graphics2D graphics2D, JBoardPane jBoardPane) {
        if (this.exists() && this.isVisible()) {
            graphics2D.setStroke(jBoardPane.setStroke(this.getStrokeWidth(), this.getDash()));
            if (!this.isDraft()) {
                graphics2D.setColor(this.getFill());
                graphics2D.fillRect(this.getX() + 1, this.getY() + 1, this.getWidth() - 1, this.getHeight() - 1);
                graphics2D.setColor(this.getStroke());
            } else {
                graphics2D.setColor(this.getDraftColor());
            }
            graphics2D.drawRect(this.getX() + 1, this.getY() + 1, this.getWidth(), this.getHeight());
            if (jBoardPane.getModus() == 210220) {
                graphics2D.setColor(Color.gray);
                for (int i = 0; i < this.group.size(); ++i) {
                    graphics2D.drawLine(jBoardPane.round(this.center.getScreenX()), jBoardPane.round(this.center.getScreenY()), jBoardPane.round(((Point)this.group.get(i)).getScreenX()), jBoardPane.round(((Point)this.group.get(i)).getScreenY()));
                }
                graphics2D.setColor(Color.white);
                graphics2D.fillOval(jBoardPane.round(this.center.getScreenX()) - 8, jBoardPane.round(this.center.getScreenY()) - 8, 17, 17);
                graphics2D.setColor(Color.gray);
                this.center.draw((Graphics)graphics2D, 1);
            }
        }
    }

    public void generateName(ElementSet elementSet) {
        boolean bl = false;
        String string = "";
        int n = elementSet.nameCounterGroup++;
        String string2 = Geonext.language.getString("group_element_set_name") + " ";
        while (!bl) {
            if (elementSet.searchName(string2 + "_" + n) == null) {
                bl = true;
                continue;
            }
            string = "";
            ++elementSet.nameCounterGroup;
        }
        this.setName(string2 + "_" + n);
    }

    public Element getMember(String string) {
        int n = 0;
        try {
            n = new Integer(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (Element)this.group.get(n);
    }

    public Point getCenter() {
        return this.center;
    }

    public Coordinates getTextAnchor() {
        return ((Point)this.getGroup().get((int)0)).user;
    }

    public Vector getGroup() {
        return this.group;
    }

    public int getHeight() {
        this.height = (int)((Point)this.group.get(0)).getScreenY();
        for (int i = 0; i < this.group.size(); ++i) {
            if (!(((Point)this.group.get(i)).getScreenY() > (double)this.height)) continue;
            this.height = (int)((Point)this.group.get(i)).getScreenY();
        }
        return this.height - this.getY() + this.getArea() * 2;
    }

    public int getWidth() {
        this.width = (int)((Point)this.group.get(0)).getScreenX();
        for (int i = 0; i < this.group.size(); ++i) {
            if (!(((Point)this.group.get(i)).getScreenX() > (double)this.width)) continue;
            this.width = (int)((Point)this.group.get(i)).getScreenX();
        }
        return this.width - this.getX() + this.getArea() * 2;
    }

    public int getX() {
        this.x = (int)((Point)this.group.get(0)).getScreenX();
        for (int i = 0; i < this.group.size(); ++i) {
            if (!(((Point)this.group.get(i)).getScreenX() < (double)this.x)) continue;
            this.x = (int)((Point)this.group.get(i)).getScreenX();
        }
        return this.x - this.getArea() * 2;
    }

    public int getY() {
        this.y = (int)((Point)this.group.get(0)).getScreenY();
        for (int i = 0; i < this.group.size(); ++i) {
            if (!(((Point)this.group.get(i)).getScreenY() < (double)this.y)) continue;
            this.y = (int)((Point)this.group.get(i)).getScreenY();
        }
        return this.y - this.getArea() * 2;
    }

    public void initGroup() {
        this.area = 5;
        this.stroke = new Color(0, 0, 255, 0);
        this.fill = new Color(0, 0, 255, 0);
        this.lighting = Color.cyan;
        this.label = new Color(0, 0, 0, 75);
        this.typeString = "group";
        this.setElementName(Geonext.language.getString("group_element_name"));
    }

    public boolean parse(JBoardPane jBoardPane, String string) {
        try {
            String string2 = this.tag(string, "name")[1];
            string = this.tag(string, "name")[0];
            String string3 = this.tag(string, "data")[1];
            string = this.tag(string, "data")[0];
            boolean bl = true;
            Vector<Element> vector = new Vector<Element>();
            while (!this.tag(string3, "member")[1].equals("")) {
                vector.addElement(jBoardPane.element.searchLoadID(this.tag(string3, "member")[1]));
                string3 = this.tag(string3, "member")[0];
            }
            jBoardPane.createGroup(vector, string2, false);
            Group group = (Group)jBoardPane.element.group.lastElement();
            string = group.parseProperties(string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void setCenter(Point point) {
        this.center = point;
    }

    public void setGroup(Vector vector) {
        this.group = vector;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public void setX(int n) {
        this.x = n;
    }

    public void setY(int n) {
        this.y = n;
    }

    public String writeData(String string) {
        String string2 = "";
        for (int i = 0; i < this.group.size(); ++i) {
            string2 = string2 + string + "<member>" + ((Element)this.group.get(i)).getId() + "</member>\n ";
        }
        return string2;
    }

    public String shortInfo() {
        String string = Geonext.language.getString("group_short") + " ";
        for (int i = 0; i < this.group.size() - 1; ++i) {
            string = string + "{Member#" + i + "}, ";
        }
        string = string + "{Member#" + (this.group.size() - 1) + "}";
        return this.generateShort(string);
    }
}

