/*
 * Decompiled with CFR 0.152.
 */
package geonext;

import geonext.Circle;
import geonext.Coordinates;
import geonext.Element;
import geonext.ElementSet;
import geonext.Geonext;
import geonext.JBoardPane;
import geonext.Line;
import geonext.Point;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.Vector;

class Intersection
extends Element {
    public Element e;
    int type;
    public Element f;
    public Point A = new Point();
    public Point B = new Point();
    static final int LINELINE = 0;
    static final int LINECIRCLE = 1;
    static final int CIRCLECIRCLE = 2;
    public boolean constructionLine = false;

    public Intersection() {
        this.initIntersection();
    }

    public Intersection(String string, int n, Element element, Element element2, int n2, int n3) {
        super(string, n, n3);
        this.A.setIntersection(true);
        this.B.setIntersection(true);
        this.e = element;
        this.f = element2;
        this.type = n2;
        this.A.setParent(this);
        this.B.setParent(this);
        this.initIntersection();
    }

    public void calculate(boolean bl) {
        this.calculateChanged(bl);
        if (this.isChanged()) {
            this.getIntersection();
            if (this.type == 0) {
                this.A.sphere2user();
            } else {
                this.A.user2sphere();
                this.B.user2sphere();
            }
        }
    }

    public Vector data() {
        Vector<Element> vector = new Vector<Element>();
        vector.addElement(this.getE());
        vector.addElement(this.getF());
        return vector;
    }

    public String description() {
        switch (this.getType()) {
            case 0: {
                return this.generateDesc(Geonext.language.getString("intersection_description_a"));
            }
            case 1: {
                return this.generateDesc(Geonext.language.getString("intersection_description_b"));
            }
            case 2: {
                return this.generateDesc(Geonext.language.getString("intersection_description_c"));
            }
        }
        return Geonext.language.getString("intersection_description_d");
    }

    public double dist(Point point, Point point2) {
        return Math.sqrt((point.getUserX() - point2.getUserX()) * (point.getUserX() - point2.getUserX()) + (point.getUserY() - point2.getUserY()) * (point.getUserY() - point2.getUserY()));
    }

    public void draw(Graphics2D graphics2D, JBoardPane jBoardPane) {
        double d;
        double d2;
        double d3;
        Coordinates coordinates;
        int n;
        double d4;
        Element element;
        if (this.getA().exists() && this.getA().isVisible() && this.isConstructionLine()) {
            int n2;
            double d5;
            graphics2D.setStroke(jBoardPane.setStroke(this.getE().getStrokeWidth(), this.getE().getDash()));
            graphics2D.setColor(this.getE().getStroke());
            if (this.getE() instanceof Line) {
                element = (Line)this.getE();
                d5 = (((Line)element).getB().getScreenX() - ((Line)element).getA().getScreenX()) / ((Line)element).getA().screenDistance(((Line)element).getB());
                d4 = (((Line)element).getB().getScreenY() - ((Line)element).getA().getScreenY()) / ((Line)element).getA().screenDistance(((Line)element).getB());
                n2 = jBoardPane.round(this.getA().getScreenX() + d5 * 25.0);
                n = jBoardPane.round(this.getA().getScreenY() + d4 * 25.0);
                graphics2D.drawLine(n2, n, jBoardPane.round(this.getA().getScreenX() - d5 * 25.0), jBoardPane.round(this.getA().getScreenY() - d4 * 25.0));
            } else {
                element = (Circle)this.getE();
                Coordinates coordinates2 = ((Circle)element).user2circle(this.getA().getUser());
                coordinates = new Coordinates(coordinates2.getWidth(), ((Circle)element).getM().getUserY());
                d4 = (coordinates2.getWidth() - ((Circle)element).getM().getUserX()) / coordinates2.distance(((Circle)element).getM().getUser());
                double d6 = (coordinates2.getHeight() - coordinates.getHeight()) / coordinates2.distance(((Circle)element).getM().getUser());
                d3 = Math.acos(d4);
                if (d6 < 0.0) {
                    d3 = Math.PI * 2 - d3;
                }
                d2 = ((Circle)element).getM().userDistance(((Circle)element).getP());
                d = Math.max(0.2, Math.atan(jBoardPane.screen2userX(jBoardPane.origin.getWidth() + 25.0) / d2)) / Math.PI * 180.0;
                d3 = d3 / Math.PI * 180.0;
                graphics2D.drawArc(jBoardPane.round(jBoardPane.user2screenX(((Circle)element).getM().getUserX() - d2)), jBoardPane.round(jBoardPane.user2screenY(((Circle)element).getM().getUserY() + d2)), 2 * jBoardPane.round(jBoardPane.user2screenX(d2) - jBoardPane.origin.getWidth()), Math.abs(jBoardPane.round(2.0 * (jBoardPane.user2screenY(d2) - jBoardPane.user2screenY(0.0)))), jBoardPane.round(d3 - d), jBoardPane.round(2.0 * d));
            }
            graphics2D.setStroke(jBoardPane.setStroke(this.getF().getStrokeWidth(), this.getF().getDash()));
            graphics2D.setColor(this.getF().getStroke());
            if (this.getF() instanceof Line) {
                element = (Line)this.getF();
                d5 = (((Line)element).getB().getScreenX() - ((Line)element).getA().getScreenX()) / ((Line)element).getA().screenDistance(((Line)element).getB());
                d4 = (((Line)element).getB().getScreenY() - ((Line)element).getA().getScreenY()) / ((Line)element).getA().screenDistance(((Line)element).getB());
                n2 = jBoardPane.round(this.getA().getScreenX() + d5 * 25.0);
                n = jBoardPane.round(this.getA().getScreenY() + d4 * 25.0);
                graphics2D.drawLine(n2, n, jBoardPane.round(this.getA().getScreenX() - d5 * 25.0), jBoardPane.round(this.getA().getScreenY() - d4 * 25.0));
            } else {
                element = (Circle)this.getF();
                Coordinates coordinates3 = ((Circle)element).user2circle(this.getA().getUser());
                coordinates = new Coordinates(coordinates3.getWidth(), ((Circle)element).getM().getUserY());
                d4 = (coordinates3.getWidth() - ((Circle)element).getM().getUserX()) / coordinates3.distance(((Circle)element).getM().getUser());
                double d7 = (coordinates3.getHeight() - coordinates.getHeight()) / coordinates3.distance(((Circle)element).getM().getUser());
                d3 = Math.acos(d4);
                if (d7 < 0.0) {
                    d3 = Math.PI * 2 - d3;
                }
                d2 = ((Circle)element).getM().userDistance(((Circle)element).getP());
                d = Math.max(0.2, Math.atan(jBoardPane.screen2userX(jBoardPane.origin.getWidth() + 25.0) / d2)) / Math.PI * 180.0;
                d3 = d3 / Math.PI * 180.0;
                graphics2D.drawArc(jBoardPane.round(jBoardPane.user2screenX(((Circle)element).getM().getUserX() - d2)), jBoardPane.round(jBoardPane.user2screenY(((Circle)element).getM().getUserY() + d2)), 2 * jBoardPane.round(jBoardPane.user2screenX(d2) - jBoardPane.origin.getWidth()), Math.abs(jBoardPane.round(2.0 * (jBoardPane.user2screenY(d2) - jBoardPane.user2screenY(0.0)))), jBoardPane.round(d3 - d), jBoardPane.round(2.0 * d));
            }
        }
        if (this.getB().exists() && this.getB().isVisible() && this.isConstructionLine()) {
            graphics2D.setStroke(jBoardPane.setStroke(this.getE().getStrokeWidth(), this.getE().getDash()));
            graphics2D.setColor(this.getE().getStroke());
            if (this.getE() instanceof Line) {
                element = (Line)this.getE();
                double d8 = (((Line)element).getB().getScreenX() - ((Line)element).getA().getScreenX()) / ((Line)element).getA().screenDistance(((Line)element).getB());
                d4 = (((Line)element).getB().getScreenY() - ((Line)element).getA().getScreenY()) / ((Line)element).getA().screenDistance(((Line)element).getB());
                int n3 = jBoardPane.round(this.getB().getScreenX() + d8 * 25.0);
                n = jBoardPane.round(this.getB().getScreenY() + d4 * 25.0);
                graphics2D.drawLine(n3, n, jBoardPane.round(this.getB().getScreenX() - d8 * 25.0), jBoardPane.round(this.getB().getScreenY() - d4 * 25.0));
            } else {
                element = (Circle)this.getE();
                Coordinates coordinates4 = ((Circle)element).user2circle(this.getB().getUser());
                coordinates = new Coordinates(coordinates4.getWidth(), ((Circle)element).getM().getUserY());
                d4 = (coordinates4.getWidth() - ((Circle)element).getM().getUserX()) / coordinates4.distance(((Circle)element).getM().getUser());
                double d9 = (coordinates4.getHeight() - coordinates.getHeight()) / coordinates4.distance(((Circle)element).getM().getUser());
                d3 = Math.acos(d4);
                if (d9 < 0.0) {
                    d3 = Math.PI * 2 - d3;
                }
                d2 = ((Circle)element).getM().userDistance(((Circle)element).getP());
                d = Math.max(0.2, Math.atan(jBoardPane.screen2userX(jBoardPane.origin.getWidth() + 25.0) / d2)) / Math.PI * 180.0;
                d3 = d3 / Math.PI * 180.0;
                graphics2D.drawArc(jBoardPane.round(jBoardPane.user2screenX(((Circle)element).getM().getUserX() - d2)), jBoardPane.round(jBoardPane.user2screenY(((Circle)element).getM().getUserY() + d2)), 2 * jBoardPane.round(jBoardPane.user2screenX(d2) - jBoardPane.origin.getWidth()), Math.abs(jBoardPane.round(2.0 * (jBoardPane.user2screenY(d2) - jBoardPane.user2screenY(0.0)))), jBoardPane.round(d3 - d), jBoardPane.round(2.0 * d));
            }
            graphics2D.setStroke(jBoardPane.setStroke(this.getF().getStrokeWidth(), this.getF().getDash()));
            graphics2D.setColor(this.getF().getStroke());
            if (this.getF() instanceof Line) {
                element = (Line)this.getF();
                double d10 = (((Line)element).getB().getScreenX() - ((Line)element).getA().getScreenX()) / ((Line)element).getA().screenDistance(((Line)element).getB());
                d4 = (((Line)element).getB().getScreenY() - ((Line)element).getA().getScreenY()) / ((Line)element).getA().screenDistance(((Line)element).getB());
                int n4 = jBoardPane.round(this.getB().getScreenX() + d10 * 25.0);
                n = jBoardPane.round(this.getB().getScreenY() + d4 * 25.0);
                graphics2D.drawLine(n4, n, jBoardPane.round(this.getB().getScreenX() - d10 * 25.0), jBoardPane.round(this.getB().getScreenY() - d4 * 25.0));
            } else {
                element = (Circle)this.getF();
                Coordinates coordinates5 = ((Circle)element).user2circle(this.getB().getUser());
                coordinates = new Coordinates(coordinates5.getWidth(), ((Circle)element).getM().getUserY());
                d4 = (coordinates5.getWidth() - ((Circle)element).getM().getUserX()) / coordinates5.distance(((Circle)element).getM().getUser());
                double d11 = (coordinates5.getHeight() - coordinates.getHeight()) / coordinates5.distance(((Circle)element).getM().getUser());
                d3 = Math.acos(d4);
                if (d11 < 0.0) {
                    d3 = Math.PI * 2 - d3;
                }
                d2 = ((Circle)element).getM().userDistance(((Circle)element).getP());
                d = Math.max(0.2, Math.atan(jBoardPane.screen2userX(jBoardPane.origin.getWidth() + 25.0) / d2)) / Math.PI * 180.0;
                d3 = d3 / Math.PI * 180.0;
                graphics2D.drawArc(jBoardPane.round(jBoardPane.user2screenX(((Circle)element).getM().getUserX() - d2)), jBoardPane.round(jBoardPane.user2screenY(((Circle)element).getM().getUserY() + d2)), 2 * jBoardPane.round(jBoardPane.user2screenX(d2) - jBoardPane.origin.getWidth()), Math.abs(jBoardPane.round(2.0 * (jBoardPane.user2screenY(d2) - jBoardPane.user2screenY(0.0)))), jBoardPane.round(d3 - d), jBoardPane.round(2.0 * d));
            }
        }
    }

    public void generateName(ElementSet elementSet) {
        this.getA().generateName(elementSet);
        if (this.type != 0) {
            this.getB().generateName(elementSet);
        }
    }

    public Point getA() {
        return this.A;
    }

    public Point getB() {
        return this.B;
    }

    public Element getE() {
        return this.e;
    }

    public Element getElement(String string) {
        if (this.getType() != 0 && this.getB().getName().equals(string)) {
            return this.getB();
        }
        if (this.getA().getName().equals(string)) {
            return this.getA();
        }
        return null;
    }

    public Element getF() {
        return this.f;
    }

    public Point[] getIntersection() {
        Point[] pointArray = new Point[2];
        double d = 0.0;
        if (!this.e.exists() || !this.f.exists()) {
            this.A.setActive(false);
            this.B.setActive(false);
        } else {
            this.A.setActive(true);
            this.B.setActive(true);
        }
        switch (this.type) {
            case 0: {
                this.A.setSphere(this.cp(this.cp(((Line)this.e).getA().getSphere(), ((Line)this.e).getB().getSphere()), this.cp(((Line)this.f).getA().getSphere(), ((Line)this.f).getB().getSphere())));
                this.A.sphere2user();
                this.B.setActive(false);
                break;
            }
            case 1: {
                d = this.dist(((Line)this.e).getA(), ((Line)this.e).getB());
                if (d > 0.0) {
                    double d2;
                    double d3;
                    double d4 = this.dist(((Circle)this.f).getM(), ((Line)this.e).getA());
                    double d5 = d4 * d4 - (d3 = (d4 * d4 + d * d - (d2 = this.dist(((Circle)this.f).getM(), ((Line)this.e).getB())) * d2) / (2.0 * d)) * d3;
                    d5 = d5 < 0.0 ? 0.0 : d5;
                    double d6 = Math.sqrt(d5);
                    double d7 = this.dist(((Circle)this.f).getM(), ((Circle)this.f).getP());
                    double d8 = Math.sqrt(d7 * d7 - d6 * d6);
                    double d9 = ((Line)this.e).getB().getUserX() - ((Line)this.e).getA().getUserX();
                    double d10 = ((Line)this.e).getB().getUserY() - ((Line)this.e).getA().getUserY();
                    this.A.setUserX(((Circle)this.f).getM().getUserX() + d6 / d * d10);
                    this.A.setUserY(((Circle)this.f).getM().getUserY() - d6 / d * d9);
                    d4 = ((Line)this.e).B.getUserX() * d10 - ((Line)this.e).B.getUserY() * d9;
                    d2 = this.A.getUserX() * d9 + this.A.getUserY() * d10;
                    double d11 = d10 * d10 + d9 * d9;
                    if (Math.abs(d11) < 1.0E-5) {
                        d11 = 1.0E-5;
                    }
                    double d12 = (d4 * d10 + d2 * d9) / d11;
                    double d13 = (d2 * d10 - d4 * d9) / d11;
                    this.A.setUser(d12 + d8 / d * d9, d13 + d8 / d * d10);
                    this.B.setUser(d12 - d8 / d * d9, d13 - d8 / d * d10);
                    double d14 = this.dist(((Circle)this.f).getM(), this.A);
                    if (!(d7 < d14 - 1.0 | new Double(d14).isNaN())) break;
                    this.A.setActive(false);
                    this.B.setActive(false);
                    break;
                }
                this.A.setActive(false);
                this.B.setActive(false);
                break;
            }
            case 2: {
                d = this.dist(((Circle)this.e).getM(), ((Circle)this.f).getM());
                if (d != 0.0) {
                    double d15;
                    double d16 = this.dist(((Circle)this.e).getM(), ((Circle)this.e).getP());
                    if (d16 < (d15 = this.dist(((Circle)this.f).getM(), ((Circle)this.f).getP())) && d15 - d > d16 || d15 < d16 && d16 - d > d15 || d > d16 + d15) {
                        this.A.setActive(false);
                        this.B.setActive(false);
                        break;
                    }
                    double d17 = ((Circle)this.f).getM().getUserX() - ((Circle)this.e).getM().getUserX();
                    double d18 = ((Circle)this.f).getM().getUserY() - ((Circle)this.e).getM().getUserY();
                    double d19 = (d * d - d15 * d15 + d16 * d16) / (2.0 * d);
                    double d20 = Math.sqrt(d16 * d16 - d19 * d19);
                    this.A.setUser(((Circle)this.e).getM().getUserX() + d19 / d * d17 + d20 / d * d18, ((Circle)this.e).getM().getUserY() + d19 / d * d18 - d20 / d * d17);
                    this.B.setUser(((Circle)this.e).getM().getUserX() + d19 / d * d17 - d20 / d * d18, ((Circle)this.e).getM().getUserY() + d19 / d * d18 + d20 / d * d17);
                    break;
                }
                this.A.setActive(false);
                this.B.setActive(false);
            }
        }
        if (("" + this.A.getUserX()).equals("NaN") || ("" + this.A.getUserX()).toLowerCase().indexOf("infinity") > -1 || ("" + this.A.getUserY()).equals("NaN") || ("" + this.A.getUserY()).toLowerCase().indexOf("infinity") > -1) {
            this.A.setActive(false);
        }
        if (("" + this.B.getUserX()).equals("NaN") || ("" + this.B.getUserX()).toLowerCase().indexOf("infinity") > -1 || ("" + this.B.getUserY()).equals("NaN") || ("" + this.B.getUserY()).toLowerCase().indexOf("infinity") > -1) {
            this.B.setActive(false);
        }
        pointArray[0] = this.A;
        pointArray[1] = this.B;
        return pointArray;
    }

    public int getType() {
        return this.type;
    }

    public void initIntersection() {
        this.A.stroke = this.B.stroke = Color.gray;
        this.stroke = this.B.stroke;
        this.A.lighting = this.B.lighting = Color.green;
        this.lighting = this.B.lighting;
        this.A.label = this.B.label = new Color(0, 0, 0);
        this.label = this.B.label;
        this.typeString = "intersection";
        this.setElementName(Geonext.language.getString("intersection_element_name"));
        this.A.movable = false;
        this.B.movable = false;
    }

    public boolean isConstructionline() {
        return this.constructionLine;
    }

    public boolean isConstructionLine() {
        return this.constructionLine;
    }

    public boolean parse(JBoardPane jBoardPane, String string) {
        try {
            String string2 = this.tag(string, "name")[1];
            string = this.tag(string, "name")[0];
            String string3 = this.tag(string, "data")[1];
            string = this.tag(string, "data")[0];
            Element element = jBoardPane.element.searchLoadID(this.tag(string3, "first")[1]);
            Element element2 = jBoardPane.element.searchLoadID(this.tag(string3, "last")[1]);
            if (element == null || element2 == null || element.equals(element2)) {
                return false;
            }
            jBoardPane.createIntersection(element, element2, string2, false);
            Intersection intersection = (Intersection)jBoardPane.element.intersection.lastElement();
            string = intersection.parseProperties(string);
            intersection.setConstructionline(this.tag(string, "showconstruction")[1]);
            String string4 = this.tag(string, "first")[1];
            intersection.A.setName(this.tag(string4, "name")[1]);
            string4 = this.tag(string4, "name")[0];
            string4 = intersection.A.parseProperties(string4);
            if (intersection.getType() != 0) {
                String string5 = this.tag(string, "last")[1];
                intersection.B.setName(this.tag(string5, "name")[1]);
                string5 = this.tag(string5, "name")[0];
                string5 = intersection.B.parseProperties(string5);
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public Element searchLoadID(String string) {
        if (this.getA().getLoadID().equals(string)) {
            return this.getA();
        }
        if (this.type != 0 && this.getB().getLoadID().equals(string)) {
            return this.getB();
        }
        return null;
    }

    public Element searchName(String string) {
        if (this.getA().getName().equals(string)) {
            return this.getA();
        }
        if (this.type != 0 && this.getB().getName().equals(string)) {
            return this.getB();
        }
        return null;
    }

    public void setA(Point point) {
        this.A = point;
    }

    public void setB(Point point) {
        this.B = point;
    }

    public void setConstructionline(String string) {
        this.setConstructionLine(new Boolean(string));
    }

    public void setConstructionLine(boolean bl) {
        this.constructionLine = bl;
    }

    public void setE(Element element) {
        this.e = element;
    }

    public void setF(Element element) {
        this.f = element;
    }

    public void setType(int n) {
        this.type = n;
    }

    public Vector vectorName() {
        Vector<String> vector = new Vector<String>();
        vector.addElement(this.getA().getName());
        if (this.getType() != 0) {
            vector.addElement(this.getB().getName());
        }
        return vector;
    }

    public String writeData(String string) {
        String string2 = "";
        string2 = string2 + string + "<first>" + this.getE().getId() + "</first>\n ";
        string2 = string2 + string + "<last>" + this.getF().getId() + "</last>\n ";
        return string2;
    }

    public String writeProperties(String string) {
        String string2 = "";
        string2 = string2 + super.writeProperties(string);
        string2 = string2 + string + "<type>" + this.getType() + "</type>\n ";
        string2 = string2 + string + "<showconstruction>" + this.isConstructionLine() + "</showconstruction>\n";
        string2 = string2 + string + "<first>\n";
        string2 = string2 + string + "\t<name>" + this.getA().getName() + "</name>\n";
        string2 = string2 + string + "\t<id>" + this.getA().getId() + "</id>\n";
        string2 = string2 + this.getA().writeProperties(string + "\t");
        string2 = string2 + string + "</first>\n";
        if (this.getType() != 0) {
            string2 = string2 + string + "<last>\n";
            string2 = string2 + string + "\t<name>" + this.getB().getName() + "</name>\n";
            string2 = string2 + string + "\t<id>" + this.getB().getId() + "</id>\n";
            string2 = string2 + this.getB().writeProperties(string + "\t");
            string2 = string2 + string + "</last>\n";
        }
        return string2;
    }

    public String[] getAlgebraic() {
        switch (this.type) {
            case 0: {
                String[] stringArray = new String[]{((Line)this.e).getA().getName() + ".x", ((Line)this.e).getA().getName() + ".y"};
                String[] stringArray2 = new String[]{((Line)this.e).getB().getName() + ".x", ((Line)this.e).getB().getName() + ".y"};
                String[] stringArray3 = new String[]{((Line)this.f).getA().getName() + ".x", ((Line)this.f).getA().getName() + ".y"};
                String[] stringArray4 = new String[]{((Line)this.f).getB().getName() + ".x", ((Line)this.f).getB().getName() + ".y"};
                String string = "(" + stringArray[0] + "-" + stringArray2[0] + ")/(" + stringArray[1] + "-" + stringArray2[1] + ")-(" + stringArray[0] + "-" + this.name + ".x)/(" + stringArray[1] + "-" + this.name + ".y)=0";
                String string2 = "(" + stringArray3[0] + "-" + stringArray4[0] + ")/(" + stringArray3[1] + "-" + stringArray4[1] + ")-(" + stringArray3[0] + "-" + this.name + ".x)/(" + stringArray3[1] + "-" + this.name + ".y)=0";
                return new String[]{string, string2};
            }
        }
        return new String[]{"", ""};
    }

    public String shortInfo() {
        return this.generateShort(Geonext.language.getString("intersection_short"));
    }

    public void calculateChanged(boolean bl) {
        if (bl) {
            this.setChanged(true);
        } else {
            Vector vector = this.data();
            for (int i = 0; i < vector.size(); ++i) {
                if (!((Element)vector.get(i)).isChanged()) continue;
                this.setChanged(true);
                i = vector.size();
            }
        }
        this.A.setChanged(this.isChanged());
        this.B.setChanged(this.isChanged());
    }
}

