/*
 * Decompiled with CFR 0.152.
 */
package geonext;

import geonext.Geonext;
import geonext.JContentPanel;
import geonext.JFrameDialog;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

class JContentIO
extends JContentPanel
implements ActionListener,
Transferable {
    public Geonext geonext;
    public JTextArea srcArea;
    public boolean io;
    public JButton htmlButton;
    public JButton appletButton;
    public JButton gxtButton;
    public JButton svgButton;

    public JContentIO() {
    }

    public JContentIO(Geonext geonext, boolean bl) {
        this.geonext = geonext;
        this.io = bl;
        this.setLayout(new BorderLayout(15, 15));
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        this.srcArea = new JTextArea();
        JScrollPane jScrollPane = new JScrollPane(this.srcArea);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.setBorder(new EmptyBorder(15, 15, 15, 15));
        jPanel3.add("Center", jScrollPane);
        if (this.isIo()) {
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new GridLayout(3, 1, 10, 10));
            jPanel4.setBorder(new EmptyBorder(15, 15, 15, 15));
            jPanel4.add(new JLabel(Geonext.language.getString("jcontentio_open_step_1")));
            jPanel4.add(new JLabel(Geonext.language.getString("jcontentio_open_step_2")));
            jPanel4.add(new JLabel(Geonext.language.getString("jcontentio_open_step_3")));
            jPanel.setLayout(new BorderLayout(15, 15));
            jPanel.setBorder(new TitledBorder(new EtchedBorder(1), " " + Geonext.language.getString("jcontentio_desc") + " "));
            jPanel.add("Center", jPanel4);
            jPanel2.setLayout(new BorderLayout());
            jPanel2.setBorder(new TitledBorder(new EtchedBorder(1), " " + Geonext.language.getString("jcontentio_code") + " "));
            jPanel2.add("Center", jPanel3);
            this.add("North", jPanel);
            this.add("Center", jPanel2);
        } else {
            this.gxtButton = new JButton("gxt");
            this.gxtButton.addActionListener(this);
            this.gxtButton.setActionCommand("outgxt");
            this.htmlButton = new JButton("html");
            this.htmlButton.addActionListener(this);
            this.htmlButton.setActionCommand("outhtml");
            this.appletButton = new JButton("applet");
            this.appletButton.addActionListener(this);
            this.appletButton.setActionCommand("outapplet");
            this.svgButton = new JButton("svg");
            this.svgButton.addActionListener(this);
            this.svgButton.setActionCommand("outsvg");
            JPanel jPanel5 = new JPanel();
            jPanel5.setLayout(new GridLayout(1, 5, 5, 5));
            jPanel5.add(new JLabel());
            jPanel5.add(this.gxtButton);
            jPanel5.add(this.appletButton);
            jPanel5.add(this.htmlButton);
            jPanel5.add(this.svgButton);
            JPanel jPanel6 = new JPanel();
            jPanel6.setLayout(new BorderLayout());
            jPanel6.add("West", new JLabel(Geonext.language.getString("jcontentio_save_step_1")));
            jPanel6.add("Center", jPanel5);
            JPanel jPanel7 = new JPanel();
            jPanel7.setLayout(new GridLayout(3, 1, 0, 0));
            jPanel7.setBorder(new EmptyBorder(15, 15, 15, 15));
            jPanel7.add(jPanel6);
            jPanel7.add(new JLabel(Geonext.language.getString("jcontentio_save_step_2")));
            jPanel7.add(new JLabel(Geonext.language.getString("jcontentio_save_step_3")));
            jPanel.setLayout(new BorderLayout(15, 15));
            jPanel.setBorder(new TitledBorder(new EtchedBorder(1), " " + Geonext.language.getString("jcontentio_desc") + " "));
            jPanel.add("Center", jPanel7);
            jPanel2.setLayout(new BorderLayout());
            jPanel2.setBorder(new TitledBorder(new EtchedBorder(1), " " + Geonext.language.getString("jcontentio_code") + " "));
            jPanel2.add("Center", jPanel3);
            this.add("North", jPanel);
            this.add("Center", jPanel2);
        }
        this.validateTree();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("reset")) {
            this.reset();
        } else if (string.equals("close")) {
            this.geonext.getGeonextIODialog().dispose();
        } else if (string.equals("apply")) {
            if (this.io) {
                this.readSource();
            } else {
                this.srcArea.selectAll();
                this.srcArea.requestFocus();
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(this, null);
            }
        } else if (string.equals("cancel")) {
            this.geonext.getGeonextIODialog().dispose();
        } else if (string.startsWith("out")) {
            this.openOptionDialog(string.substring(3, string.length()));
        }
    }

    public JTextArea getSrcArea() {
        return this.srcArea;
    }

    public Object getTransferData(DataFlavor dataFlavor) throws IOException, UnsupportedFlavorException {
        if (!this.isDataFlavorSupported(dataFlavor)) {
            throw new UnsupportedFlavorException(dataFlavor);
        }
        return this.srcArea.getText();
    }

    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{DataFlavor.stringFlavor};
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return DataFlavor.stringFlavor.equals(dataFlavor);
    }

    public boolean isIo() {
        return this.io;
    }

    public void openOptionDialog(String string) {
        this.geonext.filepath = "";
        if (string.equals("applet")) {
            this.geonext.extention = "html";
            this.geonext.filepath = "xx.applet.html";
        } else {
            this.geonext.extention = string;
        }
        this.geonext.setGeonextSaveDialog(new JFrameDialog("", new Dimension(600, 500), 9, this.geonext, false, true, true, false));
        this.geonext.getGeonextSaveDialog().jcs.tp.remove(this.geonext.getGeonextSaveDialog().jcs.pathAllPanel);
        this.geonext.getGeonextSaveDialog().reset();
        this.geonext.getGeonextSaveDialog().pack();
        this.geonext.getGeonextSaveDialog().setVisible(true);
        this.geonext.getGeonextSaveDialog().show();
        this.geonext.getGeonextSaveDialog().requestFocus();
    }

    public void readSource() {
        try {
            this.geonext.readGeonext(this.srcArea.getText(), null);
            this.geonext.resizeComponents();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.geonext.getGeonextIODialog().dispose();
    }

    public void reset() {
        this.srcArea.setText(this.geonext.noAccessSrcText);
        this.srcArea.setCaretPosition(0);
    }

    public void setIo(boolean bl) {
        this.io = bl;
    }

    public void setSrcArea(JTextArea jTextArea) {
        this.srcArea = jTextArea;
    }
}

