/*
 * Decompiled with CFR 0.152.
 */
package geonext;

import geonext.Geonext;
import geonext.JBoardPane;
import geonext.JContentPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.Vector;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

class JContentPrint
extends JContentPanel
implements ActionListener,
Printable {
    public JBoardPane board;
    public JComboBox yInput;
    public DocFlavor flavor;
    public PrintRequestAttributeSet pras;
    public PrintService[] services;
    public JTextField copies;

    public JContentPrint() {
    }

    public JContentPrint(JBoardPane jBoardPane) {
        this.board = jBoardPane;
        this.setLayout(new BorderLayout(15, 15));
        this.flavor = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
        this.pras = new HashPrintRequestAttributeSet();
        this.pras.add(OrientationRequested.PORTRAIT);
        this.pras.add(new JobName("print_" + jBoardPane.getName().replaceAll(" ", "_").toLowerCase(), null));
        this.services = PrintServiceLookup.lookupPrintServices(this.flavor, this.pras);
        Vector<PrintService> vector = new Vector<PrintService>();
        if (this.services.length > 0) {
            for (int i = 0; i < this.services.length; ++i) {
                vector.addElement(this.services[i]);
            }
        }
        this.yInput = new JComboBox(vector);
        this.yInput.setEditable(false);
        this.yInput.setMaximumRowCount(5);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 1, 15, 15));
        jPanel.setBorder(new EmptyBorder(15, 15, 15, 15));
        jPanel.add(this.yInput);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setBorder(new TitledBorder(new EtchedBorder(1), " " + Geonext.language.getString("jcontentprint_printer") + " "));
        jPanel2.add("Center", jPanel);
        this.copies = new JTextField("1");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(10, 10));
        jPanel3.setBorder(new EmptyBorder(15, 15, 15, 15));
        jPanel3.add("West", new JLabel(Geonext.language.getString("jcontentprint_copies")));
        jPanel3.add("Center", this.copies);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(15, 15));
        jPanel4.setBorder(new TitledBorder(new EtchedBorder(1), " " + Geonext.language.getString("jcontentgraph_options") + " "));
        jPanel4.add("North", jPanel3);
        this.add("North", jPanel2);
        this.add("Center", jPanel4);
        this.validateTree();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("reset")) {
            this.reset();
        } else if (string.equals("close")) {
            this.print();
            this.reset();
            this.board.getGeonextPrintDialog().dispose();
        } else if (!string.equals("apply") && string.equals("cancel")) {
            this.board.getGeonextPrintDialog().dispose();
        }
        this.board.repaint();
    }

    public void reset() {
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (n == 0) {
            this.board.getJep().setScreenShot(true);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
            this.board.getJep().paint(graphics2D);
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(-250, -250, 2000, 250);
            graphics2D.fillRect(-250, this.board.getHeight(), 2000, 2000);
            graphics2D.fillRect(-250, 0, 250, this.board.getHeight());
            graphics2D.fillRect(this.board.getWidth(), 0, 2000, this.board.getHeight());
            graphics2D.setColor(Color.black);
            graphics2D.drawRect(0, 0, this.board.getWidth(), this.board.getHeight());
            graphics2D.drawString("\u00a9 2002      http://geonext.de      " + this.board.getTitle(), 0, this.board.getHeight() + graphics2D.getFontMetrics().getHeight());
            this.board.getJep().setScreenShot(false);
            return 0;
        }
        return 1;
    }

    public void print() {
        try {
            try {
                this.pras.add(new Copies(new Integer(this.copies.getText())));
            }
            catch (Exception exception) {
                this.pras.add(new Copies(1));
            }
            this.pras.add(new MediaPrintableArea(10, 10, 200, 250, 1000));
            DocPrintJob docPrintJob = this.services[this.yInput.getSelectedIndex()].createPrintJob();
            SimpleDoc simpleDoc = new SimpleDoc(this, this.flavor, null);
            docPrintJob.print(simpleDoc, this.pras);
        }
        catch (PrintException printException) {
            // empty catch block
        }
    }
}

