/*
 * Decompiled with CFR 0.152.
 */
package geonext;

import geonext.Element;
import geonext.JBoardPane;
import geonext.JObjectListRenderer;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

class JPopupList
extends JPopupMenu
implements ListSelectionListener,
PopupMenuListener {
    public JList list;
    public Element selection;
    public Vector data;
    public JBoardPane board;

    public JPopupList() {
        this.setLayout(new GridLayout(1, 1));
        this.list = new JList();
        this.add(this.list);
        this.pack();
    }

    public JPopupList(Vector vector, JBoardPane jBoardPane) {
        Serializable serializable;
        this.board = jBoardPane;
        this.setLayout(new FlowLayout(0, 3, 3));
        this.list = new JList();
        this.list.setCellRenderer(new JObjectListRenderer());
        this.data = vector;
        Vector<Serializable> vector2 = new Vector<Serializable>();
        for (int i = 0; i < this.data.size(); ++i) {
            serializable = new Vector<String>();
            ((Vector)serializable).addElement(this.getType((Element)this.data.get(i)) + " " + ((Element)this.data.get(i)).getName());
            ((Vector)serializable).addElement(this.data.get(i));
            ((Vector)serializable).addElement(jBoardPane);
            vector2.addElement(serializable);
        }
        this.list.setFixedCellHeight(25);
        this.list.setFixedCellWidth(100);
        Object[] objectArray = vector2.toArray();
        this.list.setListData(objectArray);
        this.list.addListSelectionListener(this);
        serializable = new JScrollPane(this.list);
        this.add((Component)serializable);
        this.list.setBorder(null);
        this.list.setVisibleRowCount(3);
        this.pack();
        this.addPopupMenuListener(this);
    }

    public JBoardPane getBoard() {
        return this.board;
    }

    public Element getSelection() {
        return this.selection;
    }

    public String getType(Element element) {
        return element.getElementName();
    }

    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        this.board.setListStatus(false);
        this.setSelection(null);
        this.board.jep.addMouseMotionListener(this.board);
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        this.board.setListStatus(false);
        this.setSelection(null);
        this.board.jep.addMouseMotionListener(this.board);
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        this.board.jep.removeMouseMotionListener(this.board);
    }

    public void setBoard(JBoardPane jBoardPane) {
        this.board = jBoardPane;
    }

    public void setSelection(Element element) {
        this.selection = element;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.setVisible(false);
        this.board.setListStatus(false);
        this.board.selection.addElement(this.data.get(this.list.getSelectedIndex()));
        this.board.setSelectedElement((Element)this.data.get(this.list.getSelectedIndex()));
        switch (this.board.getModus()) {
            case 77: {
                if (this.board.selection.get(0) != this.board.selection.lastElement() || this.board.selection.size() <= 3) break;
                this.board.createPolygon(this.board.selection, null, false);
                this.board.selection = new Vector();
                break;
            }
            case 68: {
                this.board.deleteElements(this.board.selection);
                break;
            }
            case 210350: {
                this.board.setElementsInvisible(this.board.selection);
                break;
            }
            case 210200: {
                this.board.setElementsDraft(this.board.selection);
                break;
            }
            case 210290: {
                this.board.setElementsNameVisible(this.board.selection);
                break;
            }
            case 210280: {
                this.board.setElementsTrace(this.board.selection);
                break;
            }
            case 210275: {
                this.board.geonext.jnp.setElement(this.board.getSelectedElement());
                break;
            }
            case 86: {
                this.board.getGeonextEditDialog().jce.selectList(this.board.selection);
                this.board.getGeonextEditDialog().requestFocus();
                this.board.reset();
                break;
            }
            default: {
                this.board.data.refreshDataTypes((Element)this.data.get(this.list.getSelectedIndex()));
                if (!this.board.data.getDataTypes().equals("")) break;
                this.board.createElement(this.board.selection, null, false);
            }
        }
        this.board.jep.addMouseMotionListener(this.board);
        this.board.jep.repaint();
    }
}

