/*
 * Decompiled with CFR 0.152.
 */
package geonext;

import com.hartmath.lib.C;
import geonext.Circle;
import geonext.Composition;
import geonext.Coordinates;
import geonext.Element;
import geonext.ElementSet;
import geonext.Geonext;
import geonext.Graph;
import geonext.Intersection;
import geonext.JBoardPane;
import geonext.Line;
import geonext.PathPoint;
import geonext.Point;
import geonext.Slider;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.Vector;

public class TraceCurve
extends Element {
    public Point tracePoint;
    public Slider slider;
    Vector path;

    public TraceCurve() {
        this.initTraceCurve();
    }

    public TraceCurve(String string, int n, int n2) {
        super(string, n, n2);
        this.initTraceCurve();
    }

    public TraceCurve(String string, int n, Slider slider, Point point, int n2) {
        super(string, n, n2);
        this.slider = slider;
        this.tracePoint = point;
        this.initTraceCurve();
    }

    public String description() {
        return this.generateDesc(Geonext.language.getString("tracecurve_description"));
    }

    public void draw(Graphics2D graphics2D, JBoardPane jBoardPane) {
        if (this.exists() && this.isVisible()) {
            double d;
            double d2;
            double d3;
            double d4;
            PathPoint pathPoint;
            int n;
            PathPoint pathPoint2;
            graphics2D.setStroke(jBoardPane.setStroke(this.getStrokeWidth(), this.getDash()));
            Slider slider = this.getSlider();
            Point point = this.getTracePoint();
            boolean bl = false;
            Color color = Color.green;
            Color color2 = Color.red;
            if (!bl) {
                color = this.getStroke();
                color2 = this.getStroke();
            }
            if (slider.getParent() instanceof Circle && this.getPath().size() > 1) {
                pathPoint2 = (PathPoint)this.getPath().get(0);
                for (n = 0; n < this.getPath().size(); ++n) {
                    pathPoint = (PathPoint)this.getPath().get(n);
                    if (pathPoint2.isDrawtonext()) {
                        d4 = pathPoint2.getScreen().getWidth();
                        d3 = pathPoint2.getScreen().getHeight();
                        d2 = pathPoint.getScreen().getWidth();
                        d = pathPoint.getScreen().getHeight();
                        if (!("" + d2).equals("NaN") && !("" + d).equals("NaN")) {
                            if (!("" + d4).equals("NaN") && !("" + d3).equals("NaN")) {
                                graphics2D.drawLine((int)d4, (int)d3, (int)d2, (int)d);
                            }
                        } else {
                            pathPoint.setDrawtonext(false);
                        }
                        if (graphics2D.getColor() == color) {
                            graphics2D.setColor(color2);
                        } else {
                            graphics2D.setColor(color);
                        }
                    }
                    pathPoint2 = pathPoint;
                }
            }
            if ((slider.getParent() instanceof Line || slider.getParent() instanceof Graph) && this.getPath().size() > 1) {
                pathPoint2 = (PathPoint)this.getPath().get(0);
                graphics2D.setColor(color);
                for (n = 0; n < this.getPath().size(); ++n) {
                    pathPoint = (PathPoint)this.getPath().get(n);
                    if (pathPoint2.isDrawtonext() && (pathPoint2.getScreen().getWidth() >= 0.0 && pathPoint2.getScreen().getWidth() <= (double)jBoardPane.getWidth() && pathPoint2.getScreen().getHeight() >= 0.0 && pathPoint2.getScreen().getHeight() <= (double)jBoardPane.getHeight() || pathPoint.getScreen().getWidth() >= 0.0 && pathPoint.getScreen().getWidth() <= (double)jBoardPane.getWidth() && pathPoint.getScreen().getHeight() >= 0.0 && pathPoint.getScreen().getHeight() <= (double)jBoardPane.getHeight())) {
                        double d5;
                        double d6;
                        double d7;
                        double d8;
                        d4 = pathPoint2.getScreen().getWidth();
                        d3 = pathPoint2.getScreen().getHeight();
                        d2 = pathPoint.getScreen().getWidth();
                        d = pathPoint.getScreen().getHeight();
                        if (d4 < 0.0 || d4 > (double)jBoardPane.getWidth() || d3 < 0.0 || d3 > (double)jBoardPane.getHeight() || d2 < 0.0 || d2 > (double)jBoardPane.getWidth() || d < 0.0 || d > (double)jBoardPane.getHeight()) {
                            Coordinates[] coordinatesArray = new Coordinates[]{new Coordinates(d4, d3), new Coordinates(d2, d)};
                            Coordinates[] coordinatesArray2 = jBoardPane.getLineToDraw(coordinatesArray, 10);
                            d8 = coordinatesArray2[0].getWidth();
                            d7 = coordinatesArray2[0].getHeight();
                            d6 = coordinatesArray2[1].getWidth();
                            d5 = coordinatesArray2[1].getHeight();
                        } else {
                            d8 = d4;
                            d7 = d3;
                            d6 = d2;
                            d5 = d;
                        }
                        if (!("" + d6).equals("NaN") && !("" + d5).equals("NaN")) {
                            if (!("" + d8).equals("NaN") && !("" + d7).equals("NaN")) {
                                graphics2D.drawLine((int)d8, (int)d7, (int)d6, (int)d5);
                            }
                        } else {
                            pathPoint.setDrawtonext(false);
                        }
                        if (graphics2D.getColor() == color) {
                            graphics2D.setColor(color2);
                        } else {
                            graphics2D.setColor(color);
                        }
                    }
                    pathPoint2 = pathPoint;
                }
            }
        }
    }

    public void generateName(ElementSet elementSet) {
        boolean bl = false;
        String string = "";
        int n = elementSet.nameCounterTrace++;
        String string2 = Geonext.language.getString("tracecurve_auto_name");
        while (!bl) {
            if (elementSet.searchName(string2 + "" + n) == null) {
                bl = true;
                continue;
            }
            string = "";
            ++elementSet.nameCounterTrace;
        }
        this.setName(string2 + "" + n);
    }

    public Vector getPath() {
        return this.path;
    }

    public Slider getSlider() {
        return this.slider;
    }

    public Point getTracePoint() {
        return this.tracePoint;
    }

    public void initTraceCurve() {
        this.strokeWidth = 1;
        this.typeString = "tracecurve";
        this.setElementName(Geonext.language.getString("tracecurve_element_name"));
    }

    public boolean parse(JBoardPane jBoardPane, String string) {
        try {
            String string2 = this.tag(string, "name")[1];
            string = this.tag(string, "name")[0];
            String string3 = this.tag(string, "data")[1];
            string = this.tag(string, "data")[0];
            Point point = (Point)jBoardPane.element.searchLoadID(this.tag(string3, "tracepoint")[1]);
            Slider slider = (Slider)jBoardPane.element.searchLoadID(this.tag(string3, "traceslider")[1]);
            if (point == null || slider == null || point.equals(slider)) {
                return false;
            }
            jBoardPane.createTraceCurve(slider, point, string2, false);
            TraceCurve traceCurve = (TraceCurve)jBoardPane.element.traceCurve.lastElement();
            string = traceCurve.parseProperties(string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void recalculate(int n, JBoardPane jBoardPane) {
        this.tracePoint.setUserX(Double.NaN);
        this.tracePoint.setUserY(Double.NaN);
        try {
            for (int i = n; i < this.tracePoint.ancestor.size(); ++i) {
                Element element = (Element)this.tracePoint.ancestor.get(i);
                if (element.ancestor.size() <= 0 || !(element instanceof Point) && !(element instanceof Composition) && !(element instanceof Intersection) && !(element instanceof Circle)) continue;
                if (element.parent instanceof Composition || element.parent instanceof Intersection) {
                    if (!element.parent.exists()) {
                        return;
                    }
                    element.parent.calculate(true);
                }
                if (element.parent instanceof Circle && ((Circle)element.parent).radius != null) {
                    if (!element.parent.exists()) {
                        return;
                    }
                    ((Circle)element.parent).calculate(jBoardPane, true);
                }
                if (element instanceof Circle && ((Circle)element).radius != null) {
                    if (!element.exists()) {
                        return;
                    }
                    ((Circle)element).calculate(jBoardPane, true);
                    continue;
                }
                if (!element.exists()) {
                    return;
                }
                element.calculate(true);
            }
            if (this.tracePoint.parent instanceof Composition || this.tracePoint.parent instanceof Intersection) {
                if (!this.tracePoint.parent.exists()) {
                    return;
                }
                this.tracePoint.parent.calculate(true);
            }
            if (!this.tracePoint.exists()) {
                return;
            }
            this.tracePoint.calculate(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setPath(Vector vector) {
        this.path = vector;
    }

    public void setSlider(Slider slider) {
        this.slider = slider;
    }

    public void setTracePoint(Point point) {
        this.tracePoint = point;
    }

    public String writeData(String string) {
        String string2 = "";
        string2 = string2 + string + "<tracepoint>" + this.getTracePoint().getId() + "</tracepoint>\n ";
        string2 = string2 + string + "<traceslider>" + this.getSlider().getId() + "</traceslider>\n ";
        return string2;
    }

    public String shortInfo() {
        return this.generateShort(Geonext.language.getString("tracecurve_short"));
    }

    public Vector data() {
        Vector<Element> vector = new Vector<Element>();
        try {
            for (int i = this.tracePoint.ancestor.indexOf(this.slider) + 1; i < this.tracePoint.ancestor.size(); ++i) {
                vector.add((Element)this.tracePoint.ancestor.get(i));
            }
            vector.add(this.getSlider().getParent());
            vector.add(this.getTracePoint());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return vector;
    }

    public void calculate(JBoardPane jBoardPane, boolean bl) {
        if (jBoardPane.getSelectedPoint() == this.getSlider() && !bl) {
            this.setChanged(false);
        } else {
            this.calculateChanged(bl);
        }
        if (this.isChanged()) {
            C.boardName = jBoardPane.internalName;
            this.path = new Vector();
            if (this.slider.getParent() instanceof Circle) {
                this.calculateCircle(jBoardPane);
            }
            if (this.slider.getParent() instanceof Line) {
                this.calculateLine(jBoardPane);
            }
            if (this.slider.getParent() instanceof Graph) {
                this.calculateGraph(jBoardPane);
            }
        }
    }

    public void calculateLine(JBoardPane jBoardPane) {
        int n;
        Line line = (Line)this.slider.getParent();
        Coordinates[] coordinatesArray = jBoardPane.getLinesIntersectionWithViewport(line, 10);
        double d = this.slider.getPosition();
        Coordinates coordinates = this.slider.user;
        double d2 = Math.log(jBoardPane.zoom.getWidth()) / Math.log(1500.0);
        double d3 = 75.0;
        double d4 = Math.PI / d3;
        double d5 = 0.0;
        double d6 = 0.0;
        int n2 = this.tracePoint.ancestor.indexOf(this.slider);
        boolean bl = false;
        boolean bl2 = false;
        double[] dArray = this.tracePoint.normVector(this.tracePoint.cp(line.getA().getSphere(), line.getB().getSphere()));
        double d7 = dArray[0];
        double d8 = dArray[1];
        double d9 = Math.sqrt(d7 * d7 + d8 * d8);
        double[] dArray2 = this.tracePoint.normVector(new double[]{d8, -d7, 0.0});
        double[] dArray3 = this.tracePoint.normVector(this.tracePoint.cp(dArray2, dArray));
        PathPoint pathPoint = null;
        PathPoint pathPoint2 = null;
        int n3 = 0;
        double d10 = 0.0;
        double d11 = 0.0;
        if (line.isFirst() && line.isLast()) {
            d10 = 0.0;
            d11 = Math.PI;
        }
        if (!line.isFirst() && !line.isLast() && (d10 = jBoardPane.getAngleOnShpericCircleSystem(dArray2, dArray3, line.getA())) > (d11 = jBoardPane.getAngleOnShpericCircleSystem(dArray2, dArray3, line.getB()))) {
            d10 += d11;
            d11 = d10 - d11;
            d10 -= d11;
        }
        if (line.isFirst() && !line.isLast()) {
            d10 = jBoardPane.getAngleOnShpericCircleSystem(dArray2, dArray3, line.getA());
            if (d10 < (d11 = jBoardPane.getAngleOnShpericCircleSystem(dArray2, dArray3, line.getB()))) {
                d10 = 0.0;
            }
            if (d10 > d11) {
                d10 = d11;
                d11 = Math.PI;
            }
        }
        if (!line.isFirst() && line.isLast()) {
            d10 = jBoardPane.getAngleOnShpericCircleSystem(dArray2, dArray3, line.getA());
            if (d10 < (d11 = jBoardPane.getAngleOnShpericCircleSystem(dArray2, dArray3, line.getB()))) {
                d11 = Math.PI;
            }
            if (d10 > d11) {
                d11 = d10;
                d10 = 0.0;
            }
        }
        double d12 = d10 - d4;
        while (!bl) {
            ++n3;
            if (d12 > d11 - d4) {
                d12 = d11 - d4;
                bl = true;
            }
            try {
                this.slider.setSphere(new double[]{dArray2[0] * Math.cos(d12 += d4) + dArray3[0] * Math.sin(d12), dArray2[1] * Math.cos(d12) + dArray3[1] * Math.sin(d12), dArray2[2] * Math.cos(d12) + dArray3[2] * Math.sin(d12)});
                this.slider.sphere2user();
                this.recalculate(n2 + 1, jBoardPane);
                jBoardPane.user2screen(this.tracePoint);
                this.path.addElement(new PathPoint(this.tracePoint.getUser(), this.tracePoint.getScreen(), d12, true));
            }
            catch (Exception exception) {}
        }
        double[] dArray4 = new double[]{jBoardPane.getAngleOnShpericCircleSystem(dArray2, dArray3, coordinatesArray[0]), jBoardPane.getAngleOnShpericCircleSystem(dArray2, dArray3, coordinatesArray[1])};
        for (n = 0; n < 2; ++n) {
            d12 = dArray4[n];
            if (!(d12 >= d10) || !(d12 <= d11)) continue;
            this.slider.setSphere(new double[]{dArray2[0] * Math.cos(d12) + dArray3[0] * Math.sin(d12), dArray2[1] * Math.cos(d12) + dArray3[1] * Math.sin(d12), dArray2[2] * Math.cos(d12) + dArray3[2] * Math.sin(d12)});
            this.slider.sphere2user();
            this.recalculate(n2 + 1, jBoardPane);
            jBoardPane.user2screen(this.tracePoint);
            boolean bl3 = false;
            if (((PathPoint)this.path.get(0)).getParameter() >= d12) {
                if (((PathPoint)this.path.get(0)).getParameter() > d12) {
                    this.path.insertElementAt(new PathPoint(this.tracePoint.getUser(), this.tracePoint.getScreen(), d12, true), 0);
                }
                bl3 = true;
                continue;
            }
            for (int i = 0; i < this.path.size() - 1; ++i) {
                if (!(((PathPoint)this.path.get(i)).getParameter() <= d12) || !(((PathPoint)this.path.get(i + 1)).getParameter() >= d12)) continue;
                if (((PathPoint)this.path.get(i)).getParameter() != d12 && ((PathPoint)this.path.get(i + 1)).getParameter() != d12) {
                    this.path.insertElementAt(new PathPoint(this.tracePoint.getUser(), this.tracePoint.getScreen(), d12, true), i + 1);
                }
                bl3 = true;
            }
            if (bl3 || !(((PathPoint)this.path.get(this.path.size() - 1)).getParameter() < d12)) continue;
            this.path.addElement(new PathPoint(this.tracePoint.getUser(), this.tracePoint.getScreen(), d12, true));
        }
        for (n = 0; n < this.path.size() - 1; ++n) {
            if (((PathPoint)this.path.get(n)).getParameter() != dArray4[0] && ((PathPoint)this.path.get(n)).getParameter() != dArray4[1] && ((PathPoint)this.path.get(n + 1)).getParameter() != dArray4[0] && ((PathPoint)this.path.get(n + 1)).getParameter() != dArray4[1] && !((PathPoint)this.path.get(n)).isinViewPort(0.0, jBoardPane.getWidth(), 0.0, jBoardPane.getHeight()) && !((PathPoint)this.path.get(n + 1)).isinViewPort(0.0, jBoardPane.getWidth(), 0.0, jBoardPane.getHeight())) continue;
            d12 = ((PathPoint)this.path.get(n)).getParameter();
            double d13 = ((PathPoint)this.path.get(n + 1)).getParameter();
            d4 = (d13 - d12) / (20.0 * Math.sqrt(jBoardPane.zoom.getWidth()));
            d12 += d4;
            pathPoint = null;
            pathPoint2 = null;
            double d14 = d4 / 2.0;
            while (d12 < d13) {
                this.slider.setSphere(new double[]{dArray2[0] * Math.cos(d12) + dArray3[0] * Math.sin(d12), dArray2[1] * Math.cos(d12) + dArray3[1] * Math.sin(d12), dArray2[2] * Math.cos(d12) + dArray3[2] * Math.sin(d12)});
                this.slider.sphere2user();
                this.recalculate(n2 + 1, jBoardPane);
                jBoardPane.user2screen(this.tracePoint);
                try {
                    if (pathPoint != null && pathPoint2 != null) {
                        double d15 = 0.0;
                        double d16 = 0.0;
                        double d17 = 0.0;
                        double d18 = 0.0;
                        try {
                            d5 = Math.sqrt(Math.pow((double)pathPoint.getScreenX() - this.tracePoint.getScreenX(), 2.0) + Math.pow((double)pathPoint.getScreenY() - this.tracePoint.getScreenY(), 2.0));
                            d15 = (pathPoint2.getScreen().getHeight() - pathPoint.getScreen().getHeight()) / (pathPoint2.getScreen().getWidth() - pathPoint.getScreen().getWidth());
                            d16 = (pathPoint.getScreen().getHeight() - this.tracePoint.getScreen().getHeight()) / (pathPoint.getScreen().getWidth() - this.tracePoint.getScreen().getWidth());
                            d17 = d16 / d15;
                            d18 = (d16 - d15) * jBoardPane.zoom.getWidth();
                        }
                        catch (Exception exception) {
                            d17 = pathPoint2.getScreenY() - pathPoint.getScreenY() < 2 ? 0.5 : 0.1;
                        }
                        if (d18 == 0.0 || d4 <= d14 | (d18 < 0.5 && d17 >= 0.3 && d17 <= 1.8) | pathPoint.equals(this.tracePoint)) {
                            bl2 = false;
                            pathPoint2 = pathPoint;
                            pathPoint = new PathPoint(this.tracePoint.getUser(), this.tracePoint.getScreen(), d12, true);
                            this.path.insertElementAt(pathPoint, ++n);
                            if (d17 >= 0.9 && d17 <= 1.1 && Math.abs(d18) < 1.0) {
                                d4 += d4 / 10.0;
                            }
                            d6 = d5;
                        } else {
                            bl2 = true;
                            bl = false;
                            d12 -= d4;
                            if ((d4 -= d4 / 10.0) < d14) {
                                d4 = d14;
                            }
                        }
                    } else {
                        pathPoint2 = pathPoint;
                        pathPoint = new PathPoint(this.tracePoint.getUser(), this.tracePoint.getScreen(), d12, true);
                        this.path.insertElementAt(new PathPoint(this.tracePoint.getUser(), this.tracePoint.getScreen(), d12, true), ++n);
                    }
                    d12 += d4;
                }
                catch (Exception exception) {}
            }
        }
        this.slider.position = d;
        this.recalculate(n2, jBoardPane);
        jBoardPane.user2screen(this.tracePoint);
    }

    public void calculateCircle(JBoardPane jBoardPane) {
        double d = this.slider.getPosition();
        double d2 = 0.1;
        double d3 = -d2;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.04 / jBoardPane.zoom.getWidth();
        int n = this.tracePoint.ancestor.indexOf(this.slider);
        boolean bl = false;
        boolean bl2 = false;
        PathPoint pathPoint = null;
        PathPoint pathPoint2 = null;
        double d7 = Math.log(jBoardPane.zoom.getWidth()) / Math.log(1500.0);
        int n2 = 0;
        double d8 = 0.0;
        while (!bl) {
            ++n2;
            if (d3 > Math.PI * 2 - d2) {
                d8 = d3;
                d3 = -d2;
                bl = true;
            }
            this.slider.position = d3 += d2;
            this.recalculate(n, jBoardPane);
            jBoardPane.user2screen(this.tracePoint);
            try {
                if (pathPoint != null && pathPoint2 != null) {
                    double d9 = 0.0;
                    double d10 = 0.0;
                    double d11 = 0.0;
                    double d12 = 0.0;
                    try {
                        d4 = Math.sqrt(Math.pow((double)pathPoint.getScreenX() - this.tracePoint.getScreenX(), 2.0) + Math.pow((double)pathPoint.getScreenY() - this.tracePoint.getScreenY(), 2.0));
                        d9 = (pathPoint2.getScreen().getHeight() - pathPoint.getScreen().getHeight()) / (pathPoint2.getScreen().getWidth() - pathPoint.getScreen().getWidth());
                        d10 = (pathPoint.getScreen().getHeight() - this.tracePoint.getScreen().getHeight()) / (pathPoint.getScreen().getWidth() - this.tracePoint.getScreen().getWidth());
                        d11 = d10 / d9;
                        d12 = (d10 - d9) * jBoardPane.zoom.getWidth();
                    }
                    catch (Exception exception) {
                        d11 = pathPoint2.getScreenY() - pathPoint.getScreenY() < 2 ? 0.5 : 0.1;
                    }
                    if (d12 == 0.0 | d9 == 0.0 | (d2 <= d6 | (Math.abs(d12 * (pathPoint.getUser().getWidth() - this.tracePoint.getUser().getWidth())) <= 5.0 && d11 >= 0.65 * (d7 + 1.0) && d11 * (d7 + 1.0) <= 1.6) | pathPoint.equals(this.tracePoint))) {
                        bl2 = false;
                        pathPoint2 = pathPoint;
                        if (this.path.size() > 2 && d4 - d5 > 50.0 * jBoardPane.zoom.getWidth() && d4 / d5 > 0.99 || d2 <= d6 && d4 > 300.0 * jBoardPane.zoom.getWidth()) {
                            try {
                                ((PathPoint)this.path.get(this.path.size() - 1)).setDrawtonext(false);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        pathPoint = new PathPoint(this.tracePoint.getUser(), this.tracePoint.getScreen(), d3, true);
                        this.path.addElement(pathPoint);
                        if (Math.abs(d12 * (pathPoint.getUser().getWidth() - this.tracePoint.getUser().getWidth())) <= 2.5 && d11 >= 0.8 * (d7 + 1.0) && d11 <= 1.3 * (d7 + 1.0)) {
                            d2 += d2 / 20.0;
                        }
                        d5 = d4;
                        continue;
                    }
                    bl2 = true;
                    d3 = bl ? d8 : (d3 -= d2);
                    bl = false;
                    if (!((d2 -= d2 / 10.0) < d6)) continue;
                    d2 = d6;
                    continue;
                }
                pathPoint2 = pathPoint;
                pathPoint = new PathPoint(this.tracePoint.getUser(), this.tracePoint.getScreen(), d3, true);
                this.path.addElement(pathPoint);
            }
            catch (Exception exception) {}
        }
        this.slider.position = d;
        this.recalculate(n, jBoardPane);
        jBoardPane.user2screen(this.tracePoint);
    }

    public void calculateGraph(JBoardPane jBoardPane) {
        int n;
        double d;
        boolean bl = false;
        Coordinates[] coordinatesArray = new Coordinates[]{new Coordinates(jBoardPane.screen2userX(0.0), 0.0), new Coordinates(jBoardPane.screen2userX(jBoardPane.getWidth()), 0.0)};
        double d2 = this.slider.getUserX();
        Coordinates coordinates = this.slider.user;
        double d3 = Math.log(jBoardPane.zoom.getWidth()) / Math.log(1500.0);
        double d4 = 50.0;
        double d5 = Math.PI / d4;
        double d6 = 0.0;
        double d7 = 0.0;
        int n2 = this.tracePoint.ancestor.indexOf(this.slider);
        boolean bl2 = false;
        boolean bl3 = false;
        double[] dArray = new double[]{1.0, 0.0, 0.0};
        double[] dArray2 = new double[]{0.0, 0.0, 1.0};
        PathPoint pathPoint = null;
        PathPoint pathPoint2 = null;
        int n3 = 0;
        double d8 = 0.0;
        double d9 = Math.PI;
        double d10 = d8 - d5;
        this.path = new Vector();
        Point point = new Point();
        double d11 = jBoardPane.getAngleOnShpericCircleSystem(dArray, dArray2, coordinatesArray[0]);
        if (d11 > (d = jBoardPane.getAngleOnShpericCircleSystem(dArray, dArray2, coordinatesArray[1]))) {
            double d12 = d;
            d = d11;
            d11 = d12;
        }
        if (bl) {
            while (!bl2) {
                ++n3;
                if (d10 > d9 - d5) {
                    d10 = d9 - d5;
                    bl2 = true;
                }
                try {
                    point.setSphere(new double[]{dArray[0] * Math.cos(d10 += d5) + dArray2[0] * Math.sin(d10), dArray[1] * Math.cos(d10) + dArray2[1] * Math.sin(d10), dArray[2] * Math.cos(d10) + dArray2[2] * Math.sin(d10)});
                    point.sphere2user();
                    this.slider.setUser(point.getUser());
                    this.recalculate(n2, jBoardPane);
                    jBoardPane.user2screen(this.tracePoint);
                    this.path.addElement(new PathPoint(this.tracePoint.getUser(), this.tracePoint.getScreen(), d10, true));
                }
                catch (Exception exception) {}
            }
        }
        double[] dArray3 = new double[]{d11, d};
        for (n = 0; n < 2; ++n) {
            d10 = dArray3[n];
            try {
                if (!(d10 >= d8) || !(d10 <= d9)) continue;
                point.setSphere(new double[]{dArray[0] * Math.cos(d10) + dArray2[0] * Math.sin(d10), dArray[1] * Math.cos(d10) + dArray2[1] * Math.sin(d10), dArray[2] * Math.cos(d10) + dArray2[2] * Math.sin(d10)});
                point.sphere2user();
                this.slider.setUser(point.getUser());
                this.recalculate(n2, jBoardPane);
                jBoardPane.user2screen(this.tracePoint);
                boolean bl4 = false;
                try {
                    if (((PathPoint)this.path.get(0)).getParameter() >= d10) {
                        if (((PathPoint)this.path.get(0)).getParameter() > d10) {
                            this.path.insertElementAt(new PathPoint(this.tracePoint.getUser(), this.tracePoint.getScreen(), d10, true), 0);
                        }
                        bl4 = true;
                        continue;
                    }
                    for (int i = 0; i < this.path.size() - 1; ++i) {
                        if (!(((PathPoint)this.path.get(i)).getParameter() <= d10) || !(((PathPoint)this.path.get(i + 1)).getParameter() >= d10)) continue;
                        if (((PathPoint)this.path.get(i)).getParameter() != d10 && ((PathPoint)this.path.get(i + 1)).getParameter() != d10) {
                            this.path.insertElementAt(new PathPoint(this.tracePoint.getUser(), this.tracePoint.getScreen(), d10, true), i + 1);
                        }
                        bl4 = true;
                    }
                    if (bl4 || !(((PathPoint)this.path.get(this.path.size() - 1)).getParameter() < d10)) continue;
                    this.path.addElement(new PathPoint(this.tracePoint.getUser(), this.tracePoint.getScreen(), d10, true));
                }
                catch (Exception exception) {
                    if (bl4) continue;
                    this.path.addElement(new PathPoint(this.tracePoint.getUser(), this.tracePoint.getScreen(), d10, true));
                }
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (n = 0; n < this.path.size() - 1; ++n) {
            if (((PathPoint)this.path.get(n)).getParameter() != dArray3[0] && ((PathPoint)this.path.get(n)).getParameter() != dArray3[1] && ((PathPoint)this.path.get(n + 1)).getParameter() != dArray3[0] && ((PathPoint)this.path.get(n + 1)).getParameter() != dArray3[1] && !((PathPoint)this.path.get(n)).isinViewPort(0.0, jBoardPane.getWidth(), 0.0, jBoardPane.getHeight()) && !((PathPoint)this.path.get(n + 1)).isinViewPort(0.0, jBoardPane.getWidth(), 0.0, jBoardPane.getHeight())) continue;
            d10 = ((PathPoint)this.path.get(n)).getParameter();
            double d13 = ((PathPoint)this.path.get(n + 1)).getParameter();
            d5 = 10.0 * (d13 - d10) / (double)Math.abs(((PathPoint)this.path.get(n + 1)).getScreenX() - ((PathPoint)this.path.get(n)).getScreenX());
            d10 += d5;
            pathPoint = null;
            pathPoint2 = null;
            double d14 = d5 / 2.0;
            while (d10 < d13) {
                point.setSphere(new double[]{dArray[0] * Math.cos(d10) + dArray2[0] * Math.sin(d10), dArray[1] * Math.cos(d10) + dArray2[1] * Math.sin(d10), dArray[2] * Math.cos(d10) + dArray2[2] * Math.sin(d10)});
                point.sphere2user();
                this.slider.setUser(point.getUser());
                this.slider.position = d10;
                this.recalculate(n2, jBoardPane);
                jBoardPane.user2screen(this.tracePoint);
                try {
                    if (pathPoint != null && pathPoint2 != null) {
                        double d15 = 0.0;
                        double d16 = 0.0;
                        double d17 = 0.0;
                        double d18 = 0.0;
                        try {
                            d6 = Math.sqrt(Math.pow((double)pathPoint.getScreenX() - this.tracePoint.getScreenX(), 2.0) + Math.pow((double)pathPoint.getScreenY() - this.tracePoint.getScreenY(), 2.0));
                            d15 = (pathPoint2.getScreen().getHeight() - pathPoint.getScreen().getHeight()) / (pathPoint2.getScreen().getWidth() - pathPoint.getScreen().getWidth());
                            d16 = (pathPoint.getScreen().getHeight() - this.tracePoint.getScreen().getHeight()) / (pathPoint.getScreen().getWidth() - this.tracePoint.getScreen().getWidth());
                            d17 = d16 / d15;
                            d18 = (d16 - d15) * jBoardPane.zoom.getWidth();
                        }
                        catch (Exception exception) {
                            d17 = pathPoint2.getScreenY() - pathPoint.getScreenY() < 2 ? 0.5 : 0.1;
                        }
                        if (d5 <= d14 | (Math.abs(d18) < 0.5 && d17 >= 0.3 && d17 <= 1.8) | pathPoint.equals(this.tracePoint)) {
                            bl3 = false;
                            pathPoint2 = pathPoint;
                            pathPoint = new PathPoint(this.tracePoint.getUser(), this.tracePoint.getScreen(), d10, true);
                            this.path.insertElementAt(pathPoint, ++n);
                            if (d17 >= 0.9 && d17 <= 1.1 && Math.abs(d18) < 1.0) {
                                d5 += d5 / 10.0;
                            }
                            d7 = d6;
                        } else {
                            bl3 = true;
                            bl2 = false;
                            d10 -= d5;
                            if ((d5 -= d5 / 10.0) < d14) {
                                d5 = d14;
                            }
                        }
                    } else {
                        pathPoint2 = pathPoint;
                        pathPoint = new PathPoint(this.tracePoint.getUser(), this.tracePoint.getScreen(), d10, true);
                        this.path.insertElementAt(new PathPoint(this.tracePoint.getUser(), this.tracePoint.getScreen(), d10, true), ++n);
                    }
                    d10 += d5;
                }
                catch (Exception exception) {}
            }
        }
        this.slider.setUser(new Coordinates(d2, 0.0));
        this.recalculate(n2, jBoardPane);
        try {
            jBoardPane.user2screen(this.tracePoint);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

