/*
 * Decompiled with CFR 0.152.
 */
package org.kaffe.java.util;

import java.io.Serializable;
import org.kaffe.java.lang.Comparable;
import org.kaffe.java.util.ArrayList;
import org.kaffe.java.util.Comparator;
import org.kaffe.java.util.List;

public class Arrays {
    static final Comparator DEFAULT_COMPARATOR = new DefCmp();

    private Arrays() {
    }

    public static List asList(Object[] objectArray) {
        return new ArrayList(objectArray);
    }

    public static int binarySearch(byte[] byArray, byte by) {
        int n = 0;
        for (int i = byArray.length; i != 0; i >>= 1) {
            int n2 = n + (i >> 1);
            if (by == byArray[n2]) {
                return n2;
            }
            if (by <= byArray[n2]) continue;
            n = n2 + 1;
            --i;
        }
        return ~n;
    }

    public static int binarySearch(char[] cArray, char c) {
        int n = 0;
        for (int i = cArray.length; i != 0; i >>= 1) {
            int n2 = n + (i >> 1);
            if (c == cArray[n2]) {
                return n2;
            }
            if (c <= cArray[n2]) continue;
            n = n2 + 1;
            --i;
        }
        return ~n;
    }

    public static int binarySearch(double[] dArray, double d) {
        long l = Double.doubleToLongBits(d);
        int n = 0;
        for (int i = dArray.length; i != 0; i >>= 1) {
            int n2 = n + (i >> 1);
            long l2 = Double.doubleToLongBits(dArray[n2]);
            if (l == l2) {
                return n2;
            }
            if (l <= l2) continue;
            n = n2 + 1;
            --i;
        }
        return ~n;
    }

    public static int binarySearch(float[] fArray, float f) {
        int n = Float.floatToIntBits(f);
        int n2 = 0;
        for (int i = fArray.length; i != 0; i >>= 1) {
            int n3 = n2 + (i >> 1);
            int n4 = Float.floatToIntBits(fArray[n3]);
            if (n == n4) {
                return n3;
            }
            if (n <= n4) continue;
            n2 = n3 + 1;
            --i;
        }
        return ~n2;
    }

    public static int binarySearch(int[] nArray, int n) {
        int n2 = 0;
        for (int i = nArray.length; i != 0; i >>= 1) {
            int n3 = n2 + (i >> 1);
            if (n == nArray[n3]) {
                return n3;
            }
            if (n <= nArray[n3]) continue;
            n2 = n3 + 1;
            --i;
        }
        return ~n2;
    }

    public static int binarySearch(long[] lArray, long l) {
        int n = 0;
        for (int i = lArray.length; i != 0; i >>= 1) {
            int n2 = n + (i >> 1);
            if (l == lArray[n2]) {
                return n2;
            }
            if (l <= lArray[n2]) continue;
            n = n2 + 1;
            --i;
        }
        return ~n;
    }

    public static int binarySearch(Object[] objectArray, Object object) {
        return Arrays.binarySearch(objectArray, object, DEFAULT_COMPARATOR);
    }

    public static int binarySearch(Object[] objectArray, Object object, Comparator comparator) {
        int n = 0;
        for (int i = objectArray.length; i != 0; i >>= 1) {
            int n2 = n + (i >> 1);
            int n3 = comparator.compare(object, objectArray[n2]);
            if (n3 == 0) {
                return n2;
            }
            if (n3 <= 0) continue;
            n = n2 + 1;
            --i;
        }
        return ~n;
    }

    public static int binarySearch(short[] sArray, short s) {
        int n = 0;
        for (int i = sArray.length; i != 0; i >>= 1) {
            int n2 = n + (i >> 1);
            if (s == sArray[n2]) {
                return n2;
            }
            if (s <= sArray[n2]) continue;
            n = n2 + 1;
            --i;
        }
        return ~n;
    }

    public static boolean equals(byte[] byArray, byte[] byArray2) {
        try {
            if (byArray.length != byArray2.length) {
                return false;
            }
            int n = byArray.length;
            while (n-- > 0) {
                if (byArray[n] == byArray2[n]) continue;
                return false;
            }
            return true;
        }
        catch (NullPointerException nullPointerException) {
            return byArray == byArray2;
        }
    }

    public static boolean equals(char[] cArray, char[] cArray2) {
        try {
            if (cArray.length != cArray2.length) {
                return false;
            }
            int n = cArray.length;
            while (n-- > 0) {
                if (cArray[n] == cArray2[n]) continue;
                return false;
            }
            return true;
        }
        catch (NullPointerException nullPointerException) {
            return cArray == cArray2;
        }
    }

    public static boolean equals(double[] dArray, double[] dArray2) {
        try {
            if (dArray.length != dArray2.length) {
                return false;
            }
            int n = dArray.length;
            while (n-- > 0) {
                if (dArray[n] == dArray2[n]) continue;
                return false;
            }
            return true;
        }
        catch (NullPointerException nullPointerException) {
            return dArray == dArray2;
        }
    }

    public static boolean equals(float[] fArray, float[] fArray2) {
        try {
            if (fArray.length != fArray2.length) {
                return false;
            }
            int n = fArray.length;
            while (n-- > 0) {
                if (fArray[n] == fArray2[n]) continue;
                return false;
            }
            return true;
        }
        catch (NullPointerException nullPointerException) {
            return fArray == fArray2;
        }
    }

    public static boolean equals(int[] nArray, int[] nArray2) {
        try {
            if (nArray.length != nArray2.length) {
                return false;
            }
            int n = nArray.length;
            while (n-- > 0) {
                if (nArray[n] == nArray2[n]) continue;
                return false;
            }
            return true;
        }
        catch (NullPointerException nullPointerException) {
            return nArray == nArray2;
        }
    }

    public static boolean equals(long[] lArray, long[] lArray2) {
        try {
            if (lArray.length != lArray2.length) {
                return false;
            }
            int n = lArray.length;
            while (n-- > 0) {
                if (lArray[n] == lArray2[n]) continue;
                return false;
            }
            return true;
        }
        catch (NullPointerException nullPointerException) {
            return lArray == lArray2;
        }
    }

    public static boolean equals(Object[] objectArray, Object[] objectArray2) {
        try {
            if (objectArray.length != objectArray2.length) {
                return false;
            }
            int n = objectArray.length;
            while (n-- > 0) {
                if (objectArray[n].equals(objectArray2[n])) continue;
                return false;
            }
            return true;
        }
        catch (NullPointerException nullPointerException) {
            return objectArray == objectArray2;
        }
    }

    public static boolean equals(short[] sArray, short[] sArray2) {
        try {
            if (sArray.length != sArray2.length) {
                return false;
            }
            int n = sArray.length;
            while (n-- > 0) {
                if (sArray[n] == sArray2[n]) continue;
                return false;
            }
            return true;
        }
        catch (NullPointerException nullPointerException) {
            return sArray == sArray2;
        }
    }

    public static boolean equals(boolean[] blArray, boolean[] blArray2) {
        try {
            if (blArray.length != blArray2.length) {
                return false;
            }
            int n = blArray.length;
            while (n-- > 0) {
                if (blArray[n] == blArray2[n]) continue;
                return false;
            }
            return true;
        }
        catch (NullPointerException nullPointerException) {
            return blArray == blArray2;
        }
    }

    public static void fill(byte[] byArray, byte by) {
        Arrays.fill(byArray, 0, byArray.length, by);
    }

    public static void fill(byte[] byArray, int n, int n2, byte by) {
        int n3 = n2;
        while (n3-- > n) {
            byArray[n3] = by;
        }
    }

    public static void fill(char[] cArray, char c) {
        Arrays.fill(cArray, 0, cArray.length, c);
    }

    public static void fill(char[] cArray, int n, int n2, char c) {
        int n3 = n2;
        while (n3-- > n) {
            cArray[n3] = c;
        }
    }

    public static void fill(double[] dArray, double d) {
        Arrays.fill(dArray, 0, dArray.length, d);
    }

    public static void fill(double[] dArray, int n, int n2, double d) {
        int n3 = n2;
        while (n3-- > n) {
            dArray[n3] = d;
        }
    }

    public static void fill(float[] fArray, float f) {
        Arrays.fill(fArray, 0, fArray.length, f);
    }

    public static void fill(float[] fArray, int n, int n2, float f) {
        int n3 = n2;
        while (n3-- > n) {
            fArray[n3] = f;
        }
    }

    public static void fill(int[] nArray, int n) {
        Arrays.fill(nArray, 0, nArray.length, n);
    }

    public static void fill(int[] nArray, int n, int n2, int n3) {
        int n4 = n2;
        while (n4-- > n) {
            nArray[n4] = n3;
        }
    }

    public static void fill(long[] lArray, int n, int n2, long l) {
        int n3 = n2;
        while (n3-- > n) {
            lArray[n3] = l;
        }
    }

    public static void fill(long[] lArray, long l) {
        Arrays.fill(lArray, 0, lArray.length, l);
    }

    public static void fill(Object[] objectArray, int n, int n2, Object object) {
        int n3 = n2;
        while (n3-- > n) {
            objectArray[n3] = object;
        }
    }

    public static void fill(Object[] objectArray, Object object) {
        Arrays.fill(objectArray, 0, objectArray.length, object);
    }

    public static void fill(short[] sArray, int n, int n2, short s) {
        int n3 = n2;
        while (n3-- > n) {
            sArray[n3] = s;
        }
    }

    public static void fill(short[] sArray, short s) {
        Arrays.fill(sArray, 0, sArray.length, s);
    }

    public static void fill(boolean[] blArray, int n, int n2, boolean bl) {
        int n3 = n2;
        while (n3-- > n) {
            blArray[n3] = bl;
        }
    }

    public static void fill(boolean[] blArray, boolean bl) {
        Arrays.fill(blArray, 0, blArray.length, bl);
    }

    public static void sort(Object[] objectArray) {
        Arrays.sort(objectArray, 0, objectArray.length, DEFAULT_COMPARATOR);
    }

    public static void sort(Object[] objectArray, int n, int n2) {
        Arrays.sort(objectArray, n, n2, DEFAULT_COMPARATOR);
    }

    public static void sort(Object[] objectArray, int n, int n2, Comparator comparator) {
        if (n < 0 || n2 > objectArray.length || n > n2) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n3 = n2 - 1;
        int n4 = n + 1;
        if (n3 > n4) {
            int n5 = n3;
            do {
                Object object;
                Object object2;
                int n6;
                for (n6 = n3; n6 >= n4; --n6) {
                    object2 = objectArray[n6];
                    object = objectArray[n6 - 1];
                    if (comparator.compare(object2, object) >= 0) continue;
                    objectArray[n6 - 1] = object2;
                    objectArray[n6] = object;
                    n5 = n6;
                }
                for (n6 = n4 = n5 + 1; n6 <= n3; ++n6) {
                    object2 = objectArray[n6];
                    object = objectArray[n6 - 1];
                    if (comparator.compare(object2, object) >= 0) continue;
                    objectArray[n6 - 1] = object2;
                    objectArray[n6] = object;
                    n5 = n6;
                }
            } while (n4 <= (n3 = n5 - 1));
        }
    }

    public static void sort(Object[] objectArray, Comparator comparator) {
        Arrays.sort(objectArray, 0, objectArray.length, comparator);
    }

    private static class DefCmp
    implements Serializable,
    Comparator {
        private DefCmp() {
        }

        public int compare(Object object, Object object2) {
            return ((Comparable)object).compareTo(object2);
        }
    }
}

