/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public abstract class CharacterEncoder {
    protected PrintStream pStream;

    abstract int bytesPerAtom();

    abstract int bytesPerLine();

    abstract void encodeAtom(OutputStream var1, byte[] var2, int var3, int var4) throws IOException;

    public String encodeBuffer(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            this.encodeBuffer(byteArrayInputStream, (OutputStream)byteArrayOutputStream);
        }
        catch (Exception exception) {
            throw new Error("ChracterEncoder::encodeBuffer internal error");
        }
        return byteArrayOutputStream.toString();
    }

    public void encodeBuffer(byte[] byArray, OutputStream outputStream) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        this.encodeBuffer(byteArrayInputStream, outputStream);
    }

    public void encodeBuffer(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[this.bytesPerLine()];
        this.encodeBufferPrefix(outputStream);
        while ((n = this.readFully(inputStream, byArray)) != -1) {
            this.encodeLinePrefix(outputStream, n);
            for (int i = 0; i < n; i += this.bytesPerAtom()) {
                if (i + this.bytesPerAtom() <= n) {
                    this.encodeAtom(outputStream, byArray, i, this.bytesPerAtom());
                    continue;
                }
                this.encodeAtom(outputStream, byArray, i, n - i);
            }
            this.encodeLineSuffix(outputStream);
            if (n >= this.bytesPerLine()) continue;
        }
        this.encodeBufferSuffix(outputStream);
    }

    void encodeBufferPrefix(OutputStream outputStream) throws IOException {
        this.pStream = new PrintStream(outputStream);
    }

    void encodeBufferSuffix(OutputStream outputStream) throws IOException {
    }

    void encodeLinePrefix(OutputStream outputStream, int n) throws IOException {
    }

    void encodeLineSuffix(OutputStream outputStream) throws IOException {
        this.pStream.println();
    }

    protected int readFully(InputStream inputStream, byte[] byArray) throws IOException {
        for (int i = 0; i < byArray.length; ++i) {
            int n = inputStream.read();
            if (n == -1) {
                return i;
            }
            byArray[i] = (byte)n;
        }
        return byArray.length;
    }
}

