#include <gtk/gtk.h>
#include <stdarg.h>
#include <sys/stat.h>
#include <openssl/evp.h>
#include <sys/types.h>
#include "ghasher.h"

void show_error_dialog(GtkWidget *mainWindow, const gchar * message, ...)
{
	va_list args;
	char *res;

	GtkWidget *dialog;

	va_start(args, message);
	res = g_strdup_vprintf(message, args);
	va_end(args);
	dialog = gtk_message_dialog_new(GTK_WINDOW(mainWindow), GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, res);
	g_free(res);
	gtk_window_set_resizable(GTK_WINDOW(dialog), FALSE);
	gtk_dialog_run(GTK_DIALOG(dialog));
	gtk_widget_destroy(dialog);

}

char *hex_dump(const unsigned char in[], int len, char out[], int max)
{
#define HIGH_NIBBLE(c)  ( ((c) & 0xF0) >> 4 )
#define LOW_NIBBLE(c)   (  (c) & 0x0F)

	int i, t, hn, ln;

	if (len <= 0 || max <= 0) {
		out[0] = '\0';
		return out;
	}

	for (i = 0, t = 0; i < len; ++i) {
		if (t + 1 >= max) {
			break;
		}

		hn = HIGH_NIBBLE(in[i]);
		ln = LOW_NIBBLE(in[i]);

		out[t++] = (hn > 9) ? hn + 'W' : hn + '0';
		if (t + 1 >= max) {
			break;
		}
		out[t++] = (ln > 9) ? ln + 'W' : ln + '0';
	}

	out[t] = '\0';

	return out;
#undef HIGH_NIBBLE
#undef LOW_NIBBLE
}
