#ifndef _GHASHER_H_
#define _GHASHER_H_

#include <openssl/evp.h>
#include <openssl/opensslv.h>
#include <gtk/gtk.h>
#include <sys/stat.h>

struct SumContext;
struct GHApp {
	GtkWidget *window;
	GtkWidget *progress;
	GtkWidget *listview;
	GtkWidget *clearbutton;
	GtkWidget *digestbutton;
	GtkWidget *cancelbutton;
	GtkWidget *addbutton;
	GtkWidget *savebutton;
	GtkWidget *pathbutton;
	GtkWidget *verifybutton;
	GtkWidget *digestdropdown;	/*treat as a GtkWidget only, it's diffrent on gtk2.2 vs gtk 2.4 */
	const gchar *digesttype;
	GPtrArray *files;
	gint currentfile;	/*index into files*/
	struct SumContext *currentsum;
};

struct SumContext {
	struct GHApp *app;
	EVP_MD_CTX ctx;
	const EVP_MD *md;
	int currentfile;
	struct stat statbuf;
	off_t read_acc;
	gboolean allok;
	gboolean finished;
};

struct ActionButton {
	const gchar *const name;
	 gboolean(*callback) (GtkButton * button, struct GHApp *app);
};


void show_error_dialog(GtkWidget *mainWindow, const gchar *message, ...);
char *hex_dump(const unsigned char in[], int len, char out[], int max);
void set_hashfield(GtkTreeView *view, const gchar *hash, const gchar *filename);
void fill_list_view(GtkTreeView *view, const GPtrArray *files);
GtkWidget *create_list_view(GtkWidget *treeview);
GString *listview_get_data(struct GHApp *app);
void listview_show_full_path(GtkWidget *treeview,gboolean fullpath,int col);
void pathbutton_toggled(GtkToggleToolButton *button, struct GHApp *app);
void  verifybutton_clicked(GtkButton *button, struct GHApp *app);
void verify_sumfile(GtkWidget  *mainwindow,GtkListStore *filestore,int hashcol,int filecol,const char *filename);
#endif
