#include <gtk/gtk.h>
#include <sys/types.h>
#include "ghasher.h"

enum {
	COLUMN_FILENAME = 0,
	COLUMN_HASH,
	NUM_COLUMNS
};


static void list_show_filename (GtkTreeViewColumn *tree_column,GtkCellRenderer *cell,GtkTreeModel *model,GtkTreeIter *iter, gpointer data);
void pathbutton_toggled(GtkToggleToolButton *button, struct GHApp *app)
{
	listview_show_full_path(app->listview,gtk_toggle_tool_button_get_active(button),COLUMN_FILENAME);
	/*gtk_tree_view_columns_autosize(GTK_TREE_VIEW(app->listview));*/
}

GtkWidget *create_list_view(GtkWidget *treeview)
{

	GtkListStore *store;
	GtkCellRenderer *renderer;
	GtkTreeViewColumn *column;

	store = gtk_list_store_new(NUM_COLUMNS, G_TYPE_STRING, G_TYPE_STRING);
/*      gtk_tree_view_set_rules_hint (GTK_TREE_VIEW (treeview), TRUE);*/
	gtk_tree_view_set_model(GTK_TREE_VIEW(treeview),GTK_TREE_MODEL(store));
	g_object_unref(store);
	renderer = gtk_cell_renderer_text_new();
	column = gtk_tree_view_column_new_with_attributes("Filename", renderer, "text", COLUMN_FILENAME, NULL);

	gtk_tree_view_column_set_resizable(column, TRUE);
	gtk_tree_view_column_set_sort_column_id(column, COLUMN_FILENAME);
	gtk_tree_view_append_column(GTK_TREE_VIEW(treeview), column);

	renderer = gtk_cell_renderer_text_new();
	column = gtk_tree_view_column_new_with_attributes("Hash", renderer, "text", COLUMN_HASH, NULL);
	gtk_tree_view_column_set_resizable(column, TRUE);
	gtk_tree_view_column_set_sort_column_id(column, COLUMN_HASH);
	gtk_tree_view_append_column(GTK_TREE_VIEW(treeview), column);
	listview_show_full_path(treeview,FALSE,COLUMN_FILENAME);
	gtk_widget_show(treeview);

	return treeview;

}
void listview_show_full_path(GtkWidget *treeview,gboolean fullpath,int col)
{
	GtkTreeViewColumn *column;
	GList *renderers,*tmp;
	GtkTreeCellDataFunc func;

	func = fullpath ? NULL : list_show_filename;

	column = gtk_tree_view_get_column(GTK_TREE_VIEW(treeview),col);
	renderers = gtk_tree_view_column_get_cell_renderers(column);
	tmp = renderers;
	while(tmp){
		GtkCellRenderer *renderer;
		renderer = tmp->data;	
		gtk_tree_view_column_set_cell_data_func (column, renderer,func, NULL, NULL);
		tmp = tmp->next;		
	}

	g_list_free(renderers);
}

void  verifybutton_clicked(GtkButton *button, struct GHApp *app)
{
	GtkWidget *file_selector;
	gint ret;
	static gchar *lastdir = NULL;

	file_selector = gtk_file_chooser_dialog_new("Select a file to digest. ", GTK_WINDOW(app->window), 
		GTK_FILE_CHOOSER_ACTION_OPEN, GTK_STOCK_OPEN,GTK_RESPONSE_OK, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,NULL);
	gtk_file_chooser_set_local_only(GTK_FILE_CHOOSER(file_selector), TRUE);	
	if (lastdir != NULL)
		gtk_file_chooser_set_current_folder(GTK_FILE_CHOOSER(file_selector), lastdir);

	ret = gtk_dialog_run(GTK_DIALOG(file_selector));
	if (ret == GTK_RESPONSE_OK) {
		gchar *filename;
		GtkListStore *store;


		filename = gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(file_selector));
		store = GTK_LIST_STORE(gtk_tree_view_get_model(GTK_TREE_VIEW(app->listview)));

		g_free(lastdir);
		lastdir = gtk_file_chooser_get_current_folder(GTK_FILE_CHOOSER(file_selector));
		gtk_widget_destroy(file_selector);

		verify_sumfile(app->window,store,COLUMN_HASH,COLUMN_FILENAME,filename);
		g_free(filename);

		return;
	}

	gtk_widget_destroy(file_selector);
}

GString *listview_get_data(struct GHApp *app)
{
	GtkTreeIter iter;
	GtkListStore *store;
	GString *str;
	gboolean fullpath;

	store = GTK_LIST_STORE(gtk_tree_view_get_model(GTK_TREE_VIEW(app->listview)));
	if (!gtk_tree_model_get_iter_first(GTK_TREE_MODEL(store), &iter)) {
		return NULL;
	}
	fullpath = gtk_toggle_tool_button_get_active(GTK_TOGGLE_TOOL_BUTTON(app->pathbutton));
	str = g_string_new("");

	do {
		gchar *h = NULL,*f = NULL;
		gtk_tree_model_get(GTK_TREE_MODEL(store), &iter, COLUMN_FILENAME, &f, -1);
		if (f == NULL) {
			continue;
		}
		gtk_tree_model_get(GTK_TREE_MODEL(store), &iter, COLUMN_HASH, &h, -1);
		if (h == NULL) {
			g_free(f);
			continue;
		}
		if(!fullpath){
			gchar *base = g_path_get_basename(f);
			g_free(f);
			f = base;
		}
		g_string_append_printf(str,"%s  %s\n",h,f);

		g_free(f);
		g_free(h);

	} while (gtk_tree_model_iter_next(GTK_TREE_MODEL(store), &iter));
	
	return str;
}

void fill_list_view(GtkTreeView *view, const GPtrArray *files)
{
	guint i;
	GtkListStore *store;
	store = GTK_LIST_STORE(gtk_tree_view_get_model(view));
	gtk_list_store_clear(store);
	for (i = 0; i < files->len; i++) {
		GtkTreeIter iter;
		gtk_list_store_append(store, &iter);
		gtk_list_store_set(store, &iter, COLUMN_FILENAME, g_ptr_array_index(files, i), -1);
	}

}

static void list_show_filename (GtkTreeViewColumn *tree_column,GtkCellRenderer *cell,GtkTreeModel *model,GtkTreeIter *iter, gpointer data)
{
	gchar *name = NULL;
  
	gtk_tree_model_get (model, iter,COLUMN_FILENAME, &name,-1);
  	if(name != NULL){ 
		gchar *base = g_path_get_basename(name);
		g_object_set (cell,"text", base,NULL);
		g_free(base);
		g_free(name);
  	}
}

void set_hashfield(GtkTreeView *view, const gchar *hash, const gchar *filename)
{
	GtkTreeIter iter;
	GtkListStore *store;

	store = GTK_LIST_STORE(gtk_tree_view_get_model(view));

	if (!gtk_tree_model_get_iter_first(GTK_TREE_MODEL(store), &iter))
		return;

	do {
		gchar *f = NULL;
		gtk_tree_model_get(GTK_TREE_MODEL(store), &iter, COLUMN_FILENAME, &f, -1);
		if (f == NULL)
			continue;
		if (g_ascii_strcasecmp(f, filename) == 0) {
			gtk_list_store_set(store, &iter, COLUMN_HASH, hash, -1);
			g_free(f);
			break;

		}
		g_free(f);

	} while (gtk_tree_model_iter_next(GTK_TREE_MODEL(store), &iter));

}

