/* Copyright (C) 2002 CANON INC.

   Ghostscript printer driver
   for Canon CPCA printer devices (LIPS IV)

   Changed by Canon Inc.
   Date of change: 7 May 2002
*/

/* Copyright (C) 1998-2000 Norihito Ohmori.

   Ghostscript printer driver
   for Canon LBP, BJC-680J and BJC-880J printers (LIPS II+/III/IVc/IV)

   This software is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY.  No author or distributor accepts responsibility
   to anyone for the consequences of using it or for whether it serves any
   particular purpose or works at all, unless he says so in writing.  Refer
   to the GNU General Public License for full details.

   Everyone is granted permission to copy, modify and redistribute
   this software, but only under the conditions described in the GNU
   General Public License.  A copy of this license is supposed to have been
   given to you along with this software so you can know your rights and
   responsibilities.  It should be in a file named COPYING.  Among other
   things, the copyright notice and this notice must be preserved on all
   copies.

*/

/*$Id: cpca_gdevlips.h $ */
/* Common header file for LIPS driver */

#define	LIPS_ESC        "\x1b"
#define	LIPS_FF         "\x0c"
#define	LIPS_CSI        "\x9b" /* LIPS_ESC "[" */
#define	LIPS_DCS        "\x90" /* LIPS_ESC "P" */
#define	LIPS_ST         "\x9c" /* LIPS_ESC "\\" */
#define LIPS_SP         "\x20"
#define LIPS_IS1        "\x1f"
#define LIPS_IS2        "\x1e"

#define TRUE 1
#define FALSE 0

/* Media Size */
#define LIPS_A3_HEIGHT              1190
#define LIPS_A3_WIDTH               842
#define LIPS_A4_HEIGHT              LIPS_A3_WIDTH
#define LIPS_A4_WIDTH               595
#define LIPS_A5_HEIGHT              LIPS_A4_WIDTH
#define LIPS_A5_WIDTH               421
#define LIPS_POSTCARD_HEIGHT        419
#define LIPS_POSTCARD_WIDTH         284
#define LIPS_B4_HEIGHT              1032
#define LIPS_B4_WIDTH               729
#define LIPS_B5_HEIGHT              LIPS_B4_WIDTH
#define LIPS_B5_WIDTH               516
#define LIPS_B6_HEIGHT              LIPS_B5_WIDTH
#define LIPS_B6_WIDTH               363
#define LIPS_LETTER_HEIGHT          792
#define LIPS_LETTER_WIDTH           612
#define LIPS_LEGAL_HEIGHT           1008
#define LIPS_LEGAL_WIDTH            LIPS_LETTER_WIDTH
#define LIPS_LEDGER_HEIGHT          1224
#define LIPS_LEDGER_WIDTH           LIPS_LETTER_HEIGHT
#define LIPS_EXECTIVE_HEIGHT        756
#define LIPS_EXECTIVE_WIDTH         522
#define LIPS_ENVYOU4_HEIGHT         666
#define LIPS_ENVYOU4_WIDTH          298

#define LIPS_HEIGHT_MAX             LIPS_A3_HEIGHT
#define LIPS_WIDTH_MAX              LIPS_A3_WIDTH
#define LIPS_HEIGHT_MIN             LIPS_POSTCARD_HEIGHT
#define LIPS_WIDTH_MIN              LIPS_POSTCARD_WIDTH

#define MMETER_PER_INCH             25.4

#define A3_SIZE                     12
#define A4_SIZE                     14
#define A5_SIZE                     16
#define POSTCARD_SIZE               18
#define DBL_POSTCARD_SIZE           20
#define B4_SIZE                     24
#define B5_SIZE                     26
#define LETTER_SIZE                 30
#define LEGAL_SIZE                  32
#define LEDGER_SIZE                 34
#define EXECUTIVE_SIZE              40
#define ENVYOU4_SIZE                50
#define ENVYOU2_SIZE                52
#define ENVKAKU2_SIZE               54
#define USER_SIZE                   80

#define LANDSCAPE                   1

#define LIPS_CASSETFEED_DEFAULT     0
/* 0, 1 to 3, 10 to 17 (1 to 3 is not reccomended. It's obsoleted value.) */
/* 0: Auto Feed */
/* 1: MP tray, 2: Lower casset, 3: Upper casset */
/* 10: MP tray, 11: casset 1, 12: casset 2, 13: casset 3, .... */

#define LIPS_NUP_DEFAULT            1
#define LIPS_FACEUP_DEFAULT         FALSE

/* display text to printer panel */
#define LIPS_USERNAME_MAX           127

#define LIPS_MEDIACHAR_MAX          32
#define LIPS_USERNAME_DEFAULT       "Ghostscript"
#define LIPS_MEDIATYPE_DEFAULT      "Default"   /* Dummy */

#define LIPS4_DPI_DEFAULT           600

#define LIPS4_LEFT_MARGIN_DEFAULT   5. / MMETER_PER_INCH
#define LIPS4_BOTTOM_MARGIN_DEFAULT 5. / MMETER_PER_INCH
#define LIPS4_RIGHT_MARGIN_DEFAULT  5. / MMETER_PER_INCH
#define LIPS4_TOP_MARGIN_DEFAULT    5. / MMETER_PER_INCH

#define LIPS_BINDLOC_DEFAULT        "Default"
#define LIPS_GUTTER_DEFAULT         0
#define LIPS_COLLATE_DEFAULT        0
#define LIPS_LANDSCAPE_DEFAULT      0
#define LIPS_OUTBIN_DEFAULT         0
#define LIPS_SORT_DEFAULT           0
#define LIPS_STACK_DEFAULT          0
#define LIPS_STAPLE_DEFAULT         "Default"
#define LIPS_MODEH_DEFAULT          0

/* Define the default resolutions. */
#define LIPS4_DPI_SUPERFINE         1200
#define LIPS4_DPI_FINE              600
#define LIPS4_DPI_QUICK             300

#define L4VMONO_STRING              "lips4v:"
#define L4VCOLOR_STRING             "lips4vc:"
#define LIPS_VERSION                "2.4.0"

/* ``LIPS*_STRING'' + ``VERSION string'' < 17 characters */

#define LIPS_BINDLOC_MAX            16
#define LIPS_STAPLE_MAX             16

#define CANON_LIPS4_MIN_COPIES      1
#define CANON_LIPS4_MAX_COPIES      2000

/* LIPS Option */
#define LIPS_OPTION_CASSETFEED      "Casset"
#define LIPS_OPTION_USER_NAME       "UserName"

/* LIPS IV Option */
#define LIPS_OPTION_NUP             "Nup"
#define LIPS_OPTION_TONERDENSITY    "TonerDensity"
#define LIPS_OPTION_TONERSAVING     "TonerSaving"
#define LIPS_OPTION_FONTDOWNLOAD    "FontDL"
#define LIPS_OPTION_FACEUP          "OutputFaceUp"
#define LIPS_OPTION_MEDIATYPE       "MediaType"

#define LIPS_OPTION_BINDLOC         "BindingLocation"
#define LIPS_OPTION_GUTTER          "Gutter"
#define LIPS_OPTION_COLLATE         "Collate"
#define LIPS_OPTION_LANDSCAPE       "Landscape"
#define LIPS_OPTION_OUTBIN          "OutputBin"
#define LIPS_OPTION_SORT            "Sort"
#define LIPS_OPTION_STACK           "Stack"
#define LIPS_OPTION_STAPLE          "Staple"
#define LIPS_OPTION_MODEH           "SpecialModeH"

#define LBP1310                     1310
#define LBP1510                     1510
#define LBP1610                     1610
#define LBP1710                     1710
#define LBP1810                     1810
#define LBP1910                     1910



#define lips_params_common \
    int cassetFeed;                    /* Input Casset */ \
    char Username[LIPS_USERNAME_MAX];  /* Display text on printer panel */\
    int toner_density;\
    bool toner_saving;\
    bool toner_saving_set;\
    int prev_paper_size; \
    int prev_paper_width; \
    int prev_paper_height; \
    int prev_num_copies; \
    int prev_feed_mode;

#define lips4_params_common \
    int prev_duplex_mode;\
    int nup;\
    bool faceup;\
    char mediaType[LIPS_MEDIACHAR_MAX];

int lips4v_media_selection(int width, int height);
int lips4v_packbits_encode(byte * inBuff, byte * outBuff, int Length);
int lips4v_rle_encode(byte * inBuff, byte * outBuff, int Length);
