/* Copyright (C) 2002 CANON INC.

   Ghostscript printer driver
   for Canon CPCA printer devices (LIPS IV)

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation;
   either version 2 of the License, or (at your option) any
   later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied
   warranty of MERCHANTABILITY or FITNESS FOR A
   PARTICULAR PURPOSE.  See the GNU General Public
   License for more details.

   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA  02111-1307, USA.

*/



/*$Id: cpca_mk.h $ */

/***********************************************************
 cpca param struct
***********************************************************/
typedef struct _raster_arg {
  int  ImpressVal;   /* Impression Count */
  int  Resolution;   /* Resolution */
  int  Copies;       /* Copies  */
  int  Collate;      /* Collation */
  int  PaperSize;    /* Paper Size */
  int  Bind_Dir;     /* Bind Direction */
  int  Bind_Marg;    /* Bind Margin */
  int  Duplex;       /* Plex Select */
  int  SortMode;     /* Sort Select */
  int  StapleLocate; /* Staple Location */
  int  InTrayNum;    /* Input Tray Number */
  int  OutputBin;    /* Output Bin */
  int  TonerDensity; /* Toner Density */
  int  TonerSaving;  /* Toner Saving */
  int  SpecialModeH; /* Special Mode-H */
  int  PageCount;    /* Page Count */
  int  ColorMode;    /* Color Select */
  int  StateFlg;     /* Status Flag */
  int  PaperNum;     /* Paper Index */
  unsigned char PanelMsg[256]; /* Panel Message String */
  unsigned char UserName[256];/* User Name String */
  unsigned char JobName[256]; /* Job Name String */
} RasterArg_t, *PRasterArg_t;


unsigned int cpca_JobStart(char *outBuf, PRasterArg_t arg);
unsigned int cpca_JobEnd(char *outBuf, PRasterArg_t arg, char Cancel);
unsigned int cpca_SendData (unsigned long size, char *data, char *pp, int contFlag);
#define GS_PANEL_MSG_DEFAULT    "Ghostscript"
#define BINDLOC_NOT_SPECIFIED   0
#define BINDLOC_LONG            1
#define BINDLOC_LONG2           2
#define BINDLOC_SHORT           3
#define BINDLOC_SHORT2          4

#define COLLATE_NOT_SPECIFIED   0
#define COLLATE_SPECIFIED       1

#define OUTBIN_NOT_SPECIFIED    0

#define SS_NOT_SPECIFIED        0
#define SS_SORT                 1
#define SS_STACK                2

#define STAPLE_NOT_SPECIFIED    0
#define STAPLE_LEFTTOP          1
#define STAPLE_LEFTBOTTOM       2
#define STAPLE_LEFT             3

#define MODEH_NOT_SPECIFIED     0
#define MODEH_SPECIFIED         1

#define OPT_NOT_SPECIFIED       0
#define OPT_SPECIFIED           1
