/*  config.c:  configurable command-line processing

    Copyright (C) 1999  Michael T. Babcock
	<mbabcock@tyenet.com>
	http://w3.tyenet.com/mbabcock/

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    There should be a copy in the file COPYING in the source distribution
    directory.  */

#include <string.h>

#include "config.h"

#define DEBUG 0

unsigned long SetOptions(int argc, char *argv[], char *strings[], unsigned long values[])
{
  unsigned long options=0;
  int i=0, j=0;

  for (i=1; i<argc; i++)
  {
    #if DEBUG
    printf(" -- debugging: i = %d\n", i);
    #endif
    do
    {
      #if DEBUG
      printf(" -- debugging: j = %d\n -- debugging: strings[j] = %s\n", j, strings[j]);
      printf(" -- debugging: values[j] = %d\n", values[j]);
      #endif
      if (strcasecmp(argv[i], strings[j]) == 0)
      {
        options |= values[j];  /* use logical OR to create a bitfield */
        argv[i]="";
      }
    } while (values[j++] != 0);  /* the last value must always be 0 */
  }

  return options;
}
