/* Copyright (C) 1998 Sean Gabriel <gabriel@montana.com>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#ifdef HAVE_GNOME
#include <gnome.h>
#else
#include <gtk/gtk.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <config.h>
#include <libicq.h>

#include "event.h"
#include "login.h"
#include "contactlist.h"
#include "labeledentry.h"
#include "message.h"
#include "url.h"
#include "info.h"
#include "search.h"
#include "userinfo.h"

gint timeout_id;
gint select_id;
gint blink_id;
gint connection = OFFLINE;
char config_file[100];

extern int Verbose;

extern GtkWidget* contact_list;
extern GtkWidget* status_bar;
extern GtkWidget* status_menu;

extern GdkPixmap* blank_pixmap;
extern GdkPixmap* message_pixmap;
extern GdkPixmap* gray_message_pixmap;
extern GdkPixmap* away_message_pixmap;
extern GdkPixmap* na_message_pixmap;
extern GdkPixmap* dnd_message_pixmap;
extern GdkPixmap* occ_message_pixmap;
extern GdkPixmap* url_pixmap;
extern GdkPixmap* info_pixmap;
extern GdkBitmap* mask, *blank_mask, *url_mask, *info_mask;

USER_INFO user_info;
USER_EXT_INFO user_ext_info;

unsigned long pending_search;

static int on;

enum { TYPE_MSG, TYPE_URL };

extern void ReceiveMessage(CLIENT_MESSAGE_PTR c_mesg);

#define DEBUG

/* Called every 100 milliseconds */
static gint SelectServer(gpointer data)
{
  if(connection != OFFLINE)
    ICQ_Check_Response(10000);
  return TRUE;
}


static gint KeepAlive(gpointer data)
{
  #ifdef DEBUG
/*  fprintf(stderr, "GICQ> KeepAlive\n"); */
  #endif
  if(connection == ONLINE)
    ICQ_Keep_Alive();
  return TRUE;
}


static gint Blink(gpointer data)
{
  GtkCList* clist[3];
  GList *list, *event;
  GdkPixmap* temp;
  GdkBitmap* temp_mask;
  gint m, n;

  on = !on;

  #ifdef DEBUG
/*  fprintf(stderr, "GICQ> Blink ... on=%d\n", on); */
  #endif
  g_return_val_if_fail(contact_list != NULL, -1);
  g_return_val_if_fail(IS_CONTACT_LIST(contact_list), -1);

  clist[0] = GTK_CLIST(CONTACT_LIST(contact_list)->online_list);
  clist[1] = GTK_CLIST(CONTACT_LIST(contact_list)->offline_list);
  clist[2] = GTK_CLIST(CONTACT_LIST(contact_list)->nil_list);

  for(m = 0; m < 3; m++)
    for(n = 0, list = clist[m]->row_list; list; n++, list = list->next)
      if(GTK_CLIST_ROW(list)->data && ((CLInfoPtr)(GTK_CLIST_ROW(list)->data))->events != NULL)
      {
        event = g_list_first(((CLInfoPtr)(GTK_CLIST_ROW(list)->data))->events)->data;

        if(on)
        {
          if(IS_MESSAGE(event))
            gtk_clist_set_pixmap(clist[m], n, 0, message_pixmap, mask);
          else if(IS_URL(event))
            gtk_clist_set_pixmap(clist[m], n, 0, url_pixmap, url_mask);
          else if(IS_INFO(event) || IS_INFO_BOX(event))
            gtk_clist_set_pixmap(clist[m], n, 0, info_pixmap, info_mask);
        }
        else
        {
          gtk_clist_set_pixmap(clist[m], n, 0, blank_pixmap, blank_mask);
        }
      }
      else
      {
        switch(((CLInfoPtr)(GTK_CLIST_ROW(list)->data))->status)
        {
        case STATUS_AWAY:
          gtk_clist_get_pixmap(clist[m], n, 0, &temp, &temp_mask);
          if(temp != away_message_pixmap)
            gtk_clist_set_pixmap(clist[m], n, 0, away_message_pixmap, mask);
          break;

        case STATUS_NA:
          gtk_clist_get_pixmap(clist[m], n, 0, &temp, &temp_mask);
          if(temp != na_message_pixmap)
            gtk_clist_set_pixmap(clist[m], n, 0, na_message_pixmap, mask);
          break;

        case STATUS_DND:
          gtk_clist_get_pixmap(clist[m], n, 0, &temp, &temp_mask);
          if(temp != dnd_message_pixmap)
            gtk_clist_set_pixmap(clist[m], n, 0, dnd_message_pixmap, mask);
          break;
    
        case STATUS_OCCUPIED:
          gtk_clist_get_pixmap(clist[m], n, 0, &temp, &temp_mask);
          if(temp != occ_message_pixmap)
            gtk_clist_set_pixmap(clist[m], n, 0, occ_message_pixmap, mask);
          break;

        default: 
          gtk_clist_get_pixmap(clist[m], n, 0, &temp, &temp_mask);
          if(temp != gray_message_pixmap)
            gtk_clist_set_pixmap(clist[m], n, 0, gray_message_pixmap, mask);
        }
      }

  return TRUE;
}


static void EventLogin(void* data)
{
  connection = ONLINE;
  pending_search = 0;
}

#define SRV_FORCE_DISCONNECT 0x0028
#define SRV_MULTI_PACKET   0x0212
#define SRV_BAD_PASS    0x6400
#define SRV_GO_AWAY        0x00F0

static void EventDisconnect(void* data)
{
  #ifdef DEBUG
  fprintf(stderr, "GICQ> EventDisconnect -- %04X --", (int)data);
  #endif

  if(connection == CONNECTING)
  {
    fprintf(stderr, "Reconnecting.\n");
    ChangeStatus(0);
    return;
  }

  switch ((int)data)
  {
    case SRV_FORCE_DISCONNECT: ChangeStatus(0); break;
    case SRV_GO_AWAY: ChangeStatus((void *)5); break;
    default: ChangeStatus((void *)5); break;
  }
  fprintf(stderr, "\n");
}


static void EventMessage(void* data)
{
  GtkWidget* msgbox;
  CLIENT_MESSAGE_PTR c_mesg;
  char nick[20], uin[20], away_msg[30], *title;
  CLInfoPtr clinfo;
  guint status_context;
  status_context=gtk_statusbar_get_context_id(GTK_STATUSBAR(status_bar),
    "event_message");
  gtk_statusbar_push(GTK_STATUSBAR(status_bar), status_context,
    "Receiving ...");

  c_mesg = (CLIENT_MESSAGE_PTR)data;

  if (Verbose & ICQ_VERB_INFO)
    printf("Message type: 0x%X\n", c_mesg->type);

  sprintf(uin, "%d", c_mesg->uin);
  sprintf(nick, "%s", contact_list_get_nickname(CONTACT_LIST(contact_list), c_mesg->uin));
  clinfo = (CLInfoPtr)contact_list_find_data_from_uin(CONTACT_LIST(contact_list), c_mesg->uin);
  
  gtk_statusbar_pop(GTK_STATUSBAR(status_bar), status_context);

  if(!clinfo)
  {
    if(Verbose & ICQ_VERB_ERR) printf("err!: Unknown UIN\n");
    contact_list_update_user(CONTACT_LIST(contact_list), c_mesg->uin, nick, STATUS_NOT_IN_LIST);
    clinfo = (CLInfoPtr)contact_list_find_data_from_uin(CONTACT_LIST(contact_list), c_mesg->uin);
  }

  if(!strcmp(nick, "Unknown"))
  {
    contact_list_update_user(CONTACT_LIST(contact_list),
      c_mesg->uin, uin, STATUS_NOT_IN_LIST);
  }

  if(c_mesg->type == URL_MESS)
  {
    msgbox = url_new(RECEIVE_URL, -1, NULL);
    labeled_entry_set_text(LABELED_ENTRY(URL(msgbox)->uin), uin);
    labeled_entry_set_text(LABELED_ENTRY(URL(msgbox)->nick), nick);
                gtk_widget_realize(GTK_WIDGET(URL(msgbox)->message));
    gtk_entry_set_text(GTK_ENTRY(URL(msgbox)->url), c_mesg->url);
    gtk_text_insert(GTK_TEXT(URL(msgbox)->message), NULL, 
      NULL, NULL, c_mesg->msg, -1);
  }
  else if(c_mesg->type == AWAY_MESS)
  {
    sprintf(away_msg, "%s is currently ", nick);
    
    if(clinfo->status == STATUS_AWAY)
    {
      strcat(away_msg, "away.");
      title = "User is Away";
    }
      
    if(clinfo->status == STATUS_NA)
    {
      strcat(away_msg, "not available.");
      title = "User is Not Available";
    }
      
    if(clinfo->status == STATUS_OCCUPIED)
    {
      strcat(away_msg, "occupied.");
      title = "User is Occupied";
    }
    
    if(clinfo->status == STATUS_DND)
    {
      strcat(away_msg, "requesting not to be disturbed.");
      title = "User is DND";
    }
    
    msgbox = info_new(title, away_msg, c_mesg->msg);
  }
  else 
  {
    msgbox = message_new(RECEIVE_MESSAGE, -1, NULL);
    labeled_entry_set_text(LABELED_ENTRY(MESSAGE(msgbox)->uin), uin);
    labeled_entry_set_text(LABELED_ENTRY(MESSAGE(msgbox)->nick), nick);
                gtk_widget_realize(GTK_WIDGET(MESSAGE(msgbox)->message));
    gtk_text_insert(GTK_TEXT(MESSAGE(msgbox)->message), NULL, 
      NULL, NULL, c_mesg->msg, -1);
  }

  clinfo->events = g_list_append((GList*)(clinfo->events), 
    (gpointer)msgbox);
}


static void EventChangeStatus(void* data)
{
  USER_UPDATE_PTR user_update;
  user_update = (USER_UPDATE_PTR)data;

  contact_list_update_user(CONTACT_LIST(contact_list), 
    user_update->uin, user_update->nick, user_update->status);
}


static void EventSearchResults(void* data)
{
  GtkWidget* sr_box;
  
  /* for some reason this gives me a warning if I don't cast it */
  sr_box = GTK_WIDGET(search_results_new(data));
  gtk_widget_show(sr_box);
}


static void EventInfo(void* data)
{
  SEARCH_RESULT sr;
  user_info = *(USER_INFO_PTR)data;

  if(user_info.uin != pending_search)
  {
    ICQ_Get_Ext_Info(user_info.uin);
    return;
  }

  sr.uin = user_info.uin;
  strcpy(sr.nick, user_info.nick);
  strcpy(sr.first, user_info.first);
  strcpy(sr.last, user_info.last);
  strcpy(sr.email, user_info.email);
  sr.auth_required = user_info.auth_required;
  sr.next = NULL;
  
  EventSearchResults(&sr);
  
  pending_search = 0;
}


static void EventExtInfo(void* data)
{
  GtkWidget* infobox;
  char uin[20];
  CLInfoPtr clinfo;
  
  user_ext_info = *(USER_EXT_INFO_PTR)data;

  sprintf(uin, "%d", user_info.uin);

  /* for some reason this gives me a warning if I don't cast it */
  infobox = GTK_WIDGET(info_box_new());

  labeled_entry_set_text(LABELED_ENTRY(INFO_BOX(infobox)->nick), user_info.nick);
  labeled_entry_set_text(LABELED_ENTRY(INFO_BOX(infobox)->uin), uin);
  labeled_entry_set_text(LABELED_ENTRY(INFO_BOX(infobox)->first), user_info.first);
  labeled_entry_set_text(LABELED_ENTRY(INFO_BOX(infobox)->last), user_info.last);
  labeled_entry_set_text(LABELED_ENTRY(INFO_BOX(infobox)->email), user_info.email);
  labeled_entry_set_text(LABELED_ENTRY(INFO_BOX(infobox)->age), user_ext_info.age);
  labeled_entry_set_text(LABELED_ENTRY(INFO_BOX(infobox)->sex), user_ext_info.sex);
  labeled_entry_set_text(LABELED_ENTRY(INFO_BOX(infobox)->homepage), user_ext_info.url);
  
  labeled_entry_set_text(LABELED_ENTRY(INFO_BOX(infobox)->city), user_ext_info.city);
  labeled_entry_set_text(LABELED_ENTRY(INFO_BOX(infobox)->state), user_ext_info.state);
  labeled_entry_set_text(LABELED_ENTRY(INFO_BOX(infobox)->country), user_ext_info.country);
  labeled_entry_set_text(LABELED_ENTRY(INFO_BOX(infobox)->phone), user_ext_info.phone);
  
  gtk_widget_realize(GTK_WIDGET(INFO_BOX(infobox)->info));

  gtk_text_insert(GTK_TEXT(INFO_BOX(infobox)->info), NULL, NULL, NULL, user_ext_info.about, -1);
  
  clinfo = (CLInfoPtr)contact_list_find_data_from_uin(CONTACT_LIST(contact_list), user_info.uin);
  if(clinfo) clinfo->events = g_list_append((GList*)(clinfo->events), (gpointer)infobox);
}


void RegisterCallbacks()
{
  ICQ_Register_Callback(EVENT_LOGIN, EventLogin);
  ICQ_Register_Callback(EVENT_DISCONNECT, EventDisconnect);
  ICQ_Register_Callback(EVENT_MESSAGE, EventMessage);
  ICQ_Register_Callback(EVENT_ONLINE, EventChangeStatus);
  ICQ_Register_Callback(EVENT_OFFLINE, EventChangeStatus);
  ICQ_Register_Callback(EVENT_STATUS_UPDATE, EventChangeStatus);
  ICQ_Register_Callback(EVENT_SEARCH_RESULTS, EventSearchResults);
  ICQ_Register_Callback(EVENT_INFO, EventInfo);
  ICQ_Register_Callback(EVENT_EXT_INFO, EventExtInfo);
}


void AddTimers()
{
  on = 0;
  select_id = gtk_timeout_add(100, SelectServer, NULL);
  timeout_id = gtk_timeout_add((guint32)60000, KeepAlive, NULL);
  blink_id = gtk_timeout_add(500, Blink, NULL);
}


void RemoveTimers()
{
  gtk_timeout_remove(select_id);
  gtk_timeout_remove(timeout_id);
  gtk_timeout_remove(blink_id);
}


void Shutdown()
{
  if(connection == ONLINE) ICQ_Disconnect();
  gtk_main_quit();
}


gint ChangeStatus(gpointer data)
{
  GtkWidget* login_window;
  int fd, error, cindex;
  guint status_context;

  if(connection == OFFLINE && (int)data < 5)
  {
    connection = CONNECTING;
    
    if(UIN == 0)
    {
      login_window = login_new();
      gtk_widget_show(login_window);
    }
    else
    {
      AddTimers();
    }
  }
  else if(connection != OFFLINE && (int)data == 5)
  {
    ICQ_Disconnect();
    RemoveTimers();

/* Shouldn't we just make everyone offline and keep the list visible?
    gtk_clist_clear(GTK_CLIST(CONTACT_LIST(contact_list)->online_list));
    gtk_clist_clear(GTK_CLIST(CONTACT_LIST(contact_list)->offline_list));
    gtk_clist_clear(GTK_CLIST(CONTACT_LIST(contact_list)->nil_list));
*/
    for(cindex = 0; cindex < Num_Contacts; cindex++)
      contact_list_update_user(CONTACT_LIST(contact_list),
        Contacts[cindex].uin, Contacts[cindex].nick, STATUS_OFFLINE);

    gtk_widget_hide(CONTACT_LIST(contact_list)->nil_toggle);
    gtk_widget_hide(CONTACT_LIST(contact_list)->nil_scroll_win);
    connection = OFFLINE;
    gtk_menu_set_active(GTK_MENU(status_menu), (int)data);
    return TRUE;
  }
  
  switch((int)data)
  {
    case 0: ICQ_Change_Status(STATUS_ONLINE); break;
    case 1: ICQ_Change_Status(STATUS_AWAY); break;
    case 2: ICQ_Change_Status(STATUS_NA); break;
    case 3: ICQ_Change_Status(STATUS_OCCUPIED); break;
    case 4: ICQ_Change_Status(STATUS_DND); break;
  }

  return TRUE;
}



void StartSearch()
{
  GtkWidget* srchbox;

  srchbox = search_box_new();
  gtk_widget_show(srchbox);
}
