/* Copyright (C) 1998 Sean Gabriel <gabriel@montana.com>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#include <gtk/gtk.h>
#include "info.h"
#include "labeledentry.h"


static void info_init(Info* i)
{
  GtkWidget* vbox, *info_hbox;
  GtkWidget* confirm_area;

  vbox = gtk_vbox_new(FALSE, 0);
  gtk_container_border_width(GTK_CONTAINER(vbox), 10);

  i->label = gtk_label_new("");

  info_hbox = gtk_hbox_new(FALSE, 0);
  i->info = gtk_text_new(NULL, NULL);
  gtk_widget_set_usize(i->info, 250, 75);
  i->vscrollbar = gtk_vscrollbar_new(GTK_TEXT(i->info)->vadj);
  gtk_box_pack_start(GTK_BOX(info_hbox), i->info, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(info_hbox), i->vscrollbar, FALSE, FALSE, 0);
  gtk_text_set_editable(GTK_TEXT(i->info), TRUE);
  gtk_text_set_word_wrap(GTK_TEXT(i->info), TRUE);

  confirm_area = gtk_hbutton_box_new();
  gtk_button_box_set_layout(GTK_BUTTON_BOX(confirm_area), GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing(GTK_BUTTON_BOX(confirm_area), 5);
  gtk_box_pack_end (GTK_BOX(vbox), confirm_area, FALSE, FALSE, 0);
  gtk_widget_show(confirm_area);
  
  i->close = gtk_button_new_with_label("Close");
  GTK_WIDGET_SET_FLAGS(i->close, GTK_CAN_DEFAULT);
  gtk_box_pack_start(GTK_BOX(confirm_area), i->close, TRUE, TRUE, 0);

  gtk_box_pack_start(GTK_BOX(vbox), i->label, TRUE, TRUE, 10);
  gtk_box_pack_start(GTK_BOX(vbox), info_hbox, TRUE, TRUE, 10);
  gtk_container_add(GTK_CONTAINER(i), vbox);

  gtk_signal_connect_object(GTK_OBJECT(i->close), "clicked",
    GTK_SIGNAL_FUNC(gtk_widget_destroy), (gpointer)i);

  gtk_widget_show(i->label);
  gtk_widget_show(i->info);
  gtk_widget_show(i->vscrollbar);
  gtk_widget_show(i->close);

  gtk_widget_show(info_hbox);
  gtk_widget_show(vbox);

  gtk_widget_grab_default(i->close);
}


guint info_get_type()
{
  static guint i_type = 0;
  
  if(!i_type)
  {
    GtkTypeInfo i_info =
    {
      "Info",
      sizeof(Info),
      sizeof(InfoClass),
      (GtkClassInitFunc)NULL,
      (GtkObjectInitFunc)info_init,
      (GtkArgSetFunc)NULL,
      (GtkArgGetFunc)NULL,
    };

    i_type = gtk_type_unique(gtk_window_get_type(), &i_info);
  }

  return i_type;
}


GtkWidget* info_new(char* title, char* label, char* info)
{
  GtkWidget* I;
  char str[32];
  I = gtk_type_new(info_get_type());

  gtk_window_set_title(GTK_WINDOW(I), title);
  gtk_label_set(GTK_LABEL(INFO(I)->label), label);

  if(info != NULL)
  {
    gtk_widget_realize(GTK_WIDGET(INFO(I)->info));
    gtk_text_insert(GTK_TEXT(INFO(I)->info), NULL,
      NULL, NULL, info, -1);

    gtk_widget_show(INFO(I)->info);
    gtk_widget_show(INFO(I)->vscrollbar);
    gtk_window_set_focus(GTK_WINDOW(I), INFO(I)->info);
  }
  else
  {
    gtk_window_set_focus(GTK_WINDOW(I), INFO(I)->close);
  }

  return I;
}
