/* Copyright (C) 1998 Sean Gabriel <gabriel@montana.com>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#include <gtk/gtk.h>
#include "labeledentry.h"

static void labeled_entry_init(LabeledEntry* le)
{
  le->align = gtk_alignment_new(0.0, 0.5, 0.0, 0.0);
  le->label = gtk_label_new("");
  le->entry = gtk_entry_new();

  gtk_container_add(GTK_CONTAINER(le->align), le->label);
  gtk_box_pack_start(GTK_BOX(le), le->align, FALSE, FALSE, 2);
  gtk_box_pack_start(GTK_BOX(le), le->entry, TRUE, TRUE, 4);

  gtk_widget_show(le->label);
  gtk_widget_show(le->entry);
  gtk_widget_show(le->align);
}


guint labeled_entry_get_type()
{
         static guint le_type = 0;
  
         if(!le_type)
  {
    GtkTypeInfo le_info =
    {
      "LabeledEntry",
      sizeof(LabeledEntry),
      sizeof(LabeledEntryClass),
      (GtkClassInitFunc)NULL,
      (GtkObjectInitFunc)labeled_entry_init,
      (GtkArgSetFunc)NULL,
      (GtkArgGetFunc)NULL,
    };

    le_type = gtk_type_unique(gtk_hbox_get_type(), &le_info);
  }

  return le_type;
}


GtkWidget* labeled_entry_new(const gchar* label)
{
  GtkWidget* le;
  le = gtk_type_new(labeled_entry_get_type());
  labeled_entry_set_label(LABELED_ENTRY(le), label);
  return le;
}


void labeled_entry_set_label(LabeledEntry* le, const gchar* label)
{
  gtk_label_set(GTK_LABEL(le->label), label);
}


void labeled_entry_set_text(LabeledEntry* le, const gchar* text)
{
  gtk_entry_set_text(GTK_ENTRY(le->entry), text);
}


gchar* labeled_entry_get_text(LabeledEntry* le)
{
  return gtk_entry_get_text(GTK_ENTRY(le->entry));
}


void labeled_entry_set_editable(LabeledEntry* le, gboolean editable)
{
  gtk_entry_set_editable(GTK_ENTRY(le->entry), editable);
}


void labeled_entry_set_visibility(LabeledEntry* le, gboolean visible)
{
  gtk_entry_set_visibility(GTK_ENTRY(le->entry), visible);
}


void labeled_entry_set_max_length(LabeledEntry* le, guint16 max)
{
  gtk_entry_set_max_length(GTK_ENTRY(le->entry), max);
}


void labeled_entry_set_label_usize(LabeledEntry* le, gint width, gint height)
{
  gtk_widget_set_usize(le->align, width, height);
}


void labeled_entry_set_text_usize(LabeledEntry* le, gint width, gint height)
{
  gtk_widget_set_usize(le->entry, width, height);
}



















