/* Copyright (C) 1998 Sean Gabriel <gabriel@montana.com>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#ifndef __LABELEDENTRY_H__
#define __LABELEDENTRY_H__

#include <gdk/gdk.h>
#include <gtk/gtkhbox.h>
#include <gtk/gtklabel.h>
#include <gtk/gtkentry.h>

#ifdef __cplusplus
extern "C" {
#endif

#define LABELED_ENTRY(obj)          GTK_CHECK_CAST(obj, labeled_entry_get_type(), LabeledEntry)
#define LABELED_ENTRY_CLASS(klass)  GTK_CHECK_CLASS_CAST(klass, labeled_entry_get_type(), LabeledEntryClass)
#define IS_LABELED_ENTRY(obj)       GTK_CHECK_TYPE(obj, labeled_entry_get_type())

typedef struct _LabeledEntry LabeledEntry;
typedef struct _LabeledEntryClass LabeledEntryClass;

struct _LabeledEntry
{
  GtkHBox hbox;

  GtkWidget* align;
  GtkWidget* label;
  GtkWidget* entry;
};

struct _LabeledEntryClass
{
  GtkHBoxClass parent_class;
};


guint labeled_entry_get_type(void);
GtkWidget* labeled_entry_new(const gchar* label);
void labeled_entry_set_label(LabeledEntry* le, const gchar* label);
void labeled_entry_set_text(LabeledEntry* le, const gchar* text);
gchar* labeled_entry_get_text(LabeledEntry* le);
void labeled_entry_set_editable(LabeledEntry* le, gboolean editable);
void labeled_entry_set_visibility(LabeledEntry* le, gboolean visible);
void labeled_entry_set_max_length(LabeledEntry* le, guint16 max);
void labeled_entry_set_label_usize(LabeledEntry* le, gint width, gint height);
void labeled_entry_set_text_usize(LabeledEntry* le, gint width, gint height);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __LABELEDENTRY_H__ */
