/* Copyright (C) 1998 Sean Gabriel <gabriel@montana.com>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#ifndef __LOGIN_H__
#define __LOGIN_H__

#include <gdk/gdk.h>
#include <gtk/gtkhbox.h>
#include <gtk/gtklabel.h>
#include <gtk/gtkentry.h>

#ifdef __cplusplus
extern "C" {
#endif

#define LOGIN(obj)          GTK_CHECK_CAST(obj, login_get_type(), Login)
#define LOGIN_CLASS(klass)  GTK_CHECK_CLASS_CAST(klass, login_get_type(), Login)
#define IS_LOGIN(obj)       GTK_CHECK_TYPE(obj, login_get_type())

typedef struct _Login Login;
typedef struct _LoginClass LoginClass;

struct _Login
{
  GtkWindow window;

  GtkWidget* uin;
  GtkWidget* passwd;
};

struct _LoginClass
{
  GtkWindowClass parent_class;
};


guint login_get_type(void);
GtkWidget* login_new(void);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __LOGIN_H__ */
