/* Copyright (C) 1998 Sean Gabriel <gabriel@montana.com>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#ifndef __MESSAGE_H__
#define __MESSAGE_H__

#include <gdk/gdk.h>

#ifdef __cplusplus
extern "C" {
#endif

#define MESSAGE(obj)        GTK_CHECK_CAST(obj, message_get_type(), Message)
#define MESSAGE_CLASS(klass)  GTK_CHECK_CLASS_CAST(klass, message_get_type(), Message)
#define IS_MESSAGE(obj)        GTK_CHECK_TYPE(obj, message_get_type())

typedef struct _Message Message;
typedef struct _MessageClass MessageClass;

struct _Message
{
  GtkWindow window;

  GtkWidget* frame;
  GtkWidget* uin, *nick, *email;
  GtkWidget* message;
  GtkWidget* action, *close;
};

struct _MessageClass
{
  GtkWindowClass parent_class;
};


enum { SEND_MESSAGE, RECEIVE_MESSAGE };

guint message_get_type(void);
GtkWidget* message_new(int type, unsigned long uin, char* nick);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __MESSAGE_H__ */
