/* Copyright (C) 1998 Sean Gabriel <gabriel@montana.com>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#ifndef __RENAME_H__
#define __RENAME_H__

#include <gdk/gdk.h>
#include <gtk/gtkvbox.h>
#include <gtk/gtkclist.h>

#ifdef __cplusplus
extern "C" {
#endif

#define RENAME_BOX(obj)          GTK_CHECK_CAST(obj, rename_box_get_type(), RenameBox)
#define RENAME_BOX_CLASS(klass)  GTK_CHECK_CLASS_CAST(klass, rename_box_get_type(), RenameBoxClass)
#define IS_RENAME_BOX(obj)       GTK_CHECK_TYPE(obj, rename_box_get_type())

typedef struct _RenameBox RenameBox;
typedef struct _RenameBoxClass RenameBoxClass;

struct _RenameBox
{
  GtkWindow window;

  GtkWidget* label;
  GtkWidget* entry;
  GtkWidget* ok, *cancel;
  
  unsigned long uin;
};

struct _RenameBoxClass
{
  GtkWindowClass parent_class;
};


guint rename_box_get_type();
GtkWidget* rename_box_new(unsigned long uin, gchar* name);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __RENAME_H__ */
