/* Copyright (C) 1998 Sean Gabriel <gabriel@montana.com>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#include <gtk/gtk.h>
#include <libicq.h>

#include "search.h"
#include "labeledentry.h"

extern unsigned long pending_search;

void PerformSearch(GtkWidget* data)
{
  char* str;
  unsigned long uin;
  
  str = labeled_entry_get_text(LABELED_ENTRY(SEARCH_BOX(data)->uin));
  uin = atol(str);
  
  if(uin)
  {
    pending_search = uin;
    ICQ_Get_Info(uin);
  }
  else
  {    
    ICQ_Search(labeled_entry_get_text(LABELED_ENTRY(SEARCH_BOX(data)->email)),
      labeled_entry_get_text(LABELED_ENTRY(SEARCH_BOX(data)->nick)),
      labeled_entry_get_text(LABELED_ENTRY(SEARCH_BOX(data)->first)),
      labeled_entry_get_text(LABELED_ENTRY(SEARCH_BOX(data)->last)));
  }

  gtk_widget_destroy(GTK_WIDGET(data));
}


static void search_box_init(SearchBox* sb)
{
  GtkWidget* notebook;
  GtkWidget* hbox, *email_page, *details_page, *uin_page;
  GtkWidget* align, *button_box;
  GtkWidget* email_label, *details_label, *uin_label;

  gtk_window_set_title(GTK_WINDOW(sb), "ICQ User Search");

  hbox = gtk_hbox_new(FALSE, 15);
  gtk_container_border_width(GTK_CONTAINER(hbox), 10);

  notebook = gtk_notebook_new();

  email_page = gtk_vbox_new(FALSE, 4);
  gtk_container_border_width(GTK_CONTAINER(email_page), 5);

  details_page = gtk_vbox_new(FALSE, 4);
  gtk_container_border_width(GTK_CONTAINER(details_page), 5);

  uin_page = gtk_vbox_new(FALSE, 4);
  gtk_container_border_width(GTK_CONTAINER(uin_page), 5);

  align = gtk_alignment_new(0.0, 0.5, 0.0, 0.0);
  email_label = gtk_label_new("Search by e-mail address:");
  gtk_container_add(GTK_CONTAINER(align), email_label);
  sb->email = labeled_entry_new("E-mail: ");
  gtk_box_pack_start(GTK_BOX(email_page), align, FALSE, FALSE, 5);
  gtk_box_pack_start(GTK_BOX(email_page), sb->email, FALSE, FALSE, 0);
  gtk_widget_show(align);

  align = gtk_alignment_new(0.0, 0.5, 0.0, 0.0);
  details_label = gtk_label_new("Search by details:");
  gtk_container_add(GTK_CONTAINER(align), details_label);
  sb->nick = labeled_entry_new("Nickname: ");
  gtk_widget_set_usize(LABELED_ENTRY(sb->nick)->label, 65, (gint)NULL);
  sb->first = labeled_entry_new("First name: ");
  gtk_widget_set_usize(LABELED_ENTRY(sb->first)->label, 65, (gint)NULL);
  sb->last = labeled_entry_new("Last name: ");
  gtk_widget_set_usize(LABELED_ENTRY(sb->last)->label, 65, (gint)NULL);
  gtk_box_pack_start(GTK_BOX(details_page), align, FALSE, FALSE, 5);
  gtk_box_pack_start(GTK_BOX(details_page), sb->nick, FALSE, FALSE, 0);
  gtk_box_pack_start(GTK_BOX(details_page), sb->first, FALSE, FALSE, 0);
  gtk_box_pack_start(GTK_BOX(details_page), sb->last, FALSE, FALSE, 0);
  gtk_widget_show(align);

  align = gtk_alignment_new(0.0, 0.5, 0.0, 0.0);
  uin_label = gtk_label_new("Search by UIN:");
  gtk_container_add(GTK_CONTAINER(align), uin_label);
  sb->uin = labeled_entry_new("UIN: ");
  gtk_box_pack_start(GTK_BOX(uin_page), align, FALSE, FALSE, 5);
  gtk_box_pack_start(GTK_BOX(uin_page), sb->uin, FALSE, FALSE, 0);
  gtk_widget_show(align);

  gtk_box_pack_start(GTK_BOX(hbox), notebook, TRUE, TRUE, 0);

  button_box = gtk_vbutton_box_new();
  gtk_button_box_set_layout(GTK_BUTTON_BOX(button_box), GTK_BUTTONBOX_START);
  gtk_button_box_set_spacing(GTK_BUTTON_BOX(button_box), 5);
  gtk_box_pack_end(GTK_BOX(hbox), button_box, FALSE, FALSE, 0);
  gtk_widget_show(button_box);

  sb->search = gtk_button_new_with_label("Search");
  GTK_WIDGET_SET_FLAGS(sb->search, GTK_CAN_DEFAULT);
  gtk_box_pack_start(GTK_BOX(button_box), sb->search, FALSE, FALSE, 0);
  
  gtk_signal_connect_object(GTK_OBJECT(sb->search), "clicked",
    GTK_SIGNAL_FUNC(PerformSearch), GTK_OBJECT(sb));

  sb->stop = gtk_button_new_with_label("Stop");
  GTK_WIDGET_SET_FLAGS(sb->stop, GTK_CAN_DEFAULT);
  gtk_box_pack_start(GTK_BOX(button_box), sb->stop, FALSE, FALSE, 0);

  sb->cancel = gtk_button_new_with_label("Cancel");
  GTK_WIDGET_SET_FLAGS(sb->cancel, GTK_CAN_DEFAULT);
  gtk_box_pack_start(GTK_BOX(button_box), sb->cancel, FALSE, FALSE, 0);
  
  gtk_signal_connect_object(GTK_OBJECT(sb->cancel), "clicked",
    GTK_SIGNAL_FUNC(gtk_widget_destroy), (gpointer)sb);


  gtk_notebook_append_page(GTK_NOTEBOOK(notebook), email_page, gtk_label_new(" E-mail "));
  gtk_notebook_append_page(GTK_NOTEBOOK(notebook), details_page, gtk_label_new(" Details "));
  gtk_notebook_append_page(GTK_NOTEBOOK(notebook), uin_page, gtk_label_new(" UIN "));

  gtk_container_add(GTK_CONTAINER(sb), hbox);

  gtk_widget_show(email_label);
  gtk_widget_show(sb->email);
  gtk_widget_show(email_page);

  gtk_widget_show(details_label);
  gtk_widget_show(sb->nick);
  gtk_widget_show(sb->first);
  gtk_widget_show(sb->last);
  gtk_widget_show(details_page);

  gtk_widget_show(uin_label);
  gtk_widget_show(sb->uin);
  gtk_widget_show(uin_page);

  gtk_widget_show(hbox);
  gtk_widget_show(notebook);

  gtk_widget_show(sb->search);
  gtk_widget_show(sb->stop);
  gtk_widget_show(sb->cancel);

  gtk_widget_grab_default(sb->search);
}


guint search_box_get_type()
{
         static guint sb_type = 0;
  
         if(!sb_type)
  {
    GtkTypeInfo sb_info =
    {
      "SearchBox",
      sizeof(SearchBox),
      sizeof(SearchBoxClass),
      (GtkClassInitFunc)NULL,
      (GtkObjectInitFunc)search_box_init,
      (GtkArgSetFunc)NULL,
      (GtkArgGetFunc)NULL,
    };

    sb_type = gtk_type_unique(gtk_window_get_type(), &sb_info);
  }

  return sb_type;
}


GtkWidget* search_box_new()
{
  GtkWidget* SB;
  SB = gtk_type_new(search_box_get_type());
  return SB;
}

