/* Copyright (C) 1998 Sean Gabriel <gabriel@montana.com>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#include <gtk/gtk.h>
#include <libicq.h>

#include "search_results.h"
#include "contactlist.h"

extern GtkWidget* contact_list;


void SearchResultsAdd(GtkWidget* data)
{
  GtkCList* list;
  int row;
  gchar *uin_str, *nick;
  unsigned long uin;
  
  list = GTK_CLIST(SEARCH_RESULTS(data)->results_list);
  if(list->selection == NULL) return;

  row = (int)(list->selection->data);
  
  gtk_clist_get_text(list, row, 0, &uin_str);
  gtk_clist_get_text(list, row, 1, &nick);
  uin = atol(uin_str);
     
  contact_list_update_user(CONTACT_LIST(contact_list), uin, nick, STATUS_OFFLINE);

  ICQ_Add_User(uin, nick);
  gtk_widget_destroy(GTK_WIDGET(data));
}


static void search_results_init(SearchResults* sr)
{
  GtkWidget* vbox, *label, *button_box;
  gchar* titles[] = { "UIN", "Nick", "Name", "E-Mail", "Authorization" };
  
  gtk_window_set_title(GTK_WINDOW(sr), "Search Results");

  vbox = gtk_vbox_new(FALSE, 15);
  gtk_container_border_width(GTK_CONTAINER(vbox), 10);

  label = gtk_label_new("Your search of the ICQ users database returned the following results:");
  gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, FALSE, 0);

  sr->results_list = gtk_clist_new_with_titles(5, titles);
  gtk_clist_set_column_width(GTK_CLIST(sr->results_list), 0, 50);
  gtk_clist_set_column_width(GTK_CLIST(sr->results_list), 1, 50);
  gtk_clist_set_column_width(GTK_CLIST(sr->results_list), 2, 75);
  gtk_clist_set_column_width(GTK_CLIST(sr->results_list), 3, 100);
  gtk_clist_set_column_width(GTK_CLIST(sr->results_list), 4, 50);
  
  sr->results_scroll_win = gtk_scrolled_window_new(NULL, NULL);

  gtk_container_add(GTK_CONTAINER(sr->results_scroll_win), sr->results_list);

  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(sr->results_scroll_win),
    GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  gtk_widget_set_usize(sr->results_scroll_win, (gint)NULL, 120);
  gtk_box_pack_start(GTK_BOX(vbox), sr->results_scroll_win, TRUE, TRUE, 0);
  
  button_box = gtk_hbutton_box_new();
  gtk_button_box_set_layout(GTK_BUTTON_BOX(button_box), GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing(GTK_BUTTON_BOX(button_box), 5);
  gtk_box_pack_start(GTK_BOX(vbox), button_box, FALSE, FALSE, 0);
  gtk_widget_show(button_box);

  sr->add = gtk_button_new_with_label("Add");
  GTK_WIDGET_SET_FLAGS(sr->add, GTK_CAN_DEFAULT);
  gtk_box_pack_start(GTK_BOX(button_box), sr->add, FALSE, FALSE, 0);
  
  gtk_signal_connect_object(GTK_OBJECT(sr->add), "clicked",
    GTK_SIGNAL_FUNC(SearchResultsAdd), GTK_OBJECT(sr));

  sr->close = gtk_button_new_with_label("Close");
  GTK_WIDGET_SET_FLAGS(sr->close, GTK_CAN_DEFAULT);
  gtk_box_pack_start(GTK_BOX(button_box), sr->close, FALSE, FALSE, 0);
  
  gtk_signal_connect_object(GTK_OBJECT(sr->close), "clicked",
    GTK_SIGNAL_FUNC(gtk_widget_destroy), (gpointer)sr);

  gtk_container_add(GTK_CONTAINER(sr), vbox);

  gtk_widget_show(label);
  gtk_widget_show(sr->results_list);
  gtk_widget_show(sr->results_scroll_win);
  gtk_widget_show(sr->add);
  gtk_widget_show(sr->close);
  gtk_widget_show(button_box);
  gtk_widget_show(vbox);

  gtk_widget_grab_default(sr->add);
}


guint search_results_get_type()
{
         static guint sr_type = 0;
  
         if(!sr_type)
  {
    GtkTypeInfo sr_info =
    {
      "SearchResults",
      sizeof(SearchResults),
      sizeof(SearchResultsClass),
      (GtkClassInitFunc)NULL,
      (GtkObjectInitFunc)search_results_init,
      (GtkArgSetFunc)NULL,
      (GtkArgGetFunc)NULL,
    };

    sr_type = gtk_type_unique(gtk_window_get_type(), &sr_info);
  }

  return sr_type;
}


GtkWidget* search_results_new(void* sr)
{
  GtkWidget* SR;
  SEARCH_RESULT_PTR current_search_result;
  gchar* field[6], uin[20], name[100];
  int row;
  
  SR = gtk_type_new(search_results_get_type());

  current_search_result = (SEARCH_RESULT_PTR)sr;
  while(current_search_result != NULL)
  {
    sprintf(uin, "%ld", current_search_result->uin);
    sprintf(name, "%s %s", current_search_result->first, current_search_result->last);

    field[0] = (gchar*)uin;
    field[1] = current_search_result->nick;
    field[2] = (gchar*)name;
    field[3] = current_search_result->email;
    field[4] = (current_search_result->auth_required) ? "Yes" : "No";
    
    row = gtk_clist_append(GTK_CLIST(SEARCH_RESULTS(SR)->results_list), field);
    gtk_clist_set_row_data(GTK_CLIST(SEARCH_RESULTS(SR)->results_list), 
      row, (gpointer)0);
    
    current_search_result = current_search_result->next;
  }
  
  return SR;
}
