/* Copyright (C) 1998 Sean Gabriel <gabriel@montana.com>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#ifndef __URL_H__
#define __URL_H__

#include <gdk/gdk.h>

#ifdef __cplusplus
extern "C" {
#endif

#define URL(obj)        GTK_CHECK_CAST(obj, url_get_type(), Url)
#define URL_CLASS(klass)  GTK_CHECK_CLASS_CAST(klass, url_get_type(), Url)
#define IS_URL(obj)        GTK_CHECK_TYPE(obj, url_get_type())

typedef struct _Url Url;
typedef struct _UrlClass UrlClass;

struct _Url
{
  GtkWindow window;

  GtkWidget* frame;
  GtkWidget* uin, *nick, *email;
  GtkWidget* url, *message;
  GtkWidget* action, *close, *goto_button;
};

struct _UrlClass
{
  GtkWindowClass parent_class;
};


enum { SEND_URL, RECEIVE_URL };

guint url_get_type(void);
GtkWidget* url_new(int type, unsigned long uin, char* nick);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __URL_H__ */
