//-< CONFIG.H >------------------------------------------------------*--------*
// GigaBASE                  Version 1.0         (c) 1999  GARRET    *     ?  *
// (Post Relational Database Management System)                      *   /\|  *
//                                                                   *  /  \  *
//                          Created:     21-Jan-2004  K.A. Knizhnik  * / [] \ *
//                          Last update: 21-Jan-2004  K.A. Knizhnik  * GARRET *
//-------------------------------------------------------------------*--------*
// GigaBASE configuration definitions
//-------------------------------------------------------------------*--------*

#ifndef __CONFIG_H__
#define __CONFIG_H__

// Use configuration file generated by configure script
#include "confdefs.h"

#ifndef AUTOCONFIG

// USE_LOCALE_SETTINGS - use C locale for string comparison operations
#ifndef _WIN32_WCE
#define USE_LOCALE_SETTINGS 1
#endif

// GIGABASE_DEBUG - debug level
//    - DEBUG_NONE - disable any checking and tracing (except asserts)
//    - DEBUG_CHECK - disable trace message
//    - DEBUG_TRACE - enable trace messages 
//#define GIGABASE_DEBUG DEBUG_TRACE

// USE_NAMESPACES - place GigaBASE classes in separate namespace  
//#define USE_NAMESPACES 1


// SECURE_SERVER - enable authentication for remote logins: keep user/password table, 
//   check password for remote logins
//#define SECURE_SERVER 1

// USE_QUEUE_MANAGER - use queue manager for internal HTTP server. 
//   This manager will manage pool of threads assigned for client connections. 
//   Otherwise all requests will be executed sequnetially in the main loop.
//#define USE_QUEUE_MANAGER 1


// GIGABASE_DLL - create gigabase.dll
//#define GIGABASE_DLL 1


// THROW_EXCEPTION_ON_ERROR - throw C++ exception in case of database error instead of abort()
#define THROW_EXCEPTION_ON_ERROR 1


//UNICODE - use wide character strings
//#define UNICODE 1


//USE_STD_STRING - accept std::string class as table field type
#ifdef _WIN32
#define USE_STD_STRING 1
#endif

//AUTOINCREMENT_SUPPORT - support autoincrement fields 
//  (database built with this flag will be incompatible with database built without it)
#define AUTOINCREMENT_SUPPORT 1

//CLONE_IDENTIFIERS - do not storef addresses of string constants in symbol table.
//  This option is needed if DLL library using GigaBASE can be unloaded.
//#define CLONE_IDENTIFIERS 1 

// RECTANGLE_DIMENSION - dimension of built-in rectangle type
#define RECTANGLE_DIMENSION 2

// RECTANGLE_COORDINATE_TYPE - type of rectanlge's coordinates
#define RECTANGLE_COORDINATE_TYPE int4

// RECTANGLE_AREA_TYPE - type of rectanlge's area
#define RECTANGLE_AREA_TYPE int8

//SET_NULL_DACL - use NULL DACL security descriptor for all synchronization objects.
//#define SET_NULL_DACL 1

//INT8_IS_DEFINED - int8 type is defined at your system, in this case you should use db_int8 type instead
//#define INT8_IS_DEFINED 1

//TRACES_TO_OUTPUT_DEBUG_STRING - output trace messages using OutputDebugString Win32 function
//#define TRACES_TO_OUTPUT_DEBUG_STRING 1

//USE_MFC - use MFC (include "afx.h" instead of "windows.h")
//#define USE_MFC 1

//USE_ATL - use Microsoft ATL 
//#define USE_ATL 1

//USE_MFC_STRING - accept MVC CString class as table field type
//#define USE_MFC_STRING


// LARGE_DATABASE_SUPPORT - support databases with size larger than 4Gb.
// If this macro is defined GigaBASE maximal database size is limited by 1 terrabyte.
// Defnining this macro increase iniitial database size and object index size (because
// 64-bit offsetss are used instead fo 4-byte offsets). Also GigaBASE library compiled with 
// LARGE_DATABASE_SUPPOR will not be able to work with database created by library
// built without LARGE_DATABASE_SUPPOR and visa versa. 
// #define LARGE_DATABASE_SUPPORT 

// SPARSE_FILE_OPTIMIZATION use optimization of sparse files at Windows. In a sparse file, 
// large ranges of zeroes may not require disk allocation. Space for nonzero data will be allocated 
// as needed as the file is written.
#define SPARSE_FILE_OPTIMIZATION true

#endif

#endif
