//-< TESTINDEX.CPP >-------------------------------------------------*--------*
// GigaBASE                  Version 1.0         (c) 1999  GARRET    *     ?  *
// (Post Relational Database Management System)                      *   /\|  *
//                                                                   *  /  \  *
//                          Created:     10-Dec-98    K.A. Knizhnik  * / [] \ *
//                          Last update: 20-Jan-99    K.A. Knizhnik  * GARRET *
//-------------------------------------------------------------------*--------*
// Performance test for index searches
//-------------------------------------------------------------------*--------*

#include "gigabase.h"
#include <stdio.h>

USE_GIGABASE_NAMESPACE

const int nRecords = 100000;

class Record {
  public:
    db_int8       intKey;
    char_t const* strKey;

    TYPE_DESCRIPTOR((KEY(intKey, INDEXED), KEY(strKey, INDEXED)));
};

REGISTER(Record);

#define GET_TIME() GetTickCount()

int __cdecl main(int argc, char* argv[])
{
    int i,  n;
    char_t  strKey[32];
    db_int8 intKey;

    dbDatabase db(dbDatabase::dbAllAccess, 4*1024); // 32Mb page pool
    if (db.open(_T("testindex.dbs"))) {
        dbQuery q1, q2;
        dbCursor<Record> cursor1;
        dbCursor<Record> cursor2;
        q1 = _T("intKey="),intKey;
        q2 = _T("strKey="),strKey;
        db_nat8 key = 1999;
        unsigned start = GET_TIME();
        for (i = 0; i < nRecords; i++) {
            Record rec;
            key = (3141592621u*key + 2718281829u) % 1000000007u;
            SPRINTF(strKey, T_INT8_FORMAT _T("."), key);
            rec.strKey = strKey;
            rec.intKey = (db_int8)key;
            insert(rec);
        }
        db.commit();
        printf("Elapsed time for inserting %d record: %d\n",
               nRecords, int(GET_TIME() - start));
        start = GET_TIME();
        key = 1999;
        for (i = 0; i < nRecords; i++) {
            key = (3141592621u*key + 2718281829u) % 1000000007u;
            SPRINTF(strKey, T_INT8_FORMAT _T("."), key);
            intKey = (db_int8)key;
            n = cursor1.select(q1);
            assert(n == 1);
            n = cursor2.select(q1);
            assert(n == 1);
            assert(cursor1.currentId() == cursor2.currentId());
        }
        printf("Elapsed time for %d index searches: %d\n",
               nRecords*2, int(GET_TIME() - start));
        start = GET_TIME();
        key = 1999;
        for (i = 0; i < nRecords; i++) {
            key = (3141592621u*key + 2718281829u) % 1000000007u;
            intKey = (db_int8)key;
            n = cursor1.select(q1, dbCursorForUpdate);
            assert(n == 1);
            cursor1.remove();
        }
        printf("Elapsed time for deleting all %d records: %d\n",
               nRecords, int(GET_TIME() - start));
        db.close();
        return EXIT_SUCCESS;
    } else {
        printf("Failed to open database\n");
        return EXIT_FAILURE;
    }
}




