/*
 * @(#)SortedMap.java	1.3 98/03/18
 *
 * Copyright 1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

package com.sun.java.util.collections; import java.util.*;

/**
 * A Map that further guarantees that it will be in ascending key order,
 * sorted according to the <i>natural sort method</i> of its keys (see
 * Comparable), or by a Comparator provided at SortedMap creation time.
 * This order is reflected in the SortedMap's Collection views.  Several
 * additional operations are provided to take advantage of the ordering.
 * (This interface is the Map analogue of SortedSet.)
 * <p>
 * All keys inserted into an SortedMap must implement the Comparable
 * interface.  Furthermore, all such keys must be <i>mutually comparable</i>:
 * k1.compareTo(k2) must not throw a typeMismatchException for any elements k1
 * and k2 in the SortedMap.  Attempts to violate this restriction will cause
 * the offending method or constructor invocation to throw a
 * ClassCastException.
 * <p>
 * All general-purpose SortedMap implementation classes should provide four
 * "standard" constructors: 1) A void (no arguments) constructor, which
 * creates an empty SortedMap sorted according to the <i>natural sort
 * method</i> of its keys.  2) A constructor with a single argument of type
 * Comparator, which creates an empty SortedMap sorted according to the
 * specified Comparator.  3) A constructor with a single argument of type Map,
 * which creates a new Map with the same key-value mappings as its argument,
 * sorted according to the keys' natural sort method.  4) A constructor with a
 * single argument of type SortedMap, which creates a new SortedMap with the
 * same key-value mappings and the same ordering as the input SortedMap.
 * There is no way to enforce this recommendation (as interfaces cannot
 * contain constructors) but the JDK implementation (TreeMap) complies.
 *
 * @author  Josh Bloch
 * @version 1.3 03/18/98
 * @see Map
 * @see TreeMap
 * @see SortedSet
 * @see Collection
 * @see ClassCastException
 * @since JDK1.2
 */

public interface SortedMap<A,B> extends Map<A,B> {
    /**
     * Returns the Comparator associated with this SortedMap, or null
     * if it uses its keys' natural sort method.
     *
     * @return the Comparator associated with this SortedMap, or null
     * 	       if it uses its keys' natural sort method.
     * @since JDK1.2
     */
    Comparator<A> comparator();

    /**
     * Returns a view of the portion of this SortedMap whose keys range
     * from fromKey, inclusive, to toKey, exclusive.  The returned SortedMap
     * is backed by this SortedMap, so changes in the returned SortedMap are
     * reflected in this SortedMap, and vice-versa.  The returned Map supports
     * all optional Map operations.
     * <p>
     * The Map returned by this method will throw an IllegalArgumentException
     * if the user attempts to insert a key outside the specified range.
     *
     * @param fromKey low endpoint (inclusive) of the subMap.
     * @param toKey high endpoint (exclusive) of the subMap.
     * @return a view of the specified range within this SortedMap.
     * @exception ClassCastException fromKey or toKey cannot be compared
     *		  with the keys currently in the SortedMap.
     * @exception NullPointerException fromKey or toKey is null and this
     *		  SortedMap does not tolerate null keys.
     * @exception IllegalArgumentException fromKey is greater than toKey.
     * @since JDK1.2
     */
    SortedMap<A,B> subMap(A fromKey, A toKey);

    /**
     * Returns a view of the portion of this SortedMap whose keys are
     * strictly less than toKey.  The returned SortedMap is backed by this
     * SortedMap, so changes in the returned SortedMap are reflected in this
     * SortedMap, and vice-versa.  The returned Map supports all optional Map
     * operations.
     *
     * The Map returned by this method will throw an IllegalArgumentException
     * if the user attempts to insert a key outside the specified range.
     *
     * @param toKey high endpoint (exclusive) of the subMap.
     * @return a view of the specified initial range of this SortedMap.
     * @exception ClassCastException toKey cannot be compared with the keys
     *		  currently in the SortedMap.
     * @exception NullPointerException toKey is null and this SortedMap
     *		  does not tolerate null keys.
     * @since JDK1.2
     */
    SortedMap<A,B> headMap(A toKey);

    /**
     * Returns a view of the portion of this SortedMap whose keys are greater
     * than or equal to fromKey.  The returned SortedMap is backed by this
     * SortedMap, so changes in the returned SortedMap are reflected in this
     * SortedMap, and vice-versa.  The returned Map supports all optional Map
     * operations.
     * <p>
     * The Map returned by this method will throw an IllegalArgumentException
     * if the user attempts to insert a key outside the specified range.
     *
     * @param toKey high endpoint (exclusive) of the subMap.
     * @return a view of the specified final range of this SortedMap.
     * @exception ClassCastException toKey cannot be compared with the keys
     *		  currently in the SortedMap.
     * @exception NullPointerException fromKey is null and this SortedMap
     *		  does not tolerate null keys.
     * @since JDK1.2
     */
    SortedMap<A,B> tailMap(A fromKey);

    /**
     * Returns the first (lowest) key currently in this SortedMap.
     *
     * @return the first (lowest) key currently in this SortedMap.
     * @exception IllegalStateException Map is empty.
     * @since JDK1.2
     */
    A firstKey();

    /**
     * Returns the last (highest) key currently in this SortedMap.
     *
     * @return the last (highest) key currently in this SortedMap.
     * @exception IllegalStateException Map is empty.
     * @since JDK1.2
     */
    A lastKey();
}
